#include<array.au3>
#NoTrayIcon
install()
global $eciDll = dllOpen("eci.dll")
enum $eciSynthMode, $eciInputType, $eciTextMode, $eciDictionary
func install()
FileInstall("c:\eci\eci.dll",@ScriptDir & "\eci.dll",0)
FileInstall("c:\eci\eci.ini",@ScriptDir & "\eci.ini",0)
FileInstall("c:\eci\enu.syn",@ScriptDir & "\ENU.SYN",0)
endFunc
Func eciNew()
$r = dllCall($eciDll, "long", "eciNew")
return $r[0]
endFunc
func eciAddText($h, $text)
dllCall($eciDll, "long", "eciAddText", "long", $h, "str", $text)
endFunc
func eciSynthesize($h)
dllCall($eciDll, "long", "eciSynthesize", "long", $h)
endFunc
func eciSynchronize($h)
dllCall($eciDll, "long", "eciSynchronize", "long", $h)
endFunc
func eciSetParam($h, $p, $v)
$r = dllCall($eciDll, "long", "eciSetParam", "long", $h, "long", $p, "long", $v)
return $r[0]
endFunc
$h = eciNew()
;set input type to allow annotated commands
eciSetParam($h, $eciInputType, 1)
FUNC EciSayEng($rate,$text)
eciAddText($h,"`vs"&$rate&" "&$text)
eciSynthesize($h)
eciSynchronize($h)
endfunc
FUNC EciSaySp($rate,  $text)
eciAddText($h,"`vs"&$rate&"`l2"&$text)
eciSynthesize($h)
eciSynchronize($h)
endfunc
func EciSay($lang,$text)
	if $lang = 1 Then
		EciSayEng(65,$text)
		Else
		EciSaySp(65,$text)
	EndIf
EndFunc
