/*
 * Decompiled with CFR 0.152.
 */
package org.clapper.util.misc;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class MultiValueMap<K, V>
extends AbstractMap<K, V>
implements Cloneable {
    private Map<K, Collection<V>> map = null;
    private ValuesCollectionAllocator<V> valuesCollectionAllocator = new ValuesCollectionAllocator<V>(){

        @Override
        public Collection<V> newValuesCollection() {
            return new ArrayList();
        }
    };

    public MultiValueMap() {
        this.map = new HashMap<K, Collection<V>>();
    }

    public MultiValueMap(ValuesCollectionAllocator<V> valuesCollectionAllocator) {
        this.map = new HashMap<K, Collection<V>>();
        this.valuesCollectionAllocator = valuesCollectionAllocator;
    }

    public MultiValueMap(int initialCapacity, float loadFactor) {
        this.map = new HashMap<K, Collection<V>>(initialCapacity, loadFactor);
    }

    public MultiValueMap(int initialCapacity, float loadFactor, ValuesCollectionAllocator<V> valuesCollectionAllocator) {
        this.map = new HashMap<K, Collection<V>>(initialCapacity, loadFactor);
        this.valuesCollectionAllocator = valuesCollectionAllocator;
    }

    public MultiValueMap(int initialCapacity) {
        this.map = new HashMap<K, Collection<V>>(initialCapacity);
    }

    public MultiValueMap(MultiValueMap<K, V> otherMap) {
        super.makeShallowCopyInto(this);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        MultiValueMap<K, V> newMap = new MultiValueMap<K, V>();
        this.makeShallowCopyInto(newMap);
        return newMap;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        boolean found = false;
        Iterator<Collection<V>> it = this.map.values().iterator();
        while (!found && it.hasNext()) {
            Collection<V> values = it.next();
            if (!values.contains(value)) continue;
            found = true;
        }
        return found;
    }

    public boolean containsKeyValue(K key, V value) {
        boolean found;
        block1: {
            V possibleValue;
            found = false;
            Collection<V> values = this.getCollection(key);
            if (values == null) break block1;
            Iterator<V> iterator = values.iterator();
            while (iterator.hasNext() && !(found = value.equals(possibleValue = iterator.next()))) {
            }
        }
        return found;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new EntrySet();
    }

    @Override
    public boolean equals(Object o) {
        boolean eq = false;
        if (o instanceof MultiValueMap) {
            eq = ((MultiValueMap)o).entrySet().equals(this.entrySet());
        }
        return eq;
    }

    public Collection<V> getCollection(K key) {
        Collection<V> values = this.map.get(key);
        if (values != null) {
            values = Collections.unmodifiableCollection(values);
        }
        return values;
    }

    @Override
    public V get(Object key) {
        V result = null;
        Collection<V> values = this.map.get(key);
        if (values != null) {
            result = values.iterator().next();
        }
        return result;
    }

    public V getFirstValueForKey(K key) {
        Iterator<V> it;
        V result = null;
        Collection<V> values = this.map.get(key);
        if (values != null && (it = values.iterator()).hasNext()) {
            result = it.next();
        }
        return result;
    }

    @Override
    public int hashCode() {
        Set<Map.Entry<K, V>> entries = this.entrySet();
        int result = 0;
        for (Map.Entry<K, V> entry : entries) {
            result |= entry.hashCode();
        }
        return result;
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    public V put(K key, V value) {
        Collection<V> values = this.map.get(key);
        if (values == null) {
            values = this.valuesCollectionAllocator.newValuesCollection();
            this.map.put(key, values);
        }
        values.add(value);
        return null;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> fromMap) {
        for (K key : fromMap.keySet()) {
            V value = fromMap.get(key);
            if (value == null) continue;
            this.put(key, value);
        }
    }

    @Override
    public void putAll(MultiValueMap<K, V> fromMap) {
        for (K key : fromMap.keySet()) {
            Collection<V> values = fromMap.getCollection(key);
            if (values == null) continue;
            for (V value : values) {
                this.put(key, value);
            }
        }
    }

    public void putAll(K key, Collection<V> values) {
        for (V value : values) {
            this.put(key, value);
        }
    }

    public Collection<V> delete(K key) {
        return this.map.remove(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object key, Object value) {
        boolean removed = false;
        MultiValueMap multiValueMap = this;
        synchronized (multiValueMap) {
            Collection<V> values = this.map.get(key);
            if (values != null) {
                removed = values.remove(value);
                if (values.size() == 0) {
                    this.map.remove(key);
                }
            }
        }
        return removed;
    }

    @Override
    public int size() {
        int total = 0;
        for (K key : this.keySet()) {
            Collection<V> valuesForKey = this.map.get(key);
            if (valuesForKey == null) continue;
            total += valuesForKey.size();
        }
        return total;
    }

    public int totalValuesForKey(K key) {
        int total = 0;
        Collection<V> values = this.getCollection(key);
        if (values != null) {
            total = values.size();
        }
        return total;
    }

    @Override
    public Collection<V> values() {
        ArrayList<V> result = new ArrayList<V>();
        for (K key : this.keySet()) {
            result.addAll(this.getCollection(key));
        }
        return result;
    }

    public Collection<V> getValuesForKey(K key) {
        Collection<V> values = this.getCollection(key);
        if (values != null) {
            values = Collections.unmodifiableCollection(values);
        }
        return values;
    }

    public int getValuesForKey(K key, Collection<V> values) {
        Collection<V> valuesForKey = this.map.get(key);
        int total = 0;
        if (valuesForKey != null) {
            values.addAll(valuesForKey);
            total = valuesForKey.size();
        }
        return total;
    }

    private int keyValueHashCode(Object key, Object value) {
        if (value == null) {
            value = "\u0002";
        }
        return new String(key.toString() + "\u0001" + value.toString()).hashCode();
    }

    private void makeShallowCopyInto(MultiValueMap<K, V> otherMap) {
        for (K key : this.map.keySet()) {
            Collection<V> values = this.map.get(key);
            Collection<V> newValues = this.valuesCollectionAllocator.newValuesCollection();
            newValues.addAll(values);
            otherMap.map.put(key, newValues);
        }
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        public boolean contains(Map.Entry<K, V> o) {
            return MultiValueMap.this.containsKeyValue(o.getKey(), o.getValue());
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new MultiValueMapEntryIterator();
        }

        @Override
        public boolean remove(Object o) {
            MultiValueMapEntry entry = (MultiValueMapEntry)o;
            return MultiValueMap.this.remove(entry.getKey(), entry.getValue());
        }

        @Override
        public int size() {
            return MultiValueMap.this.size();
        }
    }

    private class MultiValueMapEntryIterator
    implements Iterator<Map.Entry<K, V>> {
        private Iterator<K> keys;
        private Iterator<V> curValues;
        private MultiValueMapEntry lastReturned;

        MultiValueMapEntryIterator() {
            this.keys = MultiValueMap.this.keySet().iterator();
            this.curValues = null;
            this.lastReturned = null;
        }

        @Override
        public boolean hasNext() {
            boolean has;
            boolean bl = has = this.curValues != null && this.curValues.hasNext();
            if (!has) {
                has = this.keys.hasNext();
            }
            return has;
        }

        @Override
        public Map.Entry<K, V> next() {
            MultiValueMapEntry result = null;
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (this.curValues == null || !this.curValues.hasNext()) {
                Object key = this.keys.next();
                this.curValues = MultiValueMap.this.getCollection(key).iterator();
                Object value = this.curValues.next();
                result = this.lastReturned = new MultiValueMapEntry(key, value);
            }
            return result;
        }

        @Override
        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException("Nothing to remove");
            }
            MultiValueMap.this.remove(this.lastReturned.getKey(), this.lastReturned.getValue());
        }
    }

    private class MultiValueMapEntry
    implements Map.Entry<K, V> {
        private K key;
        private V value;

        MultiValueMapEntry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public boolean equals(Object o) {
            boolean eq = false;
            if (o instanceof Map.Entry) {
                Map.Entry other = (Map.Entry)o;
                eq = other.getKey().equals(this.key) && other.getValue().equals(this.value);
            }
            return eq;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public int hashCode() {
            return MultiValueMap.this.keyValueHashCode(this.key, this.value);
        }

        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException();
        }
    }

    public static interface ValuesCollectionAllocator<V> {
        public Collection<V> newValuesCollection();
    }
}

