/*
 * Decompiled with CFR 0.152.
 */
package org.clapper.util.misc;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.clapper.util.misc.ObjectRemovalEvent;
import org.clapper.util.misc.ObjectRemovalListener;

public class LRUMap<K, V>
extends AbstractMap<K, V>
implements Cloneable,
Serializable {
    public static final float DEFAULT_LOAD_FACTOR = 0.75f;
    public static final int DEFAULT_INITIAL_CAPACITY = 16;
    private static final long serialVersionUID = 1L;
    private int maxCapacity;
    private float loadFactor;
    private int initialCapacity;
    private EntryMap hash;
    private LRULinkedList lruQueue;
    private ListenerMap removalListeners = null;

    public LRUMap(int maxCapacity) {
        this(16, 0.75f, maxCapacity);
    }

    public LRUMap(int initialCapacity, int maxCapacity) {
        this(initialCapacity, 0.75f, maxCapacity);
    }

    public LRUMap(int initialCapacity, float loadFactor, int maxCapacity) {
        assert (maxCapacity > 0);
        assert ((double)loadFactor > 0.0);
        assert (initialCapacity > 0);
        if (initialCapacity > maxCapacity) {
            initialCapacity = maxCapacity;
        }
        this.maxCapacity = maxCapacity;
        this.loadFactor = loadFactor;
        this.initialCapacity = initialCapacity;
        this.hash = new EntryMap(initialCapacity, loadFactor);
        this.lruQueue = new LRULinkedList();
    }

    public LRUMap(LRUMap<? extends K, ? extends V> map) {
        this(map.initialCapacity, map.loadFactor, map.maxCapacity);
        super.doPutAll(map);
    }

    public synchronized void addRemovalListener(ObjectRemovalListener listener, boolean automaticOnly) {
        if (this.removalListeners == null) {
            this.removalListeners = new ListenerMap();
        }
        this.removalListeners.put(listener, new RemovalListenerWrapper(listener, automaticOnly));
    }

    public synchronized boolean removeRemovalListener(ObjectRemovalListener listener) {
        boolean removed = false;
        if (this.removalListeners != null && this.removalListeners.remove(listener) != null) {
            removed = true;
        }
        return removed;
    }

    @Override
    public void clear() {
        this.hash.clear();
        this.lruQueue.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.hash.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        boolean contains = false;
        for (LRULinkedListEntry entry : this.hash.values()) {
            if (!entry.getValue().equals(value)) continue;
            contains = true;
            break;
        }
        return contains;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new EntrySet();
    }

    @Override
    public V get(Object key) {
        V value = null;
        LRULinkedListEntry entry = (LRULinkedListEntry)this.hash.get(key);
        if (entry != null) {
            assert (entry.key.equals(key)) : "entry.key=" + entry.key + ", key=" + key;
            this.lruQueue.moveToHead(entry);
            value = entry.value;
        }
        return value;
    }

    public int getInitialCapacity() {
        return this.initialCapacity;
    }

    public float getLoadFactor() {
        return this.loadFactor;
    }

    public int getMaximumCapacity() {
        return this.maxCapacity;
    }

    @Override
    public boolean isEmpty() {
        return this.hash.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        return new KeySet();
    }

    @Override
    public V put(K key, V value) {
        return this.doPut(key, value);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        this.doPutAll(map);
    }

    @Override
    public V remove(Object key) {
        V value = null;
        LRULinkedListEntry entry = (LRULinkedListEntry)this.hash.remove(key);
        if (entry != null) {
            value = entry.value;
            this.lruQueue.remove(entry);
            this.callRemovalListeners(key, value, false);
        }
        assert (this.hash.size() == this.lruQueue.size);
        return value;
    }

    public int setMaximumCapacity(int newCapacity) {
        assert (newCapacity > 0);
        int oldCapacity = this.maxCapacity;
        this.clearTo(newCapacity);
        this.maxCapacity = newCapacity;
        return oldCapacity;
    }

    @Override
    public int size() {
        return this.lruQueue.size;
    }

    @Override
    public Collection<V> values() {
        return new ValueSet();
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        return new LRUMap<K, V>(this);
    }

    private LRULinkedListEntry clearTo(int size) {
        assert (this.hash.size() == this.lruQueue.size);
        LRULinkedListEntry oldTail = null;
        while (this.lruQueue.size > size) {
            oldTail = this.lruQueue.removeTail();
            assert (oldTail != null);
            Object key = oldTail.key;
            LRULinkedListEntry rem = (LRULinkedListEntry)this.hash.remove(key);
            assert (rem != null);
            assert (rem.key == key);
            this.callRemovalListeners(key, rem.value, true);
        }
        assert (this.lruQueue.size <= size);
        assert (this.hash.size() == this.lruQueue.size);
        return oldTail;
    }

    private synchronized void callRemovalListeners(final Object key, final Object value, boolean automatic) {
        if (this.removalListeners != null) {
            for (RemovalListenerWrapper l : this.removalListeners.values()) {
                if (!automatic && l.automaticOnly) continue;
                Map.Entry entry = new Map.Entry(){

                    @Override
                    public boolean equals(Object o) {
                        return false;
                    }

                    public Object getKey() {
                        return key;
                    }

                    public Object getValue() {
                        return value;
                    }

                    @Override
                    public int hashCode() {
                        return key.hashCode();
                    }

                    public Object setValue(Object val) {
                        return null;
                    }
                };
                l.objectRemoved(new ObjectRemovalEvent(entry));
            }
        }
    }

    private void doPutAll(Map<? extends K, ? extends V> map) {
        for (K key : map.keySet()) {
            V value = map.get(key);
            this.doPut(key, value);
        }
    }

    private V doPut(K key, V value) {
        V oldValue = null;
        LRULinkedListEntry entry = (LRULinkedListEntry)this.hash.get(key);
        if (entry == null) {
            entry = this.clearTo(this.maxCapacity - 1);
            if (entry == null) {
                entry = new LRULinkedListEntry(key, value);
            } else {
                entry.setKeyValue(key, value);
            }
            this.lruQueue.addToHead(entry);
            this.hash.put(key, entry);
        } else {
            oldValue = entry.value;
            entry.value = value;
            this.lruQueue.moveToHead(entry);
        }
        return oldValue;
    }

    private class EntryMap
    extends HashMap<K, LRULinkedListEntry> {
        EntryMap(int initialCapacity, float loadFactor) {
            super(initialCapacity, loadFactor);
        }
    }

    private class ListenerMap
    extends HashMap<ObjectRemovalListener, RemovalListenerWrapper> {
        ListenerMap() {
        }
    }

    private static class RemovalListenerWrapper
    implements ObjectRemovalListener {
        boolean automaticOnly;
        ObjectRemovalListener realListener;

        RemovalListenerWrapper(ObjectRemovalListener realListener, boolean automaticOnly) {
            this.realListener = realListener;
            this.automaticOnly = automaticOnly;
        }

        @Override
        public void objectRemoved(ObjectRemovalEvent event) {
            this.realListener.objectRemoved(event);
        }
    }

    private class LRULinkedList {
        LRULinkedListEntry head = null;
        LRULinkedListEntry tail = null;
        int size = 0;

        private LRULinkedList() {
        }

        protected void finalize() throws Throwable {
            this.clear();
            super.finalize();
        }

        void addToTail(LRULinkedListEntry entry) {
            entry.next = null;
            entry.previous = this.tail;
            if (this.head == null) {
                this.head = entry;
                this.tail = entry;
            } else {
                entry.previous = this.tail;
                this.tail.next = entry;
            }
            ++this.size;
        }

        void addToHead(LRULinkedListEntry entry) {
            entry.next = null;
            entry.previous = null;
            if (this.head == null) {
                assert (this.tail == null);
                this.head = entry;
                this.tail = entry;
            } else {
                entry.next = this.head;
                this.head.previous = entry;
                this.head = entry;
            }
            ++this.size;
        }

        void remove(LRULinkedListEntry entry) {
            if (entry.next != null) {
                entry.next.previous = entry.previous;
            }
            if (entry.previous != null) {
                entry.previous.next = entry.next;
            }
            if (entry == this.head) {
                this.head = entry.next;
            }
            if (entry == this.tail) {
                this.tail = entry.previous;
            }
            entry.next = null;
            entry.previous = null;
            --this.size;
            assert (this.size >= 0);
        }

        LRULinkedListEntry removeTail() {
            LRULinkedListEntry result = this.tail;
            if (result != null) {
                this.remove(result);
            }
            return result;
        }

        void moveToHead(LRULinkedListEntry entry) {
            this.remove(entry);
            this.addToHead(entry);
        }

        void clear() {
            while (this.head != null) {
                LRULinkedListEntry next = this.head.next;
                this.head.next = null;
                this.head.previous = null;
                this.head.key = null;
                this.head.value = null;
                this.head = next;
            }
            this.tail = null;
            this.size = 0;
        }
    }

    private final class LRULinkedListEntry
    implements Map.Entry<K, V> {
        LRULinkedListEntry previous = null;
        LRULinkedListEntry next = null;
        K key = null;
        V value = null;

        LRULinkedListEntry(K key, V value) {
            this.setKeyValue(key, value);
        }

        @Override
        public boolean equals(Object o) {
            return LRULinkedListEntry.class.isInstance(o);
        }

        @Override
        public int hashCode() {
            return this.key.hashCode();
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        void setKeyValue(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public V setValue(V value) {
            Object oldValue = this.value;
            this.value = value;
            return oldValue;
        }
    }

    private class ValueSetIterator
    implements Iterator<V> {
        private LRULinkedListEntry current;

        ValueSetIterator() {
            this.current = ((LRUMap)LRUMap.this).lruQueue.head;
        }

        @Override
        public V next() {
            LRULinkedListEntry result = this.current;
            this.current = this.current.next;
            return result.value;
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class ValueSet
    extends AbstractSet<V> {
        private ValueSet() {
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean contains(Object o) {
            return LRUMap.this.containsValue(o);
        }

        @Override
        public boolean containsAll(Collection c) {
            boolean contains = true;
            for (Object o : c) {
                if (this.contains(o)) continue;
                contains = false;
                break;
            }
            return contains;
        }

        @Override
        public boolean isEmpty() {
            return LRUMap.this.isEmpty();
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueSetIterator();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return LRUMap.this.size();
        }
    }

    private class KeySetIterator
    implements Iterator<K> {
        private LRULinkedListEntry current;

        KeySetIterator() {
            this.current = ((LRUMap)LRUMap.this).lruQueue.head;
        }

        @Override
        public K next() {
            LRULinkedListEntry result = this.current;
            this.current = this.current.next;
            return result.key;
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class KeySet
    extends AbstractSet<K> {
        private KeySet() {
        }

        @Override
        public Iterator<K> iterator() {
            return new KeySetIterator();
        }

        @Override
        public boolean contains(Object key) {
            return LRUMap.this.containsKey(key);
        }

        @Override
        public boolean remove(Object key) {
            return LRUMap.this.remove(key) != null;
        }

        @Override
        public int size() {
            return LRUMap.this.size();
        }

        @Override
        public void clear() {
            LRUMap.this.clear();
        }
    }

    private class EntryIterator
    implements Iterator<LRULinkedListEntry> {
        private LRULinkedListEntry current;

        EntryIterator() {
            this.current = ((LRUMap)LRUMap.this).lruQueue.head;
        }

        @Override
        public LRULinkedListEntry next() {
            LRULinkedListEntry result = this.current;
            this.current = this.current.next;
            return result;
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new Iterator<Map.Entry<K, V>>(){
                EntryIterator it;
                {
                    this.it = new EntryIterator();
                }

                @Override
                public Map.Entry<K, V> next() {
                    return this.it.next();
                }

                @Override
                public boolean hasNext() {
                    return this.it.hasNext();
                }

                @Override
                public void remove() {
                    this.it.remove();
                }
            };
        }

        @Override
        public boolean contains(Object o) {
            boolean has = false;
            if (o instanceof Map.Entry) {
                Map.Entry e = (Map.Entry)o;
                Object key = e.getKey();
                has = LRUMap.this.containsKey(key);
            }
            return has;
        }

        @Override
        public boolean remove(Object o) {
            return LRUMap.this.remove(o) != null;
        }

        @Override
        public int size() {
            return LRUMap.this.size();
        }

        @Override
        public void clear() {
            LRUMap.this.clear();
        }
    }
}

