/*
 * Decompiled with CFR 0.152.
 */
package org.clapper.util.misc;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeSet;
import org.clapper.util.logging.Logger;
import org.clapper.util.misc.FileHashMapEntry;
import org.clapper.util.misc.ObjectExistsException;
import org.clapper.util.misc.VersionMismatchException;

public class FileHashMap<K, V>
extends AbstractMap<K, V> {
    public static final String INDEX_FILE_SUFFIX = ".ix";
    public static final String DATA_FILE_SUFFIX = ".db";
    public static final int NO_CREATE = 1;
    public static final int TRANSIENT = 2;
    public static final int FORCE_OVERWRITE = 4;
    public static final int RECLAIM_FILE_GAPS = 8;
    private static final String VERSION_STAMP = "org.clapper.util.misc.FileHashMap-1.0";
    private static final int ALL_FLAGS_MASK = 15;
    private HashMap<K, FileHashMapEntry<K>> indexMap = null;
    private String filePrefix = null;
    private File indexFilePath = null;
    private File valuesDBPath = null;
    private ValuesFile valuesDB = null;
    private int flags = 0;
    private boolean modified = false;
    private boolean valid = true;
    private EntrySet entrySetResult = null;
    private TreeSet<FileHashMapEntry<K>> fileGaps = null;
    private static final Logger log = new Logger(FileHashMap.class);

    public FileHashMap() throws IOException {
        this(null);
    }

    public FileHashMap(String tempFilePrefix) throws IOException {
        this.flags = 2;
        this.filePrefix = tempFilePrefix;
        if (this.filePrefix == null) {
            this.filePrefix = "fmh";
        }
        this.valuesDBPath = File.createTempFile(this.filePrefix, DATA_FILE_SUFFIX);
        this.valuesDBPath.deleteOnExit();
        this.createNewMap(this.valuesDBPath);
    }

    public FileHashMap(String pathPrefix, int flags) throws FileNotFoundException, ObjectExistsException, ClassNotFoundException, VersionMismatchException, IOException {
        assert ((0xFFFFFFF0 & flags) == 0);
        int filesFound = 0;
        this.filePrefix = pathPrefix;
        this.flags = flags;
        this.valuesDBPath = new File(pathPrefix + DATA_FILE_SUFFIX);
        this.indexFilePath = new File(pathPrefix + INDEX_FILE_SUFFIX);
        if ((flags & 2) != 0) {
            flags &= 0xFFFFFFFE;
        }
        if (this.valuesDBPath.exists()) {
            ++filesFound;
        }
        if (this.indexFilePath.exists()) {
            ++filesFound;
        }
        if (filesFound > 0 && (flags & 2) != 0) {
            if ((flags & 4) == 0) {
                throw new ObjectExistsException("org.clapper.util.misc.Bundle", "FileHashMap.diskFilesExist", "One or both of the hash table files (\"{0}\" and/or \"{1}\") already exists, but the FileHashMap.FORCE_OVERWRITE constructor flag was not set.", new Object[]{this.valuesDBPath.getName(), this.indexFilePath.getName()});
            }
            this.valuesDBPath.delete();
            this.indexFilePath.delete();
            filesFound = 0;
        }
        switch (filesFound) {
            case 0: {
                if ((flags & 1) != 0) {
                    throw new FileNotFoundException("On-disk hash table \"" + pathPrefix + "\" does not exist, and the FileHashMap.NO_CREATE flag was set.");
                }
                this.createNewMap(this.valuesDBPath);
                break;
            }
            case 1: {
                throw new ObjectExistsException("org.clapper.util.misc.Bundle", "FileHashMap.halfMissing", "One of the hash table files exists (\"{0}\" or \"{1}\") exists, but the other one does not.", new Object[]{this.valuesDBPath.getName(), this.indexFilePath.getName()});
            }
            case 2: {
                this.valuesDB = new ValuesFile(this.valuesDBPath);
                this.loadIndex();
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        if ((flags & 8) != 0) {
            this.findFileGaps();
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        catch (IOException ex) {
            log.error("Error during finalize", ex);
        }
        super.finalize();
    }

    @Override
    public synchronized void clear() {
        this.checkValidity();
        this.indexMap.clear();
        try {
            this.valuesDB.getFile().getChannel().truncate(0L);
            this.modified = true;
        }
        catch (IOException ex) {
            log.error("Failed to truncate FileHashMap file \"" + this.valuesDBPath.getPath() + "\"", ex);
            this.valid = false;
        }
    }

    public synchronized void close() throws NotSerializableException, IOException {
        if (this.valid) {
            if ((this.flags & 2) != 0) {
                if (this.valuesDB != null) {
                    this.valuesDB.close();
                    this.valuesDB = null;
                }
                this.deleteMapFiles();
            } else {
                this.save();
            }
            this.valid = false;
        }
    }

    @Override
    public boolean containsKey(Object key) {
        this.checkValidity();
        return this.indexMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        this.checkValidity();
        return new ValueSet().contains(value);
    }

    public void delete() {
        try {
            this.close();
        }
        catch (NotSerializableException notSerializableException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.deleteMapFiles();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        this.checkValidity();
        if (this.entrySetResult == null) {
            this.entrySetResult = new EntrySet();
        }
        return this.entrySetResult;
    }

    @Override
    public boolean equals(Object o) {
        this.checkValidity();
        return super.equals(o);
    }

    @Override
    public V get(Object key) {
        this.checkValidity();
        V result = null;
        FileHashMapEntry<K> entry = this.indexMap.get(key);
        if (entry != null) {
            result = this.readValueNoError(entry);
        }
        return result;
    }

    @Override
    public int hashCode() {
        this.checkValidity();
        return super.hashCode();
    }

    public boolean isValid() {
        return this.valid;
    }

    @Override
    public Set<K> keySet() {
        this.checkValidity();
        return new KeySet();
    }

    @Override
    public V put(K key, V value) throws ClassCastException, IllegalArgumentException, NullPointerException {
        this.checkValidity();
        V result = null;
        if (key == null) {
            throw new NullPointerException("null key parameter");
        }
        if (value == null) {
            throw new NullPointerException("null value parameter");
        }
        if (!(value instanceof Serializable)) {
            throw new IllegalArgumentException("Value is not serializable.");
        }
        try {
            FileHashMapEntry<K> old = this.indexMap.get(key);
            if (old != null) {
                result = this.readValueNoError(old);
                this.remove(key);
            }
            FileHashMapEntry<K> entry = this.writeValue(key, value);
            this.indexMap.put(key, entry);
            this.modified = true;
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Error saving value: " + ex.getMessage());
        }
        return result;
    }

    @Override
    public V remove(Object key) {
        this.checkValidity();
        V result = null;
        if (this.indexMap.containsKey(key)) {
            FileHashMapEntry<K> entry = this.indexMap.get(key);
            result = this.readValueNoError(entry);
            this.indexMap.remove(key);
            this.modified = true;
            if ((this.flags & 8) != 0) {
                log.debug("Removed value for key \"" + key + "\" at pos=" + entry.getFilePosition() + ", size=" + entry.getObjectSize() + ". Re-figuring gaps.");
                this.findFileGaps();
            }
        }
        return result;
    }

    public void save() throws IOException, NotSerializableException {
        this.checkValidity();
        if ((this.flags & 2) == 0 && this.modified) {
            this.saveIndex();
        }
    }

    @Override
    public int size() {
        this.checkValidity();
        return this.currentSize();
    }

    @Override
    public Collection<V> values() {
        this.checkValidity();
        return new ValueSet();
    }

    private void checkValidity() {
        if (!this.valid) {
            throw new IllegalStateException("Invalid FileHashMap object");
        }
    }

    private void createNewMap(File valuesDBPath) throws IOException {
        this.valuesDB = new ValuesFile(valuesDBPath);
        this.indexMap = new HashMap();
    }

    private int currentSize() {
        return this.indexMap.size();
    }

    private void findFileGaps() {
        log.debug("Looking for file gaps.");
        if (this.fileGaps == null) {
            this.fileGaps = new TreeSet(new FileHashMapEntryGapComparator());
        } else {
            this.fileGaps.clear();
        }
        if (this.currentSize() > 0) {
            List<FileHashMapEntry<K>> entries = this.getSortedEntries();
            FileHashMapEntry<K> previous = null;
            Iterator<FileHashMapEntry<K>> it = entries.iterator();
            FileHashMapEntry<K> entry = it.next();
            long pos = entry.getFilePosition();
            int size = entry.getObjectSize();
            if (pos > 0L) {
                log.debug("First entry is at pos " + pos + ", size=" + size);
                size = (int)pos;
                log.debug("Gap at position 0 of size " + size);
                this.fileGaps.add(new FileHashMapEntry(0L, size));
            }
            previous = entry;
            while (it.hasNext()) {
                entry = it.next();
                long previousPos = previous.getFilePosition();
                long possibleGapPos = previousPos + (long)previous.getObjectSize();
                pos = entry.getFilePosition();
                assert (pos > previousPos);
                if (possibleGapPos != pos) {
                    int gapSize = (int)(pos - possibleGapPos);
                    log.debug("Gap at position " + possibleGapPos + " of size " + gapSize);
                    this.fileGaps.add(new FileHashMapEntry(possibleGapPos, gapSize));
                }
                previous = entry;
            }
        }
    }

    private List<FileHashMapEntry<K>> getSortedEntries() {
        ArrayList<FileHashMapEntry<K>> vals = new ArrayList<FileHashMapEntry<K>>();
        vals.addAll(this.indexMap.values());
        Collections.sort(vals, new FileHashMapEntryComparator());
        return vals;
    }

    private void loadIndex() throws IOException, ClassNotFoundException, VersionMismatchException {
        ObjectInputStream objStream = new ObjectInputStream(new FileInputStream(this.indexFilePath));
        String version = (String)objStream.readObject();
        if (!version.equals(VERSION_STAMP)) {
            throw new VersionMismatchException("org.clapper.util.misc.Bundle", "FileHashMap.versionMismatch", "FileHashMap version mismatch in index file \"{0}\". Expected version \"{1}\", found version \"{2}\"", new Object[]{this.indexFilePath.getName(), VERSION_STAMP, version}, VERSION_STAMP, version);
        }
        this.indexMap = (HashMap)objStream.readObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private V readValue(FileHashMapEntry<K> entry) throws IOException, ClassNotFoundException, IllegalStateException {
        int size = entry.getObjectSize();
        byte[] byteBuf = new byte[size];
        FileHashMap fileHashMap = this;
        synchronized (fileHashMap) {
            RandomAccessFile valuesFile = this.valuesDB.getFile();
            valuesFile.seek(entry.getFilePosition());
            int sizeRead = valuesFile.read(byteBuf);
            if (sizeRead != size) {
                throw new IOException("Expected to read " + size + "-byte serialized object from  on-disk data file. Got only " + sizeRead + " bytes.");
            }
        }
        ObjectInputStream objStream = new ObjectInputStream(new ByteArrayInputStream(byteBuf));
        return (V)objStream.readObject();
    }

    private V readValueNoError(FileHashMapEntry<K> entry) {
        V obj = null;
        try {
            obj = this.readValue(entry);
        }
        catch (IOException iOException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return obj;
    }

    private synchronized void saveIndex() throws IOException {
        ObjectOutputStream objStream = new ObjectOutputStream(new FileOutputStream(this.indexFilePath));
        objStream.writeObject(VERSION_STAMP);
        objStream.writeObject(this.indexMap);
        if (log.isDebugEnabled()) {
            List<FileHashMapEntry<K>> entries = this.getSortedEntries();
            log.debug("Just saved index. Total entries=" + this.currentSize());
            log.debug("Index values follow.");
            for (FileHashMapEntry<K> entry : entries) {
                long pos = entry.getFilePosition();
                int size = entry.getObjectSize();
                log.debug("    pos=" + pos + ", size=" + size);
            }
        }
    }

    private synchronized FileHashMapEntry<K> writeValue(K key, V obj) throws IOException, NotSerializableException {
        long filePos = -1L;
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        ObjectOutputStream objStream = new ObjectOutputStream(byteStream);
        objStream.writeObject(obj);
        int size = byteStream.size();
        if ((this.flags & 8) != 0) {
            filePos = this.findBestFitGap(size);
        }
        RandomAccessFile valuesFile = this.valuesDB.getFile();
        if (filePos == -1L) {
            filePos = valuesFile.length();
        }
        valuesFile.seek(filePos);
        valuesFile.write(byteStream.toByteArray());
        return new FileHashMapEntry<K>(filePos, size, key);
    }

    private long findBestFitGap(int objectSize) {
        long result = -1L;
        log.debug("Finding smallest gap for " + objectSize + "-byte object");
        assert (this.fileGaps != null);
        Iterator<FileHashMapEntry<K>> it = this.fileGaps.iterator();
        while (it.hasNext()) {
            FileHashMapEntry<K> gap = it.next();
            long pos = gap.getFilePosition();
            int size = gap.getObjectSize();
            log.debug("Gap: pos=" + pos + ", size=" + size);
            if (size < objectSize) continue;
            log.debug("Found it.");
            result = pos;
            if (size <= objectSize) break;
            log.debug("Gap size is larger than required. Making smaller gap.");
            it.remove();
            gap.setFilePosition(pos += (long)objectSize);
            gap.setObjectSize(size -= objectSize);
            log.debug("Saving new, smaller gap: pos=" + pos + ", size=" + size);
            this.fileGaps.add(gap);
            break;
        }
        log.debug("findBestFitGap: returning " + result);
        return result;
    }

    private void deleteMapFiles() {
        if (this.valuesDBPath != null) {
            this.valuesDBPath.delete();
            this.valuesDBPath = null;
        }
        if (this.indexFilePath != null) {
            this.indexFilePath.delete();
            this.indexFilePath = null;
        }
    }

    private class KeySet
    extends AbstractSet<K> {
        ArrayList<K> keys = null;

        private KeySet() {
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean contains(Object o) {
            return FileHashMap.this.indexMap.containsKey(o);
        }

        @Override
        public boolean containsAll(Collection c) {
            boolean contains = true;
            Iterator it = c.iterator();
            while (contains && it.hasNext()) {
                contains = FileHashMap.this.indexMap.containsKey(it.next());
            }
            return contains;
        }

        @Override
        public boolean equals(Object o) {
            Set so = (Set)o;
            boolean eq = false;
            Set myKeys = FileHashMap.this.indexMap.keySet();
            if (so.size() == myKeys.size()) {
                eq = true;
                Iterator it = myKeys.iterator();
                while (eq) {
                    Object myKey = it.next();
                    if (so.contains(myKey)) continue;
                    eq = false;
                }
            }
            return eq;
        }

        @Override
        public int hashCode() {
            return FileHashMap.this.indexMap.keySet().hashCode();
        }

        @Override
        public boolean isEmpty() {
            return FileHashMap.this.indexMap.isEmpty();
        }

        @Override
        public Iterator<K> iterator() {
            return new KeyIterator();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return FileHashMap.this.currentSize();
        }

        private synchronized void loadKeyArray() {
            if (this.keys == null) {
                List entries = FileHashMap.this.getSortedEntries();
                this.keys = new ArrayList();
                for (FileHashMapEntry entry : entries) {
                    this.keys.add(entry.getKey());
                }
            }
        }
    }

    private class KeyIterator
    implements Iterator<K> {
        private EntryIterator it;

        KeyIterator() {
            this.it = new EntryIterator();
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public K next() {
            return ((FileHashMapEntry)this.it.next()).getKey();
        }

        @Override
        public void remove() {
            this.it.remove();
        }
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        public boolean contains(Map.Entry<K, V> o) {
            return FileHashMap.this.containsValue(o.getValue());
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new Iterator<Map.Entry<K, V>>(){
                EntryIterator it;
                {
                    this.it = new EntryIterator();
                }

                @Override
                public Map.Entry<K, V> next() {
                    return new EntrySetEntry(this.it.next());
                }

                @Override
                public boolean hasNext() {
                    return this.it.hasNext();
                }

                @Override
                public void remove() {
                    this.it.remove();
                }
            };
        }

        @Override
        public boolean equals(Object obj) {
            boolean eq;
            boolean bl = eq = this == obj;
            if (!eq) {
                eq = super.equals(obj);
            }
            return eq;
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }

        public boolean remove(FileHashMapEntry<K> o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return FileHashMap.this.size();
        }
    }

    private class EntrySetEntry
    implements Map.Entry<K, V> {
        private FileHashMapEntry<K> entry;

        EntrySetEntry(FileHashMapEntry<K> entry) {
            this.entry = entry;
        }

        @Override
        public boolean equals(Object o) {
            Map.Entry mo = (Map.Entry)o;
            Object thisValue = this.getValue();
            Object thisKey = this.getKey();
            return (mo.getKey() == null ? thisKey == null : mo.getKey().equals(thisKey)) && (mo.getValue() == null ? thisValue == null : mo.getValue().equals(thisValue));
        }

        @Override
        public K getKey() {
            return this.entry.getKey();
        }

        @Override
        public V getValue() {
            return FileHashMap.this.readValueNoError(this.entry);
        }

        @Override
        public int hashCode() {
            Object value = this.getValue();
            Object key = this.getKey();
            return (key == null ? 0 : key.hashCode()) ^ (value == null ? 0 : value.hashCode());
        }

        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException();
        }
    }

    private class ValueSet
    extends AbstractSet<V> {
        ValuesFile valuesDB;

        private ValueSet() {
            this.valuesDB = FileHashMap.this.valuesDB;
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean contains(Object o) {
            boolean containsIt = false;
            this.seekTo(0L);
            ValueIterator it = new ValueIterator();
            while (it.hasNext()) {
                Object obj = it.next();
                if (!obj.equals(o)) continue;
                containsIt = true;
                break;
            }
            return containsIt;
        }

        @Override
        public boolean containsAll(Collection c) {
            boolean containsThem = true;
            this.seekTo(0L);
            ValueIterator it = new ValueIterator();
            while (it.hasNext()) {
                Object obj = it.next();
                if (c.contains(obj)) continue;
                containsThem = false;
                break;
            }
            return containsThem;
        }

        @Override
        public boolean equals(Object o) {
            boolean eq = false;
            Set other = (Set)o;
            if (other.size() == this.size()) {
                eq = this.containsAll((Collection)other);
            }
            return eq;
        }

        @Override
        public int hashCode() {
            int result = 0;
            this.seekTo(0L);
            ValueIterator it = new ValueIterator();
            while (it.hasNext()) {
                Object obj = it.next();
                result += obj.hashCode();
            }
            return result;
        }

        @Override
        public boolean isEmpty() {
            return FileHashMap.this.indexMap.isEmpty();
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueIterator();
        }

        @Override
        public boolean remove(Object o) {
            return FileHashMap.this.remove(o) != null;
        }

        @Override
        public int size() {
            return FileHashMap.this.currentSize();
        }

        private void seekTo(long pos) {
            try {
                this.valuesDB.getFile().seek(pos);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private class ValueIterator
    implements Iterator<V> {
        EntryIterator it;

        private ValueIterator() {
            this.it = new EntryIterator();
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public V next() {
            return FileHashMap.this.readValueNoError((FileHashMapEntry)this.it.next());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class EntryIterator
    implements Iterator<FileHashMapEntry<K>> {
        List<FileHashMapEntry<K>> entries;
        Iterator<FileHashMapEntry<K>> iterator;
        FileHashMapEntry<K> currentEntry = null;
        private int expectedSize = 0;

        EntryIterator() {
            this.entries = FileHashMap.this.getSortedEntries();
            this.iterator = this.entries.iterator();
            this.expectedSize = this.entries.size();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public FileHashMapEntry<K> next() {
            if (this.expectedSize != FileHashMap.this.indexMap.size()) {
                throw new ConcurrentModificationException();
            }
            if (!this.hasNext()) {
                this.currentEntry = null;
                throw new NoSuchElementException();
            }
            this.currentEntry = this.iterator.next();
            return this.currentEntry;
        }

        @Override
        public void remove() {
            Object key;
            Object value;
            if (this.currentEntry != null && this.expectedSize > 0 && (value = FileHashMap.this.remove(key = this.currentEntry.getKey())) != null) {
                this.currentEntry = this.hasNext() ? this.iterator.next() : null;
            }
        }
    }

    private class FileHashMapEntryGapComparator
    implements Comparator<FileHashMapEntry<K>> {
        private FileHashMapEntryGapComparator() {
        }

        @Override
        public int compare(FileHashMapEntry<K> o1, FileHashMapEntry<K> o2) {
            int cmp = o1.getObjectSize() - o2.getObjectSize();
            if (cmp == 0) {
                cmp = (int)(o1.getFilePosition() - o2.getFilePosition());
            }
            return cmp;
        }

        @Override
        public boolean equals(Object o) {
            return this.getClass().isInstance(o);
        }

        public int hashCode() {
            return super.hashCode();
        }
    }

    private class FileHashMapEntryComparator
    implements Comparator<FileHashMapEntry<K>> {
        private FileHashMapEntryComparator() {
        }

        @Override
        public int compare(FileHashMapEntry<K> o1, FileHashMapEntry<K> o2) {
            return o1.compareTo(o2);
        }

        @Override
        public boolean equals(Object o) {
            return this.getClass().isInstance(o);
        }

        public int hashCode() {
            return super.hashCode();
        }
    }

    private static class ValuesFile {
        private RandomAccessFile file;

        ValuesFile(File f) throws IOException {
            this.file = new RandomAccessFile(f, "rw");
        }

        RandomAccessFile getFile() throws ConcurrentModificationException {
            return this.file;
        }

        void close() throws IOException {
            this.file.close();
        }
    }
}

