/*
 * Decompiled with CFR 0.152.
 */
package org.clapper.util.io;

import java.io.File;
import java.io.FileFilter;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.clapper.util.io.CombinationFilterMode;

public class CombinationFileFilter
implements FileFilter {
    public static final CombinationFilterMode AND_FILTERS = CombinationFilterMode.AND_FILTERS;
    public static final CombinationFilterMode OR_FILTERS = CombinationFilterMode.OR_FILTERS;
    private List<FileFilter> filters = new LinkedList<FileFilter>();
    private CombinationFilterMode mode = AND_FILTERS;

    public CombinationFileFilter() {
        this(AND_FILTERS);
    }

    public CombinationFileFilter(CombinationFilterMode mode) {
        this.setMode(mode);
    }

    public CombinationFilterMode getMode() {
        return this.mode;
    }

    public void setMode(CombinationFilterMode mode) {
        this.mode = mode;
    }

    public void addFilter(FileFilter filter) {
        this.filters.add(filter);
    }

    public void removeFilter(FileFilter filter) {
        this.filters.remove(filter);
    }

    @Override
    public boolean accept(File file) {
        boolean accepted = false;
        Iterator<FileFilter> it = this.filters.iterator();
        if (this.mode == AND_FILTERS) {
            accepted = true;
            while (accepted && it.hasNext()) {
                FileFilter filter = it.next();
                accepted = filter.accept(file);
            }
        } else {
            accepted = false;
            while (!accepted && it.hasNext()) {
                FileFilter filter = it.next();
                accepted = filter.accept(file);
            }
        }
        return accepted;
    }
}

