/*
 * Decompiled with CFR 0.152.
 */
package org.clapper.util.config;

import java.util.ArrayList;
import java.util.Iterator;
import org.clapper.util.config.ConfigurationException;
import org.clapper.util.config.Section;
import org.clapper.util.config.ValueSegment;

class Variable {
    private static final char LITERAL_QUOTE = '\'';
    private static final char SUBST_QUOTE = '\"';
    private String name;
    private String cookedValue;
    private String[] cookedTokens = null;
    private String rawValue;
    private int lineWhereDefined = 0;
    private ValueSegment[] rawSegments = null;
    private ValueSegment[] cookedSegments = null;
    private Section parentSection;

    Variable(String name, String value, Section parentSection, int lineWhereDefined) {
        this.name = name;
        this.parentSection = parentSection;
        this.lineWhereDefined = lineWhereDefined;
        this.setValue(value);
    }

    Variable(String name, String value, Section parentSection) {
        this(name, value, parentSection, 0);
    }

    String getName() {
        return this.name;
    }

    Section getSection() {
        return this.parentSection;
    }

    String getRawValue() {
        return this.rawValue;
    }

    String getCookedValue() {
        return this.cookedValue;
    }

    String[] getCookedTokens() {
        return this.cookedTokens;
    }

    void setCookedValue(String value) {
        this.cookedValue = value;
    }

    ValueSegment[] getCookedSegments() throws ConfigurationException {
        this.segmentValue();
        return this.cookedSegments;
    }

    ValueSegment[] getRawSegments() throws ConfigurationException {
        this.segmentValue();
        return this.rawSegments;
    }

    void segmentValue() throws ConfigurationException {
        if (this.rawSegments == null) {
            int i;
            ArrayList<ValueSegment> segments = new ArrayList<ValueSegment>();
            ValueSegment currentSegment = new ValueSegment();
            char[] chars = this.rawValue.toCharArray();
            char last = '\u0000';
            currentSegment.isLiteral = false;
            currentSegment.isWhiteSpaceEscaped = false;
            for (i = 0; i < chars.length; ++i) {
                char ch = chars[i];
                switch (ch) {
                    case '\'': {
                        if (last == '\\' || currentSegment.isWhiteSpaceEscaped) {
                            currentSegment.append(ch);
                            break;
                        }
                        if (currentSegment.isLiteral) {
                            if (currentSegment.length() > 0) {
                                segments.add(currentSegment);
                                currentSegment = new ValueSegment();
                            }
                            currentSegment.isLiteral = false;
                            break;
                        }
                        if (currentSegment.length() > 0) {
                            segments.add(currentSegment);
                            currentSegment = new ValueSegment();
                        }
                        currentSegment.isLiteral = true;
                        break;
                    }
                    case '\"': {
                        if (last == '\\' || currentSegment.isLiteral) {
                            currentSegment.append(ch);
                            break;
                        }
                        if (currentSegment.isWhiteSpaceEscaped) {
                            if (currentSegment.length() > 0) {
                                segments.add(currentSegment);
                                currentSegment = new ValueSegment();
                            }
                            currentSegment.isWhiteSpaceEscaped = false;
                            break;
                        }
                        if (currentSegment.length() > 0) {
                            segments.add(currentSegment);
                            currentSegment = new ValueSegment();
                        }
                        currentSegment.isWhiteSpaceEscaped = true;
                        break;
                    }
                    default: {
                        currentSegment.append(ch);
                    }
                }
                last = ch;
            }
            if (currentSegment.isLiteral) {
                throw new ConfigurationException("Unmatched ' in variable \"" + this.name + "\"");
            }
            if (currentSegment.isWhiteSpaceEscaped) {
                throw new ConfigurationException("Unmatched \" in variable \"" + this.name + "\"");
            }
            if (currentSegment.length() > 0) {
                segments.add(currentSegment);
            }
            if (segments.size() > 0) {
                this.rawSegments = new ValueSegment[segments.size()];
                this.cookedSegments = new ValueSegment[segments.size()];
                i = 0;
                Iterator iterator = segments.iterator();
                while (iterator.hasNext()) {
                    ValueSegment vs;
                    this.rawSegments[i] = vs = (ValueSegment)iterator.next();
                    this.cookedSegments[i] = vs.makeCopy();
                    ++i;
                }
            }
        }
    }

    void reassembleCookedValueFromSegments() {
        if (this.cookedSegments != null) {
            StringBuilder buf = new StringBuilder();
            this.cookedTokens = new String[this.cookedSegments.length];
            int i = 0;
            for (ValueSegment segment : this.cookedSegments) {
                String s = segment.segmentBuf.toString();
                buf.append(s);
                this.cookedTokens[i++] = s;
            }
            this.cookedValue = buf.toString();
        }
    }

    final void setValue(String value) {
        this.rawValue = value;
        this.cookedValue = value;
    }

    int getLineWhereDefined() {
        return this.lineWhereDefined;
    }

    void setLineWhereDefined(int lineNumber) {
        this.lineWhereDefined = lineNumber;
    }
}

