/*
 * Decompiled with CFR 0.152.
 */
package com.evacipated.cardcrawl.modthespire.ui;

import com.evacipated.cardcrawl.modthespire.DownloadAndRestarter;
import com.evacipated.cardcrawl.modthespire.ModUpdate;
import com.evacipated.cardcrawl.modthespire.ui.ModSelectWindow;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;

class UpdateWindow
extends JDialog {
    UpdateWindow(JFrame parent) {
        super(parent);
        this.setModal(true);
        this.initUI();
    }

    private void initUI() {
        if (ModSelectWindow.MODUPDATES.size() == 1) {
            this.setTitle("Update Available");
        } else {
            this.setTitle("Updates Available");
        }
        this.setDefaultCloseOperation(2);
        this.setResizable(true);
        this.getContentPane().setPreferredSize(new Dimension(300, 200));
        this.rootPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setLayout(new BorderLayout());
        DefaultListModel<String> model = new DefaultListModel<String>();
        JList list = new JList(model);
        JScrollPane modScroller = new JScrollPane(list);
        this.getContentPane().add((Component)modScroller, "Center");
        for (ModUpdate update : ModSelectWindow.MODUPDATES) {
            model.addElement(update.info.Name);
        }
        String tmp = ModSelectWindow.MODUPDATES.size() == 1 ? "The following mod has an update available:" : "The following mods have updates available:";
        this.getContentPane().add((Component)new JLabel(tmp), "North");
        JPanel btnPanel = new JPanel(new GridBagLayout());
        JButton downloadBtn = new JButton("Download Updates and Restart ModTheSpire");
        JButton browserBtn = new JButton("Open Releases in Browser");
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.weightx = 0.5;
        btnPanel.add((Component)downloadBtn, c);
        c.gridy = 1;
        btnPanel.add((Component)browserBtn, c);
        this.getContentPane().add((Component)btnPanel, "South");
        browserBtn.addActionListener(event -> {
            if (Desktop.isDesktopSupported()) {
                for (ModUpdate update : ModSelectWindow.MODUPDATES) {
                    try {
                        Desktop.getDesktop().browse(update.releaseURL.toURI());
                    }
                    catch (IOException | URISyntaxException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        downloadBtn.addActionListener(event -> {
            this.getContentPane().setCursor(Cursor.getPredefinedCursor(3));
            URL[] downloadURLs = new URL[ModSelectWindow.MODUPDATES.size()];
            for (int i = 0; i < ModSelectWindow.MODUPDATES.size(); ++i) {
                downloadURLs[i] = ModSelectWindow.MODUPDATES.get((int)i).downloadURL;
            }
            try {
                DownloadAndRestarter.downloadAndRestart(downloadURLs);
            }
            catch (IOException | URISyntaxException e) {
                e.printStackTrace();
            }
        });
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }
}

