/*
 * Decompiled with CFR 0.152.
 */
package com.evacipated.cardcrawl.modthespire.steam;

import com.codedisaster.steamworks.SteamAPI;
import com.codedisaster.steamworks.SteamException;
import com.codedisaster.steamworks.SteamPublishedFileID;
import com.codedisaster.steamworks.SteamResult;
import com.codedisaster.steamworks.SteamUGC;
import com.codedisaster.steamworks.SteamUGCCallback;
import com.codedisaster.steamworks.SteamUGCDetails;
import com.codedisaster.steamworks.SteamUGCQuery;
import java.util.Arrays;
import java.util.Collection;

public class SteamWorkshop {
    private static final int appId = 646570;
    private static SteamUGC workshop;
    private static boolean kill;

    public static void main(String[] args) {
        try {
            if (!SteamAPI.init()) {
                System.err.println("Could not connect to Steam. Is it running?");
                System.exit(1);
            }
        }
        catch (SteamException e) {
            System.err.println(e.getMessage());
            System.exit(2);
        }
        if (SteamAPI.isSteamRunning((boolean)true)) {
            workshop = new SteamUGC((SteamUGCCallback)new Callback());
            int items = workshop.getNumSubscribedItems();
            SteamPublishedFileID[] publishedFileIDS = new SteamPublishedFileID[items];
            items = workshop.getSubscribedItems(publishedFileIDS);
            System.err.println("subbed items: " + items);
            SteamUGCQuery query = workshop.createQueryUGCDetailsRequest(Arrays.asList(publishedFileIDS));
            workshop.sendQueryUGCRequest(query);
            while (SteamAPI.isSteamRunning()) {
                try {
                    Thread.sleep(66L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                SteamAPI.runCallbacks();
                if (!kill) continue;
            }
        }
        SteamAPI.shutdown();
    }

    static {
        kill = false;
    }

    private static class Callback
    implements SteamUGCCallback {
        int resultsReceived = 0;

        private Callback() {
        }

        public void onUGCQueryCompleted(SteamUGCQuery query, int numResultsReturned, int totalMatchingResults, boolean isCachedData, SteamResult result) {
            if (query.isValid()) {
                System.err.println("result: " + result);
                System.err.println("numResultsReturned: " + numResultsReturned);
                System.err.println("totalMatchingResults: " + totalMatchingResults);
                System.err.println("isCachedData: " + isCachedData);
                for (int i = 0; i < numResultsReturned; ++i) {
                    SteamUGCDetails details = new SteamUGCDetails();
                    if (workshop.getQueryUGCResult(query, i, details)) {
                        Collection state = workshop.getItemState(details.getPublishedFileID());
                        if (!state.contains(SteamUGC.ItemState.Installed)) continue;
                        SteamUGC.ItemInstallInfo info = new SteamUGC.ItemInstallInfo();
                        if (!workshop.getItemInstallInfo(details.getPublishedFileID(), info)) continue;
                        System.out.println(details.getTitle());
                        System.out.println(details.getPublishedFileID());
                        System.out.println(info.getFolder());
                        System.out.println(details.getTimeUpdated());
                        System.out.println(details.getTags());
                        continue;
                    }
                    System.err.println("query valid? " + query.isValid());
                    System.err.println("index: " + i);
                    System.err.println("Query result failed");
                }
            } else {
                System.err.println("Not a valid query?");
            }
            this.resultsReceived += numResultsReturned;
            if (this.resultsReceived >= totalMatchingResults) {
                kill = true;
            }
        }

        public void onSubscribeItem(SteamPublishedFileID publishedFileID, SteamResult result) {
        }

        public void onUnsubscribeItem(SteamPublishedFileID publishedFileID, SteamResult result) {
        }

        public void onRequestUGCDetails(SteamUGCDetails details, SteamResult result) {
        }

        public void onCreateItem(SteamPublishedFileID publishedFileID, boolean needsToAcceptWLA, SteamResult result) {
        }

        public void onSubmitItemUpdate(boolean needsToAcceptWLA, SteamResult result) {
        }

        public void onDownloadItemResult(int appID, SteamPublishedFileID publishedFileID, SteamResult result) {
        }

        public void onUserFavoriteItemsListChanged(SteamPublishedFileID publishedFileID, boolean wasAddRequest, SteamResult result) {
        }

        public void onSetUserItemVote(SteamPublishedFileID publishedFileID, boolean voteUp, SteamResult result) {
        }

        public void onGetUserItemVote(SteamPublishedFileID publishedFileID, boolean votedUp, boolean votedDown, boolean voteSkipped, SteamResult result) {
        }

        public void onStartPlaytimeTracking(SteamResult result) {
        }

        public void onStopPlaytimeTracking(SteamResult result) {
        }

        public void onStopPlaytimeTrackingForAllItems(SteamResult result) {
        }
    }
}

