/*
 * Decompiled with CFR 0.152.
 */
package com.evacipated.cardcrawl.modthespire.steam;

import com.evacipated.cardcrawl.modthespire.Loader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.SystemUtils;

public class SteamSearch {
    private static final int appId = 646570;
    private static String installDir = null;

    public static String findJRE() {
        return SteamSearch.findJRE("jre");
    }

    public static String findJRE51() {
        return SteamSearch.findJRE(Loader.JRE_51_DIR);
    }

    public static String findJRE(String jreBase) {
        Path local;
        String javaExecName = "java";
        if (SystemUtils.IS_OS_WINDOWS) {
            javaExecName = "java.exe";
        }
        if ((local = Paths.get(jreBase, "bin", javaExecName)).toFile().exists()) {
            System.out.println("Using local StS JRE @ " + local.toAbsolutePath().toString());
            return local.toString();
        }
        SteamSearch.prepare();
        if (installDir == null) {
            return null;
        }
        Path install = Paths.get(installDir, jreBase, "bin", javaExecName);
        if (install.toFile().exists()) {
            System.out.println("Using install StS JRE @ " + install.toAbsolutePath().toString());
            return install.toString();
        }
        return null;
    }

    public static String findDesktopJar() {
        SteamSearch.prepare();
        if (installDir == null) {
            return null;
        }
        return Paths.get(installDir, Loader.STS_JAR).toString();
    }

    private static void prepare() {
        if (installDir != null) {
            return;
        }
        Path steamPath = SteamSearch.getSteamPath();
        if (steamPath == null) {
            System.err.println("ERROR: Failed to find Steam installation.");
            return;
        }
        if (SteamSearch.containsAcfFile(steamPath)) {
            installDir = SteamSearch.steamToSTSPath(steamPath).toString();
            return;
        }
        File tmp = Paths.get(steamPath.toString(), "libraryfolders.vdf").toFile();
        if (tmp.exists()) {
            List<Path> libraries = SteamSearch.readLibraryFolders2(tmp);
            for (Path library : libraries) {
                if (!SteamSearch.containsAcfFile(library)) continue;
                installDir = SteamSearch.steamToSTSPath(library).toString();
                return;
            }
        }
    }

    private static Path getSteamPath() {
        Path steamPath;
        block5: {
            block4: {
                steamPath = null;
                if (SystemUtils.IS_OS_WINDOWS) {
                    steamPath = Paths.get(System.getenv("ProgramFiles") + " (x86)", "Steam", "steamapps");
                    if (!steamPath.toFile().exists() && !(steamPath = Paths.get(System.getenv("ProgramFiles"), "Steam", "steamapps")).toFile().exists()) {
                        steamPath = null;
                    }
                    return steamPath;
                }
                if (!SystemUtils.IS_OS_MAC) break block4;
                steamPath = Paths.get(SystemUtils.USER_HOME, "Library/Application Support/Steam/steamapps");
                if (steamPath.toFile().exists()) break block5;
                steamPath = null;
                break block5;
            }
            if (SystemUtils.IS_OS_LINUX) {
                Path[] possiblePaths;
                for (Path p : possiblePaths = new Path[]{Paths.get(SystemUtils.USER_HOME, ".steam/steam/SteamApps"), Paths.get(SystemUtils.USER_HOME, ".steam/steam/steamapps"), Paths.get(SystemUtils.USER_HOME, ".local/share/steam/SteamApps"), Paths.get(SystemUtils.USER_HOME, ".local/share/steam/steamapps")}) {
                    if (!p.toFile().exists()) continue;
                    steamPath = p;
                    break;
                }
            }
        }
        return steamPath;
    }

    private static Path steamToSTSPath(Path path) {
        return Paths.get(path.toString(), "common", "SlayTheSpire");
    }

    private static boolean containsAcfFile(Path path) {
        Path acfFilePath = Paths.get(path.toString(), "appmanifest_646570.acf");
        return acfFilePath.toFile().exists();
    }

    private static List<Path> readLibraryFolders(File file) {
        ArrayList<Path> libraries = new ArrayList<Path>();
        try {
            String line;
            FileReader fileReader = new FileReader(file);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            while ((line = bufferedReader.readLine()) != null) {
                String[] tokens = line.split("\t");
                if (tokens.length != 4 || !SteamSearch.isInteger(tokens[1].substring(1, tokens[1].length() - 1))) continue;
                libraries.add(Paths.get(tokens[3].substring(1, tokens[3].length() - 1), "steamapps"));
            }
            fileReader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return libraries;
    }

    private static List<Path> readLibraryFolders2(File file) {
        ArrayList<Path> libraries = new ArrayList<Path>();
        try {
            String line;
            FileReader fileReader = new FileReader(file);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            while ((line = bufferedReader.readLine()) != null) {
                String[] tokens = (String[])Arrays.stream(line.split("\t")).filter(str -> !str.isEmpty()).toArray(String[]::new);
                if (tokens.length != 2 || !"\"path\"".equals(tokens[0])) continue;
                libraries.add(Paths.get(tokens[1].substring(1, tokens[1].length() - 1), "steamapps"));
            }
            fileReader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (libraries.isEmpty()) {
            return SteamSearch.readLibraryFolders(file);
        }
        return libraries;
    }

    private static boolean isInteger(String s) {
        try {
            Integer.parseInt(s);
        }
        catch (NullPointerException | NumberFormatException e) {
            return false;
        }
        return true;
    }

    public static class WorkshopInfo {
        private final String title;
        private final String id;
        private final Path installPath;
        private final int timeUpdated;
        private List<String> tags;

        public WorkshopInfo(String title, String id, String installPath, String timeUpdated, String tagsString) {
            this.title = title;
            this.id = id;
            this.installPath = Paths.get(installPath, new String[0]).toAbsolutePath();
            int tmpTime = 0;
            try {
                tmpTime = Integer.parseInt(timeUpdated);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.timeUpdated = tmpTime;
            String[] tmp = tagsString.split(",");
            this.tags = new ArrayList<String>();
            for (String s : tmp) {
                this.tags.add(s.toLowerCase().trim());
            }
        }

        public String getTitle() {
            return this.title;
        }

        public String getID() {
            return this.id;
        }

        public Path getInstallPath() {
            return this.installPath;
        }

        public int getTimeUpdated() {
            return this.timeUpdated;
        }

        public List<String> getTags() {
            return this.tags;
        }

        public boolean hasTag(String tag) {
            String finalTag = tag = tag.toLowerCase().trim();
            return this.tags.stream().anyMatch(t -> t.equals(finalTag));
        }
    }
}

