/*
 * Decompiled with CFR 0.152.
 */
package com.evacipated.cardcrawl.modthespire.patcher.javassist.convert;

import com.evacipated.cardcrawl.modthespire.Loader;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.NotFoundException;
import javassist.bytecode.BadBytecode;
import javassist.bytecode.CodeAttribute;
import javassist.bytecode.CodeIterator;
import javassist.bytecode.ConstPool;
import javassist.bytecode.LineNumberAttribute;
import javassist.convert.Transformer;

public class TransformSpecialCallVirtual
extends Transformer {
    protected String classname;
    protected String methodname;
    protected String methodDescriptor;
    protected CodeAttribute codeAttr;
    protected int newIndex;
    protected ConstPool constPool;

    public TransformSpecialCallVirtual(Transformer next, CtMethod origMethod) {
        super(next);
        this.methodname = origMethod.getName();
        this.methodDescriptor = origMethod.getMethodInfo2().getDescriptor();
        this.classname = origMethod.getDeclaringClass().getName();
        this.constPool = null;
    }

    @Override
    public void initialize(ConstPool cp, CodeAttribute attr) {
        if (this.constPool != cp) {
            this.newIndex = 0;
        }
        this.codeAttr = attr;
    }

    @Override
    public int transform(CtClass clazz, int pos, CodeIterator iterator, ConstPool cp) throws BadBytecode {
        int index;
        String cname;
        int c = iterator.byteAt(pos);
        if (c == 183 && (cname = cp.eqMember(this.methodname, this.methodDescriptor, index = iterator.u16bitAt(pos + 1))) != null && this.matchClass(cname, clazz.getClassPool())) {
            int ntinfo = cp.getMemberNameAndType(index);
            pos = this.match(c, pos, iterator, cp.getNameAndTypeDescriptor(ntinfo), cp);
        }
        return pos;
    }

    private boolean matchClass(String name, ClassPool pool) {
        if (this.classname.equals(name)) {
            return true;
        }
        try {
            CtClass clazz = pool.get(name);
            CtClass declClazz = pool.get(this.classname);
            if (clazz.subtypeOf(declClazz)) {
                try {
                    CtMethod m = clazz.getMethod(this.methodname, this.methodDescriptor);
                    return m.getDeclaringClass().getName().equals(this.classname);
                }
                catch (NotFoundException e) {
                    return true;
                }
            }
        }
        catch (NotFoundException e) {
            return false;
        }
        return false;
    }

    protected int match(int c, int pos, CodeIterator iterator, int typedesc, ConstPool cp) throws BadBytecode {
        LineNumberAttribute ainfo = (LineNumberAttribute)this.codeAttr.getAttribute("LineNumberTable");
        int nt = cp.addNameAndTypeInfo(cp.addUtf8Info(this.methodname), typedesc);
        int ci = cp.addClassInfo(this.classname);
        if (c == 185) {
            this.newIndex = cp.addInterfaceMethodrefInfo(ci, nt);
        } else {
            if (c == 183) {
                if (Loader.DEBUG) {
                    System.out.println("        @ " + ainfo.toLineNumber(pos));
                }
                iterator.writeByte(182, pos);
            }
            this.newIndex = cp.addMethodrefInfo(ci, nt);
        }
        this.constPool = cp;
        iterator.write16bit(this.newIndex, pos + 1);
        return pos;
    }
}

