/*
 * Decompiled with CFR 0.152.
 */
package com.evacipated.cardcrawl.modthespire.patcher;

import com.evacipated.cardcrawl.modthespire.Loader;
import com.evacipated.cardcrawl.modthespire.patcher.ParamInfo;
import com.evacipated.cardcrawl.modthespire.patcher.ParamInfo2;
import com.evacipated.cardcrawl.modthespire.patcher.ParameterPatchInfo;
import com.evacipated.cardcrawl.modthespire.patcher.PatchingException;
import javassist.CannotCompileException;
import javassist.CtBehavior;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.CtPrimitiveType;
import javassist.NotFoundException;

public class PostfixPatchInfo
extends ParameterPatchInfo {
    private boolean returnsValue = false;
    private boolean takesResultParam = false;

    public PostfixPatchInfo(CtBehavior ctMethodToPatch, CtMethod patchMethod) {
        super(ctMethodToPatch, patchMethod);
        this.canByRefParams = true;
    }

    @Override
    protected String debugMsg() {
        return "Adding Postfix...";
    }

    @Override
    public int patchOrdering() {
        return 2;
    }

    @Override
    protected ParameterPatchInfo.ParamTransformer makeTransformer(ParamInfo src, ParamInfo dest) {
        return new PostfixParamTransformer(src, dest);
    }

    @Override
    protected ParamInfo2 makeInfo2(CtBehavior toPatch, CtMethod patchMethod, int position) throws PatchingException {
        return new PostfixParamInfo2(toPatch, patchMethod, position);
    }

    @Override
    protected void alterSrc() {
        if (this.returnsValue) {
            this.funccall = "return ($r)" + this.funccall;
        }
    }

    @Override
    protected void applyPatch(String src) throws CannotCompileException {
        this.ctMethodToPatch.insertAfter(src);
    }

    protected class PostfixParamInfo2
    extends ParamInfo2 {
        PostfixParamInfo2(CtBehavior toPatch, CtMethod patchMethod, int position) throws PatchingException {
            super(toPatch, patchMethod, position);
        }

        @Override
        protected boolean specialNameCheck(String patchParamName) throws PatchingException {
            if (patchParamName.equals("__result")) {
                try {
                    CtClass returnType = this.patchMethod.getReturnType();
                    if (!returnType.equals(CtPrimitiveType.voidType)) {
                        PostfixPatchInfo.this.returnsValue = true;
                        if (Loader.DEBUG) {
                            System.out.println("      Return: " + returnType.getName());
                        }
                    }
                    PostfixPatchInfo.this.takesResultParam = true;
                    if (Loader.DEBUG) {
                        System.out.println("      Result param: " + this.getPatchParamTypename());
                    }
                }
                catch (NotFoundException e) {
                    throw new PatchingException(e);
                }
                this.name = patchParamName;
                this.argName = "$_";
                return true;
            }
            return false;
        }
    }

    protected class PostfixParamTransformer
    extends ParameterPatchInfo.ParamTransformer {
        protected PostfixParamTransformer(ParamInfo src, ParamInfo dest) {
            super(src, dest);
        }

        @Override
        protected boolean advanceSrcPosition() {
            if (this.destInfo.getPosition() == 1 && PostfixPatchInfo.this.takesResultParam) {
                return false;
            }
            return super.advanceSrcPosition();
        }

        @Override
        protected String getParamName() throws PatchingException {
            if (this.destInfo.getPosition() == 1) {
                try {
                    CtClass returnType = PostfixPatchInfo.this.patchMethod.getReturnType();
                    if (!returnType.equals(CtPrimitiveType.voidType)) {
                        PostfixPatchInfo.this.returnsValue = true;
                        if (Loader.DEBUG) {
                            System.out.println("      Return: " + returnType.getName());
                        }
                    }
                    if (this.destInfo.getType().equals(returnType)) {
                        PostfixPatchInfo.this.takesResultParam = true;
                        if (Loader.DEBUG) {
                            System.out.println("      Result param: " + this.destInfo.getTypename());
                        }
                        return "$_";
                    }
                }
                catch (NotFoundException e) {
                    throw new PatchingException(e);
                }
            }
            return super.getParamName();
        }
    }
}

