/*
 * Decompiled with CFR 0.152.
 */
package com.evacipated.cardcrawl.modthespire.patcher;

import com.evacipated.cardcrawl.modthespire.lib.ByRef;
import com.evacipated.cardcrawl.modthespire.lib.SpirePatch;
import com.evacipated.cardcrawl.modthespire.lib.SpirePatch2;
import com.evacipated.cardcrawl.modthespire.patcher.PatchingException;
import java.lang.reflect.Proxy;
import javassist.CtBehavior;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.Modifier;
import javassist.NotFoundException;
import javassist.bytecode.annotation.AnnotationImpl;

public abstract class PatchInfo {
    private static int modNum = 0;
    private int modOrder;
    SpirePatch patch;
    CtBehavior ctMethodToPatch;
    CtMethod patchMethod;

    public PatchInfo(CtBehavior ctMethodToPatch, CtMethod patchMethod) {
        this.ctMethodToPatch = ctMethodToPatch;
        this.patchMethod = patchMethod;
        this.modOrder = modNum;
    }

    public PatchInfo setSpirePatch(SpirePatch patch) {
        this.patch = patch;
        return this;
    }

    public void debugPrint() {
        System.out.println("Patch Class: [" + this.patchClassName() + "]");
        if (this.isSpirePatch2()) {
            System.out.println(" - SpirePatch2");
        }
        System.out.println(" - Patching [" + this.ctMethodToPatch.getLongName() + "]");
        System.out.print(" - ");
        System.out.println(this.debugMsg());
    }

    protected String patchClassName() {
        return this.patchMethod.getDeclaringClass().getName();
    }

    protected abstract String debugMsg();

    public static void nextMod() {
        ++modNum;
    }

    public final int modOrdering() {
        return this.modOrder;
    }

    public final boolean isSpirePatch2() {
        if (this.patch == null) {
            return false;
        }
        try {
            AnnotationImpl impl = (AnnotationImpl)Proxy.getInvocationHandler(this.patch);
            return SpirePatch2.class.getName().equals(impl.getTypeName());
        }
        catch (ClassCastException | IllegalArgumentException ignored) {
            return false;
        }
    }

    public abstract int patchOrdering();

    public abstract void doPatch() throws PatchingException;

    protected static boolean paramByRef(Object[] annotations) {
        for (Object o : annotations) {
            if (!(o instanceof ByRef)) continue;
            return true;
        }
        return false;
    }

    protected static String paramByRefTypename(Object[] annotations) {
        for (Object o : annotations) {
            if (!(o instanceof ByRef)) continue;
            return ((ByRef)o).type();
        }
        return "";
    }

    protected static String paramByRefTypename2(CtBehavior ctMethodToPatch, int index) throws NotFoundException {
        if (!Modifier.isStatic(ctMethodToPatch.getModifiers())) {
            --index;
        }
        try {
            return ctMethodToPatch.getParameterTypes()[index].getName();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return null;
        }
    }

    protected static String paramByRefTypenamePrivateCapture(CtBehavior ctMethodToPatch, String paramName) throws NotFoundException {
        CtClass ctClass = ctMethodToPatch.getDeclaringClass();
        CtField ctField = ctClass.getField(paramName);
        return ctField.getType().getName();
    }
}

