/*
 * Decompiled with CFR 0.152.
 */
package com.evacipated.cardcrawl.modthespire.patcher;

import com.evacipated.cardcrawl.modthespire.Loader;
import com.evacipated.cardcrawl.modthespire.lib.ByRef;
import com.evacipated.cardcrawl.modthespire.lib.SpireReturn;
import com.evacipated.cardcrawl.modthespire.patcher.ByRefParameterNotArrayException;
import com.evacipated.cardcrawl.modthespire.patcher.ParamInfo;
import com.evacipated.cardcrawl.modthespire.patcher.ParamInfo2;
import com.evacipated.cardcrawl.modthespire.patcher.PatchInfo;
import com.evacipated.cardcrawl.modthespire.patcher.PatchingException;
import javassist.CannotCompileException;
import javassist.CtBehavior;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtMethod;
import javassist.CtPrimitiveType;
import javassist.NotFoundException;

abstract class ParameterPatchInfo
extends PatchInfo {
    protected boolean canSpireReturn = false;
    protected boolean canByRefParams = false;
    protected String src;
    protected String funccall;
    protected String funccallargs;
    protected String postcallsrc;
    protected String postcallsrc2;

    public ParameterPatchInfo(CtBehavior ctMethodToPatch, CtMethod patchMethod) {
        super(ctMethodToPatch, patchMethod);
    }

    protected ParamTransformer makeTransformer(ParamInfo src, ParamInfo dest) {
        return new ParamTransformer(src, dest);
    }

    protected ParamInfo2 makeInfo2(CtBehavior toPatch, CtMethod patchMethod, int position) throws PatchingException {
        return new ParamInfo2(this.ctMethodToPatch, patchMethod, position);
    }

    protected void alterSrc() {
    }

    protected abstract void applyPatch(String var1) throws CannotCompileException;

    @Override
    public void doPatch() throws PatchingException {
        try {
            int i;
            boolean hasEarlyReturn = false;
            if (this.canSpireReturn) {
                CtClass returnType = this.patchMethod.getReturnType();
                if ((this.ctMethodToPatch instanceof CtMethod || this.ctMethodToPatch instanceof CtConstructor) && !returnType.equals(CtPrimitiveType.voidType) && returnType.equals(returnType.getClassPool().get(SpireReturn.class.getName()))) {
                    hasEarlyReturn = true;
                }
            }
            this.src = "{\n";
            this.funccall = this.patchMethod.getDeclaringClass().getName() + "." + this.patchMethod.getName() + "(%s);\n";
            this.postcallsrc = "";
            this.postcallsrc2 = "";
            if (hasEarlyReturn) {
                this.funccall = SpireReturn.class.getName() + " opt = " + this.funccall;
            }
            this.funccallargs = "";
            CtClass[] paramTypes = this.patchMethod.getParameterTypes();
            if (this.isSpirePatch2()) {
                for (i = 0; i < paramTypes.length; ++i) {
                    ParamTransformer2 transformer = new ParamTransformer2(this.makeInfo2(this.ctMethodToPatch, this.patchMethod, i));
                    transformer.makeSource();
                }
            } else {
                i = 0;
                for (int j = 0; j < paramTypes.length; ++j) {
                    ParamTransformer transformer = this.makeTransformer(new ParamInfo(this.ctMethodToPatch, i), new ParamInfo(this.patchMethod, j));
                    transformer.makeSource();
                    if (!transformer.advanceSrcPosition()) continue;
                    ++i;
                }
            }
            this.funccallargs = this.funccallargs.trim();
            if (this.funccallargs.endsWith(",")) {
                this.funccallargs = this.funccallargs.substring(0, this.funccallargs.length() - 1);
            }
            this.funccall = String.format(this.funccall, this.funccallargs);
            this.alterSrc();
            String src2 = this.src = this.src + this.funccall;
            this.src = this.src + this.postcallsrc;
            src2 = src2 + this.postcallsrc2;
            if (hasEarlyReturn) {
                String earlyReturn = "if (opt.isPresent()) { return";
                if (this.ctMethodToPatch instanceof CtMethod && !((CtMethod)this.ctMethodToPatch).getReturnType().equals(CtPrimitiveType.voidType)) {
                    CtClass toPatchReturnType = ((CtMethod)this.ctMethodToPatch).getReturnType();
                    String toPatchReturnTypeName = toPatchReturnType.getName();
                    if (toPatchReturnType.isPrimitive()) {
                        toPatchReturnTypeName = toPatchReturnType.equals(CtPrimitiveType.intType) ? "Integer" : (toPatchReturnType.equals(CtPrimitiveType.charType) ? "Character" : toPatchReturnTypeName.substring(0, 1).toUpperCase() + toPatchReturnTypeName.substring(1));
                        earlyReturn = earlyReturn + " (";
                    }
                    earlyReturn = earlyReturn + " (" + toPatchReturnTypeName + ")opt.get()";
                    if (toPatchReturnType.isPrimitive()) {
                        earlyReturn = earlyReturn + ")." + toPatchReturnType.getName() + "Value()";
                    }
                }
                earlyReturn = earlyReturn + "; }\n";
                this.src = this.src + earlyReturn;
                src2 = src2 + earlyReturn;
            }
            this.src = this.src + "}";
            src2 = src2 + "}";
            if (Loader.DEBUG) {
                System.out.println(this.src);
            }
            try {
                this.applyPatch(this.src);
            }
            catch (CannotCompileException e) {
                try {
                    this.applyPatch(src2);
                }
                catch (CannotCompileException e2) {
                    throw e;
                }
            }
        }
        catch (ClassNotFoundException | CannotCompileException | NotFoundException e) {
            throw new PatchingException(e);
        }
    }

    protected class ParamTransformer2 {
        protected ParamInfo2 info;

        protected ParamTransformer2(ParamInfo2 info) {
            this.info = info;
        }

        protected String getParamName() throws PatchingException {
            if (this.info.hasError()) {
                throw new PatchingException("Illegal patch parameter: " + this.info.getError());
            }
            if (this.info.getArgName() != null) {
                return this.info.getArgName();
            }
            throw new PatchingException("Unknown error acquiring parameter name for \"" + this.info.getName() + "\"");
        }

        protected String boxing(String paramName) throws NotFoundException, PatchingException, ClassNotFoundException {
            CtClass srcType = this.info.getType();
            CtClass destType = this.info.getPatchParamType();
            if (srcType == null && this.info.isPrivateCapture()) {
                srcType = this.info.getPrivateCaptureType();
            }
            if (srcType == null) {
                srcType = this.info.getDestByRefType();
            }
            if (!destType.equals(srcType)) {
                CtClass ctComponentType = destType.getComponentType();
                if (srcType != null && srcType.isPrimitive() && !ctComponentType.isPrimitive()) {
                    return "new " + ctComponentType.getName() + "(" + paramName + ")";
                }
            }
            return paramName;
        }

        protected void makeSource() throws ClassNotFoundException, PatchingException, NotFoundException {
            Object[] paramAnnotations = this.info.getAnnotations();
            if (ParameterPatchInfo.this.canByRefParams && PatchInfo.paramByRef(paramAnnotations)) {
                if (!this.info.getPatchParamType().isArray()) {
                    throw new ByRefParameterNotArrayException(this.info.getName());
                }
                String tmp = this.info.getPatchParamTypename();
                String paramTypeName = tmp.substring(0, tmp.indexOf(91) + 1);
                paramTypeName = paramTypeName + "1" + tmp.substring(tmp.indexOf(91) + 1);
                ParameterPatchInfo.this.src = ParameterPatchInfo.this.src + tmp + " __param" + this.info.getPatchParamPosition() + " = new " + paramTypeName + ";\n";
                ParameterPatchInfo.this.src = ParameterPatchInfo.this.src + "__param" + this.info.getPatchParamPosition() + "[0] = " + this.boxing(this.getParamName()) + ";\n";
                ParameterPatchInfo.this.funccallargs = ParameterPatchInfo.this.funccallargs + "__param" + this.info.getPatchParamPosition();
                ParameterPatchInfo.this.postcallsrc = ParameterPatchInfo.this.postcallsrc + this.getParamName() + " = ";
                ParameterPatchInfo.this.postcallsrc2 = ParameterPatchInfo.this.postcallsrc2 + this.getParamName() + " = ";
                String typename = this.info.getTypename();
                for (Object o : this.info.getAnnotations()) {
                    if (!(o instanceof ByRef) || ((ByRef)o).type().isEmpty()) continue;
                    typename = ((ByRef)o).type();
                }
                if (!typename.isEmpty()) {
                    ParameterPatchInfo.this.postcallsrc = ParameterPatchInfo.this.postcallsrc + "(" + typename + ")";
                    ParameterPatchInfo.this.postcallsrc2 = ParameterPatchInfo.this.postcallsrc2 + "(com.megacrit.cardcrawl." + typename + ")";
                }
                ParameterPatchInfo.this.postcallsrc = ParameterPatchInfo.this.postcallsrc + "__param" + this.info.getPatchParamPosition() + "[0]";
                ParameterPatchInfo.this.postcallsrc2 = ParameterPatchInfo.this.postcallsrc2 + "__param" + this.info.getPatchParamPosition() + "[0]";
                CtClass srcType = this.info.getType();
                CtClass destType = this.info.getPatchParamType();
                if (srcType == null && this.info.isPrivateCapture()) {
                    srcType = this.info.getPrivateCaptureType();
                }
                if (srcType == null) {
                    srcType = this.info.getDestByRefType();
                }
                if (srcType != null && destType != null) {
                    CtClass ctComponentType = destType.getComponentType();
                    if (srcType.isPrimitive() && ctComponentType != null && !ctComponentType.isPrimitive()) {
                        CtPrimitiveType ctPrimitive = (CtPrimitiveType)srcType;
                        ParameterPatchInfo.this.postcallsrc = ParameterPatchInfo.this.postcallsrc + "." + ctPrimitive.getGetMethodName() + "()";
                        ParameterPatchInfo.this.postcallsrc2 = ParameterPatchInfo.this.postcallsrc2 + "." + ctPrimitive.getGetMethodName() + "()";
                    }
                }
                ParameterPatchInfo.this.postcallsrc = ParameterPatchInfo.this.postcallsrc + ";\n";
                ParameterPatchInfo.this.postcallsrc2 = ParameterPatchInfo.this.postcallsrc2 + ";\n";
            } else {
                ParameterPatchInfo.this.funccallargs = ParameterPatchInfo.this.funccallargs + this.getParamName();
            }
            ParameterPatchInfo.this.funccallargs = ParameterPatchInfo.this.funccallargs + ", ";
        }
    }

    protected class ParamTransformer {
        protected ParamInfo srcInfo;
        protected ParamInfo destInfo;

        protected ParamTransformer(ParamInfo src, ParamInfo dest) {
            this.srcInfo = src;
            this.destInfo = dest;
        }

        protected boolean advanceSrcPosition() {
            return true;
        }

        protected String getParamName() throws PatchingException {
            if (this.srcInfo.getPosition() >= 0) {
                return "$" + this.srcInfo.getPosition();
            }
            if (this.destInfo.isPrivateCapture()) {
                return this.destInfo.getName();
            }
            throw new PatchingException("Illegal patch parameter: Cannot determine name");
        }

        protected String boxing(String paramName) throws NotFoundException, PatchingException, ClassNotFoundException {
            CtClass srcType = this.srcInfo.getType();
            CtClass destType = this.destInfo.getType();
            if (srcType == null && this.destInfo.isPrivateCapture()) {
                srcType = this.srcInfo.getPrivateCaptureType(this.destInfo);
            }
            if (srcType == null) {
                srcType = this.srcInfo.getDestByRefType(this.destInfo);
            }
            if (!destType.equals(srcType)) {
                CtClass ctComponentType = destType.getComponentType();
                if (srcType != null && srcType.isPrimitive() && !ctComponentType.isPrimitive()) {
                    return "new " + ctComponentType.getName() + "(" + paramName + ")";
                }
            }
            return paramName;
        }

        protected void makeSource() throws ClassNotFoundException, PatchingException, NotFoundException {
            Object[] paramAnnotations = this.destInfo.getAnnotations();
            if (ParameterPatchInfo.this.canByRefParams && PatchInfo.paramByRef(paramAnnotations)) {
                if (!this.destInfo.getType().isArray()) {
                    throw new ByRefParameterNotArrayException(this.destInfo.getPosition() - 1);
                }
                String tmp = this.destInfo.getTypename();
                String paramTypeName = tmp.substring(0, tmp.indexOf(91) + 1);
                paramTypeName = paramTypeName + "1" + tmp.substring(tmp.indexOf(91) + 1);
                ParameterPatchInfo.this.src = ParameterPatchInfo.this.src + tmp + " __param" + this.destInfo.getPosition() + " = new " + paramTypeName + ";\n";
                ParameterPatchInfo.this.src = ParameterPatchInfo.this.src + "__param" + this.destInfo.getPosition() + "[0] = " + this.boxing(this.getParamName()) + ";\n";
                ParameterPatchInfo.this.funccallargs = ParameterPatchInfo.this.funccallargs + "__param" + this.destInfo.getPosition();
                ParameterPatchInfo.this.postcallsrc = ParameterPatchInfo.this.postcallsrc + this.getParamName() + " = ";
                ParameterPatchInfo.this.postcallsrc2 = ParameterPatchInfo.this.postcallsrc2 + this.getParamName() + " = ";
                String typename = this.srcInfo.getTypename();
                for (Object o : this.destInfo.getAnnotations()) {
                    if (!(o instanceof ByRef) || ((ByRef)o).type().isEmpty()) continue;
                    typename = ((ByRef)o).type();
                }
                if (!typename.isEmpty()) {
                    ParameterPatchInfo.this.postcallsrc = ParameterPatchInfo.this.postcallsrc + "(" + typename + ")";
                    ParameterPatchInfo.this.postcallsrc2 = ParameterPatchInfo.this.postcallsrc2 + "(com.megacrit.cardcrawl." + typename + ")";
                }
                ParameterPatchInfo.this.postcallsrc = ParameterPatchInfo.this.postcallsrc + "__param" + this.destInfo.getPosition() + "[0]";
                ParameterPatchInfo.this.postcallsrc2 = ParameterPatchInfo.this.postcallsrc2 + "__param" + this.destInfo.getPosition() + "[0]";
                CtClass srcType = this.srcInfo.getType();
                CtClass destType = this.destInfo.getType();
                if (srcType == null && this.destInfo.isPrivateCapture()) {
                    srcType = this.srcInfo.getPrivateCaptureType(this.destInfo);
                }
                if (srcType == null) {
                    srcType = this.srcInfo.getDestByRefType(this.destInfo);
                }
                if (srcType != null && destType != null) {
                    CtClass ctComponentType = destType.getComponentType();
                    if (srcType.isPrimitive() && ctComponentType != null && !ctComponentType.isPrimitive()) {
                        CtPrimitiveType ctPrimitive = (CtPrimitiveType)srcType;
                        ParameterPatchInfo.this.postcallsrc = ParameterPatchInfo.this.postcallsrc + "." + ctPrimitive.getGetMethodName() + "()";
                        ParameterPatchInfo.this.postcallsrc2 = ParameterPatchInfo.this.postcallsrc2 + "." + ctPrimitive.getGetMethodName() + "()";
                    }
                }
                ParameterPatchInfo.this.postcallsrc = ParameterPatchInfo.this.postcallsrc + ";\n";
                ParameterPatchInfo.this.postcallsrc2 = ParameterPatchInfo.this.postcallsrc2 + ";\n";
            } else {
                ParameterPatchInfo.this.funccallargs = ParameterPatchInfo.this.funccallargs + this.getParamName();
            }
            ParameterPatchInfo.this.funccallargs = ParameterPatchInfo.this.funccallargs + ", ";
        }
    }
}

