/*
 * Decompiled with CFR 0.152.
 */
package com.evacipated.cardcrawl.modthespire.patcher;

import com.evacipated.cardcrawl.modthespire.lib.ByRef;
import com.evacipated.cardcrawl.modthespire.patcher.PatchingException;
import javassist.CtBehavior;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.Modifier;
import javassist.NotFoundException;
import javassist.bytecode.LocalVariableAttribute;
import javassist.bytecode.MethodInfo;

class ParamInfo2 {
    protected CtBehavior toPatch;
    protected CtMethod patchMethod;
    protected int toPatchParamPosition = -1;
    protected int patchParamPosition;
    protected String argName = null;
    protected String name = null;
    protected boolean isPrivate = false;
    protected String error = null;

    private static String findName(CtBehavior ctBehavior, int position) {
        MethodInfo methodInfo = ctBehavior.getMethodInfo2();
        LocalVariableAttribute table = (LocalVariableAttribute)methodInfo.getCodeAttribute().getAttribute("LocalVariableTable");
        if (table != null) {
            int j = 0;
            for (int i = 0; i < table.tableLength(); ++i) {
                if (table.startPc(i) != 0) continue;
                if (j == position) {
                    return table.variableName(i);
                }
                ++j;
            }
        }
        return null;
    }

    ParamInfo2(CtBehavior toPatch, CtMethod patchMethod, int position) throws PatchingException {
        this.toPatch = toPatch;
        this.patchMethod = patchMethod;
        this.patchParamPosition = position;
        try {
            String patchParamName = ParamInfo2.findName(patchMethod, this.patchParamPosition);
            if (patchParamName != null) {
                if (patchParamName.equals("__instance")) {
                    if (Modifier.isStatic(toPatch.getModifiers())) {
                        this.error = "Cannot have __instance parameter for static method";
                    } else {
                        this.name = patchParamName;
                        this.argName = "$0";
                        this.toPatchParamPosition = 0;
                    }
                    return;
                }
                if (patchParamName.equals("__args")) {
                    this.name = patchParamName;
                    this.argName = "$args";
                    return;
                }
                if (this.specialNameCheck(patchParamName)) {
                    return;
                }
                CtClass[] toPatchParamTypes = toPatch.getParameterTypes();
                boolean isStatic = Modifier.isStatic(toPatch.getModifiers());
                for (int i = 1; i < toPatchParamTypes.length + 1; ++i) {
                    String toPatchParamName = ParamInfo2.findName(toPatch, i + (isStatic ? -1 : 0));
                    if (!patchParamName.equals(toPatchParamName)) continue;
                    this.name = patchParamName;
                    this.argName = "$" + i;
                    this.toPatchParamPosition = i;
                    break;
                }
                if (this.argName == null && patchParamName.startsWith("___")) {
                    this.isPrivate = true;
                    this.name = patchParamName;
                    this.argName = patchParamName.replaceFirst("___", "");
                }
                if (this.name == null) {
                    this.error = String.format("No matching parameter with name \"%s\"", patchParamName);
                }
            }
        }
        catch (NotFoundException e) {
            throw new PatchingException(e);
        }
    }

    protected boolean specialNameCheck(String patchParamName) throws PatchingException {
        return false;
    }

    boolean isPrivateCapture() {
        return this.isPrivate;
    }

    CtClass getPrivateCaptureType() throws PatchingException {
        if (!this.isPrivateCapture()) {
            throw new PatchingException("Not a private capture, this shouldn't have been called");
        }
        CtClass declaringClass = this.toPatch.getDeclaringClass();
        try {
            return declaringClass.getDeclaredField(this.getName()).getType();
        }
        catch (NotFoundException e) {
            return null;
        }
    }

    CtClass getDestByRefType() throws ClassNotFoundException {
        String typename = null;
        for (Object o : this.getAnnotations()) {
            if (!(o instanceof ByRef) || ((ByRef)o).type().isEmpty()) continue;
            typename = ((ByRef)o).type();
        }
        try {
            return this.toPatch.getDeclaringClass().getClassPool().get(typename);
        }
        catch (NotFoundException e) {
            return null;
        }
    }

    boolean hasError() {
        return this.error != null;
    }

    String getError() {
        return this.error;
    }

    int getParamCount() {
        return this.patchMethod.getAvailableParameterAnnotations().length;
    }

    String getArgName() {
        return this.argName;
    }

    int getPatchParamPosition() {
        return this.patchParamPosition;
    }

    String getName() {
        return this.name;
    }

    CtClass getType() throws NotFoundException {
        if (this.toPatchParamPosition < 0) {
            return null;
        }
        if (this.toPatchParamPosition == 0) {
            return this.toPatch.getDeclaringClass();
        }
        return this.toPatch.getParameterTypes()[this.toPatchParamPosition - 1];
    }

    String getTypename() throws NotFoundException {
        CtClass type = this.getType();
        if (type == null) {
            return "";
        }
        return type.getName();
    }

    CtClass getPatchParamType() throws NotFoundException {
        if (this.patchParamPosition < 0) {
            return null;
        }
        return this.patchMethod.getParameterTypes()[this.patchParamPosition];
    }

    String getPatchParamTypename() throws NotFoundException {
        CtClass type = this.getPatchParamType();
        if (type == null) {
            return "";
        }
        return type.getName();
    }

    Object[] getAnnotations() throws ClassNotFoundException {
        Object[][] o = this.patchMethod.getParameterAnnotations();
        return o[this.patchParamPosition];
    }
}

