/*
 * Decompiled with CFR 0.152.
 */
package com.evacipated.cardcrawl.modthespire.patcher;

import com.evacipated.cardcrawl.modthespire.lib.ByRef;
import com.evacipated.cardcrawl.modthespire.patcher.PatchingException;
import javassist.CtBehavior;
import javassist.CtClass;
import javassist.Modifier;
import javassist.NotFoundException;
import javassist.bytecode.LocalVariableAttribute;
import javassist.bytecode.MethodInfo;

class ParamInfo {
    private CtBehavior ctBehavior;
    private int position;
    private String name;
    private boolean isPrivate = false;

    private static String findName(CtBehavior ctBehavior, int position) {
        MethodInfo methodInfo = ctBehavior.getMethodInfo2();
        LocalVariableAttribute table = (LocalVariableAttribute)methodInfo.getCodeAttribute().getAttribute("LocalVariableTable");
        if (table != null) {
            int j = 0;
            for (int i = 0; i < table.tableLength(); ++i) {
                if (table.startPc(i) != 0) continue;
                if (j == 0 && !table.variableName(i).equals("this")) {
                    ++j;
                }
                if (j == position) {
                    return table.variableName(i);
                }
                ++j;
            }
        }
        return null;
    }

    ParamInfo(CtBehavior ctBehavior, int position) {
        this.ctBehavior = ctBehavior;
        if (Modifier.isStatic(ctBehavior.getModifiers())) {
            ++position;
        }
        this.position = position;
        this.name = ParamInfo.findName(ctBehavior, position);
        try {
            if (this.position > ctBehavior.getParameterTypes().length) {
                this.position = -1;
                this.name = null;
            }
        }
        catch (NotFoundException e) {
            e.printStackTrace();
        }
        if (this.name != null && this.name.startsWith("___")) {
            this.isPrivate = true;
            this.name = this.name.replaceFirst("___", "");
        }
    }

    boolean isPrivateCapture() {
        return this.isPrivate;
    }

    CtClass getPrivateCaptureType(ParamInfo destInfo) throws PatchingException {
        if (!destInfo.isPrivateCapture()) {
            throw new PatchingException("Not a private capture, this shouldn't have been called");
        }
        CtClass declaringClass = this.ctBehavior.getDeclaringClass();
        try {
            return declaringClass.getDeclaredField(destInfo.getName()).getType();
        }
        catch (NotFoundException e) {
            return null;
        }
    }

    CtClass getDestByRefType(ParamInfo destInfo) throws ClassNotFoundException {
        String typename = null;
        for (Object o : destInfo.getAnnotations()) {
            if (!(o instanceof ByRef) || ((ByRef)o).type().isEmpty()) continue;
            typename = ((ByRef)o).type();
        }
        try {
            return this.ctBehavior.getDeclaringClass().getClassPool().get(typename);
        }
        catch (NotFoundException e) {
            return null;
        }
    }

    int getParamCount() {
        return this.ctBehavior.getAvailableParameterAnnotations().length;
    }

    int getPosition() {
        return this.position;
    }

    String getName() {
        return this.name;
    }

    CtClass getType() throws NotFoundException {
        if (this.position < 0) {
            return null;
        }
        if (this.position == 0) {
            return this.ctBehavior.getDeclaringClass();
        }
        return this.ctBehavior.getParameterTypes()[this.position - 1];
    }

    String getTypename() throws NotFoundException {
        CtClass type = this.getType();
        if (type == null) {
            return "";
        }
        return type.getName();
    }

    Object[] getAnnotations() throws ClassNotFoundException {
        return this.ctBehavior.getParameterAnnotations()[this.position - 1];
    }
}

