/*
 * Decompiled with CFR 0.152.
 */
package com.evacipated.cardcrawl.modthespire.patcher;

import com.evacipated.cardcrawl.modthespire.patcher.PatchInfo;
import com.evacipated.cardcrawl.modthespire.patcher.PatchingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javassist.CannotCompileException;
import javassist.CtBehavior;
import javassist.expr.ExprEditor;

public class InstrumentPatchInfo
extends PatchInfo {
    private Method method;

    public InstrumentPatchInfo(CtBehavior ctMethodToPatch, Method method) {
        super(ctMethodToPatch, null);
        this.method = method;
    }

    @Override
    protected String patchClassName() {
        return this.method.getDeclaringClass().getName();
    }

    @Override
    protected String debugMsg() {
        return "Adding Instrument...";
    }

    @Override
    public int patchOrdering() {
        return -1;
    }

    @Override
    public void doPatch() throws PatchingException {
        try {
            ExprEditor exprEditor = (ExprEditor)this.method.invoke(null, new Object[0]);
            this.ctMethodToPatch.instrument(exprEditor);
        }
        catch (IllegalAccessException | InvocationTargetException | CannotCompileException e) {
            throw new PatchingException(e);
        }
    }
}

