/*
 * Decompiled with CFR 0.152.
 */
package com.evacipated.cardcrawl.modthespire.patcher;

import com.evacipated.cardcrawl.modthespire.lib.SpireInsertPatch;
import com.evacipated.cardcrawl.modthespire.patcher.ParamInfo;
import com.evacipated.cardcrawl.modthespire.patcher.ParamInfo2;
import com.evacipated.cardcrawl.modthespire.patcher.ParameterPatchInfo;
import com.evacipated.cardcrawl.modthespire.patcher.PatchingException;
import java.util.Arrays;
import java.util.List;
import javassist.CannotCompileException;
import javassist.CtBehavior;
import javassist.CtMethod;

public class InsertPatchInfo
extends ParameterPatchInfo {
    private SpireInsertPatch info;
    private List<LineNumberAndPatchType> locs;

    public InsertPatchInfo(SpireInsertPatch info, List<LineNumberAndPatchType> locs, CtBehavior ctMethodToPatch, CtMethod patchMethod) {
        super(ctMethodToPatch, patchMethod);
        this.canSpireReturn = true;
        this.canByRefParams = true;
        this.info = info;
        this.locs = locs;
    }

    @Override
    protected String debugMsg() {
        StringBuilder msgBuilder = new StringBuilder("");
        for (LineNumberAndPatchType patchLoc : this.locs) {
            switch (patchLoc.patchType) {
                case ABSOLUTE: {
                    msgBuilder.append("Adding Insert @ " + patchLoc.lineNumber + "...\n");
                    break;
                }
                case RELATIVE: {
                    msgBuilder.append("Adding Insert @ r" + patchLoc.relativeLineNumber + " (abs:" + patchLoc.lineNumber + ")...\n");
                }
            }
        }
        return msgBuilder.toString();
    }

    @Override
    public int patchOrdering() {
        return -2;
    }

    @Override
    protected ParameterPatchInfo.ParamTransformer makeTransformer(ParamInfo src, ParamInfo dest) {
        return new InsertParamTransformer(src, dest);
    }

    @Override
    protected ParamInfo2 makeInfo2(CtBehavior toPatch, CtMethod patchMethod, int position) throws PatchingException {
        return new InsertParamInfo2(toPatch, patchMethod, position);
    }

    private void applyPatch(String src, int loc) throws CannotCompileException {
        this.ctMethodToPatch.insertAt(loc, src);
    }

    @Override
    protected void applyPatch(String src) throws CannotCompileException {
        for (LineNumberAndPatchType patchLoc : this.locs) {
            this.applyPatch(src, patchLoc.lineNumber);
        }
    }

    protected class InsertParamInfo2
    extends ParamInfo2 {
        InsertParamInfo2(CtBehavior toPatch, CtMethod patchMethod, int position) throws PatchingException {
            super(toPatch, patchMethod, position);
        }

        @Override
        protected boolean specialNameCheck(String patchParamName) throws PatchingException {
            if (Arrays.asList(InsertPatchInfo.this.info.localvars()).contains(patchParamName)) {
                this.name = patchParamName;
                this.argName = patchParamName;
                return true;
            }
            return false;
        }
    }

    protected class InsertParamTransformer
    extends ParameterPatchInfo.ParamTransformer {
        protected InsertParamTransformer(ParamInfo src, ParamInfo dest) {
            super(InsertPatchInfo.this, src, dest);
        }

        @Override
        protected String getParamName() throws PatchingException {
            int localVarStartPosition = this.destInfo.getParamCount() - InsertPatchInfo.this.info.localvars().length + 1;
            if (this.destInfo.getPosition() >= localVarStartPosition) {
                int idx = this.destInfo.getPosition() - localVarStartPosition;
                return InsertPatchInfo.this.info.localvars()[idx];
            }
            return super.getParamName();
        }
    }

    public static enum InsertPatchType {
        ABSOLUTE,
        RELATIVE;

    }

    public static class LineNumberAndPatchType {
        public int lineNumber;
        public int relativeLineNumber;
        public InsertPatchType patchType;

        public LineNumberAndPatchType(int lineNumber) {
            this.lineNumber = lineNumber;
            this.patchType = InsertPatchType.ABSOLUTE;
        }

        public LineNumberAndPatchType(int lineNumber, int relativeLineNumber) {
            this.lineNumber = lineNumber;
            this.relativeLineNumber = relativeLineNumber;
            this.patchType = InsertPatchType.RELATIVE;
        }
    }
}

