/*
 * Decompiled with CFR 0.152.
 */
package com.evacipated.cardcrawl.modthespire.patcher;

import com.evacipated.cardcrawl.modthespire.Loader;
import com.evacipated.cardcrawl.modthespire.lib.SpireField;
import com.evacipated.cardcrawl.modthespire.lib.StaticSpireField;
import com.evacipated.cardcrawl.modthespire.patcher.PatchInfo;
import com.evacipated.cardcrawl.modthespire.patcher.PatchingException;
import java.lang.reflect.Proxy;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewConstructor;
import javassist.CtNewMethod;
import javassist.NotFoundException;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.BadBytecode;
import javassist.bytecode.ConstPool;
import javassist.bytecode.Descriptor;
import javassist.bytecode.DuplicateMemberException;
import javassist.bytecode.SignatureAttribute;
import javassist.bytecode.annotation.Annotation;
import javassist.bytecode.annotation.AnnotationImpl;
import javassist.expr.ExprEditor;
import javassist.expr.MethodCall;
import javassist.expr.NewExpr;

public class ClassPatchInfo
extends PatchInfo {
    private CtClass ctPatchClass;
    private CtClass ctClassToPatch;

    public ClassPatchInfo(CtClass ctClassToPatch, CtClass ctPatchClass) {
        super(null, null);
        this.ctClassToPatch = ctClassToPatch;
        this.ctPatchClass = ctPatchClass;
    }

    @Override
    public void debugPrint() {
        System.out.println("Patch Class: [" + this.patchClassName() + "]");
        System.out.println(" - Patching [" + this.ctClassToPatch.getName() + "]");
    }

    @Override
    protected String debugMsg() {
        return "";
    }

    @Override
    protected String patchClassName() {
        return this.ctPatchClass.getName();
    }

    @Override
    public int patchOrdering() {
        return -5;
    }

    @Override
    public void doPatch() throws PatchingException {
        try {
            block6: for (CtField f : this.ctPatchClass.getDeclaredFields()) {
                boolean isSpireField;
                boolean isStatic = f.getType().getName().equals(StaticSpireField.class.getCanonicalName());
                boolean bl = isSpireField = isStatic || f.getType().getName().equals(SpireField.class.getCanonicalName());
                if (!isSpireField) continue;
                int tries = 100;
                while (tries > 0) {
                    String fieldType;
                    String fieldName;
                    block23: {
                        --tries;
                        fieldName = String.format("%s_%d", f.getName(), new Random().nextInt(1000));
                        try {
                            SignatureAttribute.TypeArgument[] typeArguments;
                            SignatureAttribute.ObjectType fieldSig = SignatureAttribute.toFieldSignature(f.getGenericSignature());
                            if (fieldSig instanceof SignatureAttribute.ClassType) {
                                typeArguments = ((SignatureAttribute.ClassType)fieldSig).getTypeArguments();
                                if (typeArguments == null || typeArguments.length != 1) {
                                    throw new BadBytecode("fake");
                                }
                            } else {
                                throw new BadBytecode("fake");
                            }
                            String descriptor = typeArguments[0].getType().encode();
                            descriptor = descriptor.replaceAll("<.+>", "");
                            fieldType = Descriptor.toClassName(descriptor);
                        }
                        catch (BadBytecode e) {
                            fieldType = f.getGenericSignature();
                            Pattern pattern = Pattern.compile("Lcom/evacipated/cardcrawl/modthespire/lib/(?:Static)?SpireField<(\\[?)L(.+);>;");
                            Matcher matcher = pattern.matcher(fieldType);
                            if (!matcher.find() && Loader.DEBUG) {
                                System.out.println(fieldType);
                            }
                            boolean isArrayType = !matcher.group(1).isEmpty();
                            fieldType = matcher.group(2).replace('/', '.');
                            if (fieldType.contains("<")) {
                                fieldType = fieldType.substring(0, fieldType.indexOf(60));
                            }
                            if (!isArrayType) break block23;
                            fieldType = fieldType + "[]";
                        }
                    }
                    String str = String.format("public%s %s %s;", isStatic ? " static" : "", fieldType, fieldName);
                    if (Loader.DEBUG) {
                        System.out.println(" - Adding Field: " + str);
                    }
                    CtField new_f = CtField.make(str, this.ctClassToPatch);
                    ConstPool constPool = this.ctClassToPatch.getClassFile().getConstPool();
                    AnnotationsAttribute attr = new AnnotationsAttribute(constPool, "RuntimeVisibleAnnotations");
                    for (Object a : f.getAvailableAnnotations()) {
                        if (!(Proxy.getInvocationHandler(a) instanceof AnnotationImpl)) continue;
                        if (Loader.DEBUG) {
                            System.out.println("   - Copying annotation: " + a);
                        }
                        AnnotationImpl impl = (AnnotationImpl)Proxy.getInvocationHandler(a);
                        Annotation annotation = new Annotation(impl.getTypeName(), constPool);
                        if (impl.getAnnotation().getMemberNames() != null) {
                            for (Object memberName : impl.getAnnotation().getMemberNames()) {
                                annotation.addMemberValue((String)memberName, impl.getAnnotation().getMemberValue((String)memberName));
                            }
                        }
                        attr.addAnnotation(annotation);
                    }
                    new_f.getFieldInfo().addAttribute(attr);
                    String expr = String.format("(%s) %s.%s.getDefaultValue()", fieldType, this.ctPatchClass.getName(), f.getName());
                    try {
                        this.ctClassToPatch.addField(new_f, CtField.Initializer.byExpr(expr));
                    }
                    catch (DuplicateMemberException e) {
                        if (tries != 0) continue;
                        throw e;
                    }
                    CtConstructor staticinit = this.ctPatchClass.getClassInitializer();
                    if (staticinit == null) {
                        staticinit = this.ctPatchClass.makeClassInitializer();
                    }
                    CtClass ctAccessor = this.ctPatchClass.makeNestedClass(fieldName + "_Accessor", true);
                    ctAccessor.setSuperclass(f.getType());
                    FindSpireFieldInitializers found = new FindSpireFieldInitializers(this.ctPatchClass.getClassPool(), ctAccessor);
                    this.ctPatchClass.instrument(found);
                    CtClass ctSpireField = f.getType().getClassPool().get(SpireField.class.getName());
                    ctAccessor.addConstructor(CtNewConstructor.make(new CtClass[]{ctSpireField}, null, 2, null, null, ctAccessor));
                    String getStr = "";
                    if (found.madeGet) {
                        getStr = "super_get(__instance);";
                    }
                    ctAccessor.addMethod(CtNewMethod.make(String.format("public Object get(Object __instance) {" + getStr + "return ((%s) __instance).%s;}", this.ctClassToPatch.getName(), fieldName), ctAccessor));
                    String setStr = "";
                    if (found.madeSet) {
                        setStr = String.format("super_set(__instance, (%s) value);", found.setType.getName());
                    }
                    ctAccessor.addMethod(CtNewMethod.make(String.format("public void set(Object __instance, Object value) {((%s) __instance).%s = (%s) value;" + setStr + "}", this.ctClassToPatch.getName(), fieldName, fieldType), ctAccessor));
                    String src = String.format("{\n%s = new %s(%s);%s.initialize(%s, \"%s\");\n}", f.getName(), ctAccessor.getName(), f.getName(), f.getName(), this.ctClassToPatch.getName() + ".class", fieldName);
                    if (Loader.DEBUG) {
                        System.out.println(src);
                    }
                    staticinit.insertAfter(src);
                    continue block6;
                }
            }
            if (Loader.DEBUG) {
                System.out.println();
            }
        }
        catch (CannotCompileException | NotFoundException e) {
            throw new PatchingException(e);
        }
    }

    private static class FindSpireFieldInitializers
    extends ExprEditor {
        private ClassPool pool;
        private CtClass ctSpireField;
        private CtClass ctStaticSpireField;
        private CtClass ctAccessor;
        boolean madeGet = false;
        boolean madeSet = false;
        CtClass setType = null;

        FindSpireFieldInitializers(ClassPool pool, CtClass ctAccessor) throws NotFoundException {
            this.pool = pool;
            this.ctSpireField = pool.get(SpireField.class.getName());
            this.ctStaticSpireField = pool.get(StaticSpireField.class.getName());
            this.ctAccessor = ctAccessor;
        }

        @Override
        public void edit(NewExpr e) throws CannotCompileException {
            if (e.getClassName().endsWith("_Accessor")) {
                return;
            }
            try {
                CtClass ctOriginal;
                CtClass ctClass = ctOriginal = this.pool.get(e.getClassName());
                do {
                    if (!this.ctSpireField.equals(ctClass) && !this.ctStaticSpireField.equals(ctClass)) continue;
                    if (!ctOriginal.equals(ctClass)) {
                        this.scrubSuperMethodCalls(ctOriginal, "get");
                        this.scrubSuperMethodCalls(ctOriginal, "set");
                    }
                    break;
                } while ((ctClass = ctClass.getSuperclass()) != null);
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
        }

        private void scrubSuperMethodCalls(final CtClass ctClass, final String methodName) throws NotFoundException, CannotCompileException {
            block10: for (CtMethod m : ctClass.getDeclaredMethods(methodName)) {
                try {
                    this.ctAccessor.getDeclaredMethod("super_" + methodName);
                }
                catch (NotFoundException e) {
                    CtMethod newMethod = CtNewMethod.copy(m, "super_" + methodName, this.ctAccessor, null);
                    newMethod.instrument(new ExprEditor(){

                        @Override
                        public void edit(MethodCall m) throws CannotCompileException {
                            try {
                                CtMethod method = m.getMethod();
                                if (method.getName().equals(methodName) && method.getDeclaringClass().equals(ctClass.getSuperclass())) {
                                    m.replace("$_ = null;");
                                }
                            }
                            catch (NotFoundException e) {
                                throw new CannotCompileException(e);
                            }
                        }
                    });
                    this.ctAccessor.addMethod(newMethod);
                    switch (methodName) {
                        case "get": {
                            this.madeGet = true;
                            continue block10;
                        }
                        case "set": {
                            this.madeSet = true;
                            this.setType = newMethod.getParameterTypes()[1];
                        }
                    }
                }
            }
        }
    }
}

