/*
 * Decompiled with CFR 0.152.
 */
package com.evacipated.cardcrawl.modthespire;

import com.evacipated.cardcrawl.modthespire.ByteArrayMapClassPath;
import com.evacipated.cardcrawl.modthespire.EnumBusterReflect;
import com.evacipated.cardcrawl.modthespire.Loader;
import com.evacipated.cardcrawl.modthespire.MTSClassLoader;
import com.evacipated.cardcrawl.modthespire.MTSClassPool;
import com.evacipated.cardcrawl.modthespire.ModInfo;
import com.evacipated.cardcrawl.modthespire.ReflectionHelper;
import com.evacipated.cardcrawl.modthespire.lib.SpireEnum;
import com.evacipated.cardcrawl.modthespire.lib.SpireInitializer;
import com.evacipated.cardcrawl.modthespire.lib.SpireInsertPatch;
import com.evacipated.cardcrawl.modthespire.lib.SpireInstrumentPatch;
import com.evacipated.cardcrawl.modthespire.lib.SpireOverride;
import com.evacipated.cardcrawl.modthespire.lib.SpirePatch;
import com.evacipated.cardcrawl.modthespire.lib.SpirePatch2;
import com.evacipated.cardcrawl.modthespire.lib.SpirePatches;
import com.evacipated.cardcrawl.modthespire.lib.SpirePatches2;
import com.evacipated.cardcrawl.modthespire.lib.SpirePostfixPatch;
import com.evacipated.cardcrawl.modthespire.lib.SpirePrefixPatch;
import com.evacipated.cardcrawl.modthespire.lib.SpireRawPatch;
import com.evacipated.cardcrawl.modthespire.lib.SpireSideload;
import com.evacipated.cardcrawl.modthespire.lib.SpireSuper;
import com.evacipated.cardcrawl.modthespire.patcher.ClassPatchInfo;
import com.evacipated.cardcrawl.modthespire.patcher.InsertPatchInfo;
import com.evacipated.cardcrawl.modthespire.patcher.InstrumentPatchInfo;
import com.evacipated.cardcrawl.modthespire.patcher.LocatorInfo;
import com.evacipated.cardcrawl.modthespire.patcher.MissingParamTypesException;
import com.evacipated.cardcrawl.modthespire.patcher.PatchInfo;
import com.evacipated.cardcrawl.modthespire.patcher.PatchInfoComparator;
import com.evacipated.cardcrawl.modthespire.patcher.PatchingException;
import com.evacipated.cardcrawl.modthespire.patcher.PostfixPatchInfo;
import com.evacipated.cardcrawl.modthespire.patcher.PrefixPatchInfo;
import com.evacipated.cardcrawl.modthespire.patcher.RawPatchInfo;
import com.evacipated.cardcrawl.modthespire.patcher.ReplacePatchInfo;
import com.evacipated.cardcrawl.modthespire.patcher.javassist.MyCodeConverter;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javassist.CannotCompileException;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtPrimitiveType;
import javassist.Modifier;
import javassist.NotFoundException;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.ConstPool;
import javassist.bytecode.DuplicateMemberException;
import javassist.bytecode.annotation.Annotation;
import javassist.bytecode.annotation.AnnotationImpl;
import javassist.expr.ExprEditor;
import javassist.expr.MethodCall;
import javax.swing.JOptionPane;
import org.scannotation.AnnotationDB;

public class Patcher {
    public static Map<URL, AnnotationDB> annotationDBMap = new HashMap<URL, AnnotationDB>();
    private static Map<Class<?>, EnumBusterReflect> enumBusterMap = new HashMap();
    private static TreeSet<PatchInfo> patchInfos = new TreeSet<PatchInfo>(new PatchInfoComparator());

    public static void initializeMods(ClassLoader loader, ModInfo ... modInfos) throws ClassNotFoundException, InvocationTargetException, IllegalAccessException {
        for (ModInfo info : modInfos) {
            if (annotationDBMap.containsKey(info.jarURL)) {
                Set<String> initializers = annotationDBMap.get(info.jarURL).getAnnotationIndex().get(SpireInitializer.class.getName());
                if (initializers == null) continue;
                System.out.println(" - " + info.Name);
                for (String initializer : initializers) {
                    System.out.println("   - " + initializer);
                    try {
                        long startTime = System.nanoTime();
                        Method init = null;
                        if (info.ID.startsWith("__sideload_")) {
                            init = loader.loadClass(initializer).getDeclaredMethod("sideload", new Class[0]);
                        }
                        if (init == null) {
                            init = loader.loadClass(initializer).getDeclaredMethod("initialize", new Class[0]);
                        }
                        init.invoke(null, new Object[0]);
                        long endTime = System.nanoTime();
                        long duration = endTime - startTime;
                        System.out.println("   - " + duration / 1000000L + "ms");
                    }
                    catch (NoSuchMethodException e) {
                        System.out.println("WARNING: Unable to find method initialize() on class marked @SpireInitializer: " + initializer);
                    }
                }
                continue;
            }
            System.err.println(info.jarURL + " Not in DB map. Something is very wrong");
        }
    }

    public static ModInfo[] sideloadMods(MTSClassLoader tmpPatchingLoader, MTSClassLoader loader, ClassPool pool, ModInfo[] allModInfos, ModInfo[] modInfos) throws IOException, NotFoundException, ClassNotFoundException {
        ArrayList sideloadList = new ArrayList();
        for (ModInfo modInfo : modInfos) {
            if (modInfo.MTS_Version.compareTo(Loader.MTS_VERSION) <= 0) {
                AnnotationDB db;
                if (annotationDBMap.containsKey(modInfo.jarURL)) {
                    db = annotationDBMap.get(modInfo.jarURL);
                } else {
                    db = new AnnotationDB();
                    annotationDBMap.put(modInfo.jarURL, db);
                }
                db.scanArchives(modInfo.jarURL);
                Iterable tmp = db.getAnnotationIndex().get(SpireSideload.class.getName());
                if (tmp == null) continue;
                tmp.forEach(sideloadList::add);
                continue;
            }
            String str = "ERROR: " + modInfo.Name + " requires ModTheSpire v" + modInfo.MTS_Version + " or greater!";
            System.out.println(str);
            JOptionPane.showMessageDialog(null, str);
        }
        for (String class_name : sideloadList) {
            CtClass ctSideloadClass = pool.get(class_name);
            SpireSideload sideload = (SpireSideload)ctSideloadClass.getAnnotation(SpireSideload.class);
            if (sideload == null) continue;
            for (String modid : sideload.modIDs()) {
                if (Loader.isModLoaded(modid)) continue;
                System.out.print("Sideloading " + modid + "...");
                ModInfo info = null;
                for (ModInfo allInfo : allModInfos) {
                    if (!allInfo.ID.equals(modid)) continue;
                    info = allInfo;
                    break;
                }
                if (info != null) {
                    info.ID = "__sideload_" + info.ID;
                    tmpPatchingLoader.addURL(info.jarURL);
                    loader.addURL(info.jarURL);
                    modInfos = Arrays.copyOf(modInfos, modInfos.length + 1);
                    modInfos[modInfos.length - 1] = info;
                    System.out.println("Done.");
                    continue;
                }
                System.out.println("Not found.");
            }
        }
        return modInfos;
    }

    public static List<Iterable<String>> findPatches(URL[] urls) throws IOException {
        return Patcher.findPatches(urls, null);
    }

    public static List<Iterable<String>> findPatches(ModInfo[] modInfos) throws IOException {
        URL[] urls = new URL[modInfos.length];
        for (int i = 0; i < modInfos.length; ++i) {
            urls[i] = modInfos[i].jarURL;
        }
        return Patcher.findPatches(urls, modInfos);
    }

    public static List<Iterable<String>> findPatches(URL[] urls, ModInfo[] modInfos) throws IOException {
        ArrayList<Iterable<String>> patchSetList = new ArrayList<Iterable<String>>();
        for (int i = 0; i < urls.length; ++i) {
            if (modInfos == null || modInfos[i].MTS_Version.compareTo(Loader.MTS_VERSION) <= 0) {
                AnnotationDB db;
                if (annotationDBMap.containsKey(urls[i])) {
                    db = annotationDBMap.get(urls[i]);
                } else {
                    db = new AnnotationDB();
                    annotationDBMap.put(urls[i], db);
                }
                db.scanArchives(urls[i]);
                HashSet<String> set = new HashSet<String>();
                Set<String> it = db.getAnnotationIndex().get(SpirePatch.class.getName());
                if (it != null) {
                    set.addAll(it);
                }
                if ((it = db.getAnnotationIndex().get(SpirePatches.class.getName())) != null) {
                    set.addAll(it);
                }
                if ((it = db.getAnnotationIndex().get(SpirePatch2.class.getName())) != null) {
                    set.addAll(it);
                }
                if ((it = db.getAnnotationIndex().get(SpirePatches2.class.getName())) != null) {
                    set.addAll(it);
                }
                patchSetList.add(set);
                continue;
            }
            String str = "ERROR: " + modInfos[i].Name + " requires ModTheSpire v" + modInfos[i].MTS_Version + " or greater!";
            System.out.println(str);
            JOptionPane.showMessageDialog(null, str);
        }
        return patchSetList;
    }

    public static void patchEnums(ClassLoader loader, ClassPool pool, ModInfo[] modInfos) throws IOException, ClassNotFoundException, NotFoundException, CannotCompileException {
        URL[] urls = new URL[modInfos.length];
        for (int i = 0; i < modInfos.length; ++i) {
            urls[i] = modInfos[i].jarURL;
        }
        Patcher.patchEnums(loader, pool, urls);
    }

    public static void patchEnums(ClassLoader loader, ClassPool pool, URL ... urls) throws IOException, ClassNotFoundException, NotFoundException, CannotCompileException {
        AnnotationDB db = new AnnotationDB();
        db.setScanClassAnnotations(false);
        db.setScanMethodAnnotations(false);
        db.scanArchives(urls);
        Set<String> annotations = db.getAnnotationIndex().get(SpireEnum.class.getName());
        if (annotations == null) {
            return;
        }
        boolean hasPrintedWarning = false;
        for (String s : annotations) {
            CtClass cls = pool.get(s);
            for (CtField field : cls.getDeclaredFields()) {
                SpireEnum spireEnum = (SpireEnum)field.getAnnotation(SpireEnum.class);
                if (spireEnum == null) continue;
                String enumName = field.getName();
                if (!spireEnum.name().isEmpty()) {
                    enumName = spireEnum.name();
                }
                try {
                    CtClass ctClass = pool.get(field.getType().getName());
                    CtField f = new CtField(ctClass, enumName, ctClass);
                    f.setModifiers(16409);
                    ConstPool constPool = ctClass.getClassFile().getConstPool();
                    AnnotationsAttribute attr = new AnnotationsAttribute(constPool, "RuntimeVisibleAnnotations");
                    for (Object a : field.getAvailableAnnotations()) {
                        AnnotationImpl impl;
                        if (!(Proxy.getInvocationHandler(a) instanceof AnnotationImpl) || (impl = (AnnotationImpl)Proxy.getInvocationHandler(a)).getTypeName().equals(SpireEnum.class.getName())) continue;
                        Annotation annotation = new Annotation(impl.getTypeName(), constPool);
                        if (impl.getAnnotation().getMemberNames() != null) {
                            for (Object memberName : impl.getAnnotation().getMemberNames()) {
                                annotation.addMemberValue((String)memberName, impl.getAnnotation().getMemberValue((String)memberName));
                            }
                        }
                        attr.addAnnotation(annotation);
                    }
                    f.getFieldInfo().addAttribute(attr);
                    ctClass.addField(f);
                }
                catch (DuplicateMemberException ignore) {
                    if (!Loader.DEBUG && !hasPrintedWarning) {
                        hasPrintedWarning = true;
                        System.out.println();
                    }
                    System.out.println(String.format("Warning: @SpireEnum %s %s is already defined.", field.getType().getName(), enumName));
                }
            }
        }
    }

    public static void bustEnums(ClassLoader loader, ModInfo[] modInfos) throws IOException, ClassNotFoundException, NoSuchFieldException, IllegalAccessException {
        URL[] urls = new URL[modInfos.length];
        for (int i = 0; i < modInfos.length; ++i) {
            urls[i] = modInfos[i].jarURL;
        }
        Patcher.bustEnums(loader, urls);
    }

    public static void bustEnums(ClassLoader loader, URL ... urls) throws IOException, ClassNotFoundException, NoSuchFieldException, IllegalAccessException {
        AnnotationDB db = new AnnotationDB();
        db.setScanClassAnnotations(false);
        db.setScanMethodAnnotations(false);
        db.scanArchives(urls);
        Set<String> annotations = db.getAnnotationIndex().get(SpireEnum.class.getName());
        if (annotations == null) {
            return;
        }
        for (String s : annotations) {
            Class<?> cls = loader.loadClass(s);
            for (Field field : cls.getDeclaredFields()) {
                EnumBusterReflect buster;
                SpireEnum spireEnum = field.getDeclaredAnnotation(SpireEnum.class);
                if (spireEnum == null) continue;
                String enumName = field.getName();
                if (!spireEnum.name().isEmpty()) {
                    enumName = spireEnum.name();
                }
                if (enumBusterMap.containsKey(field.getType())) {
                    buster = enumBusterMap.get(field.getType());
                } else {
                    buster = new EnumBusterReflect(loader, field.getType());
                    enumBusterMap.put(field.getType(), buster);
                }
                Enum<?> enumValue = buster.make(enumName);
                buster.addByValue(enumValue);
                try {
                    Field constantField = field.getType().getField(enumName);
                    ReflectionHelper.setStaticFinalField(constantField, enumValue);
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    // empty catch block
                }
                field.setAccessible(true);
                field.set(null, enumValue);
            }
        }
    }

    public static void finalizePatches(ClassLoader loader) throws Exception {
        System.out.printf("Injecting patches...", new Object[0]);
        if (Loader.DEBUG) {
            System.out.println();
            System.out.println();
        }
        for (PatchInfo p : patchInfos) {
            if (Loader.DEBUG) {
                p.debugPrint();
            }
            try {
                p.doPatch();
            }
            catch (Exception e) {
                if (!Loader.DEBUG) {
                    System.out.println();
                    p.debugPrint();
                }
                throw e;
            }
            if (!Loader.DEBUG) continue;
            System.out.println();
        }
        patchInfos.clear();
        System.out.println("Done.");
    }

    public static ClassPath compilePatches(ClassLoader loader, MTSClassPool pool) throws CannotCompileException {
        System.out.printf("Compiling patched classes...", new Object[0]);
        if (Loader.DEBUG) {
            System.out.println();
        }
        TreeMap<String, CtClass> ctClasses = new TreeMap<String, CtClass>();
        for (CtClass cls : pool.getModifiedClasses()) {
            ctClasses.put(Patcher.countSuperClasses(cls) + cls.getName(), cls);
        }
        ByteArrayMapClassPath cp = new ByteArrayMapClassPath();
        for (Map.Entry cls : ctClasses.entrySet()) {
            if (Loader.DEBUG) {
                System.out.println("  " + ((CtClass)cls.getValue()).getName());
            }
            ((CtClass)cls.getValue()).toClass(loader, null);
            cp.addClass((CtClass)cls.getValue());
            ((CtClass)cls.getValue()).detach();
        }
        System.out.println("Done.");
        if (Loader.DEBUG) {
            cp.printDebugInfo();
        }
        return cp;
    }

    private static int countSuperClasses(CtClass cls) {
        String name = cls.getName();
        int count = 0;
        while (cls != null) {
            try {
                cls = cls.getSuperclass();
            }
            catch (NotFoundException e) {
                break;
            }
            ++count;
        }
        return count;
    }

    public static void injectPatches(ClassLoader loader, ClassPool pool, List<Iterable<String>> class_names) throws Exception {
        for (Iterable<String> it : class_names) {
            Patcher.injectPatches(loader, pool, it);
            PatchInfo.nextMod();
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void injectPatches(ClassLoader loader, ClassPool pool, Iterable<String> class_names) throws Exception {
        if (class_names == null) {
            return;
        }
        for (String cls_name : class_names) {
            ctPatchClass = pool.get(cls_name);
            if (!Modifier.isPublic(ctPatchClass.getModifiers())) {
                ctPatchClass.setModifiers(Modifier.setPublic(ctPatchClass.getModifiers()));
            }
            patchArr = new ArrayList<SpirePatch>();
            patches = (SpirePatches)ctPatchClass.getAnnotation(SpirePatches.class);
            if (patches != null) {
                Collections.addAll(patchArr, patches.value());
            } else {
                patch = (SpirePatch)ctPatchClass.getAnnotation(SpirePatch.class);
                if (patch != null) {
                    patchArr.add(patch);
                }
            }
            patches2 = (SpirePatches2)ctPatchClass.getAnnotation(SpirePatches2.class);
            if (patches2 != null) {
                Arrays.stream(patches2.value()).map((Function<SpirePatch2, SpirePatch>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$injectPatches$0(java.lang.ClassLoader javassist.ClassPool com.evacipated.cardcrawl.modthespire.lib.SpirePatch2 ), (Lcom/evacipated/cardcrawl/modthespire/lib/SpirePatch2;)Lcom/evacipated/cardcrawl/modthespire/lib/SpirePatch;)((ClassLoader)loader, (ClassPool)pool)).forEachOrdered((Consumer<SpirePatch>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, add(E ), (Lcom/evacipated/cardcrawl/modthespire/lib/SpirePatch;)V)(patchArr));
            } else {
                patch2 = (SpirePatch2)ctPatchClass.getAnnotation(SpirePatch2.class);
                if (patch2 != null) {
                    patchArr.add(Patcher.convertSpirePatch2To1(loader, pool, patch2));
                }
            }
            iter = patchArr.iterator();
            while (iter.hasNext()) {
                patch = (SpirePatch)iter.next();
                modId = patch.requiredModId();
                if (modId.isEmpty() || !Arrays.stream(Loader.MODINFOS).noneMatch((Predicate<ModInfo>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$injectPatches$1(java.lang.String com.evacipated.cardcrawl.modthespire.ModInfo ), (Lcom/evacipated/cardcrawl/modthespire/ModInfo;)Z)((String)modId))) continue;
                iter.remove();
            }
            for (SpirePatch patch : patchArr) {
                block51: {
                    ctClsToPatch = null;
                    try {
                        if (!patch.clz().equals(Void.TYPE)) {
                            ctClsToPatch = pool.get(patch.clz().getName());
                        } else if (!patch.cls().isEmpty()) {
                            ctClsToPatch = pool.get(patch.cls());
                        }
                    }
                    catch (NotFoundException e) {
                        if (patch.optional()) continue;
                        throw new PatchingException(ctPatchClass.getName(), e);
                    }
                    if (ctClsToPatch == null) {
                        throw new PatchingException(ctPatchClass, "No class defined to patch. Must define either clz or cls in @SpirePatch.");
                    }
                    ctMethodToPatch = null;
                    try {
                        block52: {
                            ctParamTypes = Patcher.patchParamTypez(pool, patch);
                            if (ctParamTypes == null) {
                                ctParamTypes = Patcher.patchParamTypes(pool, patch);
                            }
                            if (!patch.method().equals("<ctor>")) break block52;
                            if (ctParamTypes != null) ** GOTO lbl61
                            constructors = ctClsToPatch.getDeclaredConstructors();
                            if (constructors.length == 1) {
                                ctMethodToPatch = constructors[0];
                            } else {
                                throw new MissingParamTypesException(ctPatchClass, patch);
lbl61:
                                // 1 sources

                                ctMethodToPatch = ctClsToPatch.getDeclaredConstructor(ctParamTypes);
                            }
                            break block51;
                        }
                        if (patch.method().equals("<staticinit>")) {
                            ctMethodToPatch = ctClsToPatch.getClassInitializer();
                            if (ctMethodToPatch == null) {
                                System.out.println("No class initializer, making one");
                                ctMethodToPatch = ctClsToPatch.makeClassInitializer();
                            }
                            break block51;
                        }
                        if (patch.method().equals("<class>")) {
                            Patcher.patchInfos.add(new ClassPatchInfo(ctClsToPatch, ctPatchClass));
                            break block51;
                        }
                        if (ctParamTypes != null) ** GOTO lbl82
                        methods = ctClsToPatch.getDeclaredMethods(patch.method());
                        if (methods.length == 1) {
                            ctMethodToPatch = methods[0];
                        } else {
                            if (methods.length == 0) {
                                throw new NoSuchMethodException(String.format("Patch %s:\nNo method named [%s] found on\nclass [%s]", new Object[]{ctPatchClass.getName(), patch.method(), Patcher.patchClassName(patch)}));
                            }
                            throw new MissingParamTypesException(ctPatchClass, patch);
lbl82:
                            // 1 sources

                            ctMethodToPatch = ctClsToPatch.getDeclaredMethod(patch.method(), ctParamTypes);
                        }
                    }
                    catch (NotFoundException e) {
                        throw new NoSuchMethodException(String.format("Patch %s:\nNo method [%s(%s)] found on\nclass [%s]", new Object[]{ctPatchClass.getName(), patch.method(), Patcher.patchParamTypesString(patch), Patcher.patchClassName(patch)}));
                    }
                }
                if (ctMethodToPatch == null) continue;
                for (CtMethod m : ctPatchClass.getDeclaredMethods()) {
                    p = null;
                    if (m.getName().equals("Prefix") || m.hasAnnotation(SpirePrefixPatch.class)) {
                        p = new PrefixPatchInfo(ctMethodToPatch, m).setSpirePatch(patch);
                    } else if (m.getName().equals("Postfix") || m.hasAnnotation(SpirePostfixPatch.class)) {
                        p = new PostfixPatchInfo(ctMethodToPatch, m).setSpirePatch(patch);
                    } else {
                        if (m.getName().equals("Locator")) continue;
                        if (m.getName().equals("Insert") || m.hasAnnotation(SpireInsertPatch.class)) {
                            insertPatch = (SpireInsertPatch)m.getAnnotation(SpireInsertPatch.class);
                            locatorInfo = null;
                            if (insertPatch != null && !insertPatch.locator().equals(SpireInsertPatch.NONE.class)) {
                                locatorInfo = new LocatorInfo(ctMethodToPatch, loader.loadClass(insertPatch.locator().getName()));
                            }
                            if (!Patcher.isInsertPatchValid(insertPatch, locatorInfo)) {
                                throw new PatchingException(m, "SpireInsertPatch missing line number! Must specify either loc, rloc, locs, rlocs, or a Locator");
                            }
                            locs = new ArrayList<InsertPatchInfo.LineNumberAndPatchType>();
                            if (locatorInfo != null) {
                                abs_locs = locatorInfo.findLines();
                                if (abs_locs.length < 1) {
                                    throw new PatchingException(m, "Locator must locate at least 1 line!");
                                }
                                for (i = 0; i < abs_locs.length; ++i) {
                                    locs.add(new InsertPatchInfo.LineNumberAndPatchType(abs_locs[i]));
                                }
                            }
                            if (insertPatch != null) {
                                if (insertPatch.loc() >= 0) {
                                    locs.add(new InsertPatchInfo.LineNumberAndPatchType(insertPatch.loc()));
                                }
                                if (insertPatch.rloc() >= 0) {
                                    locs.add(new InsertPatchInfo.LineNumberAndPatchType(ctMethodToPatch.getMethodInfo().getLineNumber(0) + insertPatch.rloc(), insertPatch.rloc()));
                                }
                                for (i = 0; i < insertPatch.locs().length; ++i) {
                                    locs.add(new InsertPatchInfo.LineNumberAndPatchType(insertPatch.locs()[i]));
                                }
                                for (i = 0; i < insertPatch.rlocs().length; ++i) {
                                    locs.add(new InsertPatchInfo.LineNumberAndPatchType(ctMethodToPatch.getMethodInfo().getLineNumber(0) + insertPatch.rlocs()[i], insertPatch.rlocs()[i]));
                                }
                            }
                            p = new InsertPatchInfo(insertPatch, locs, ctMethodToPatch, m).setSpirePatch(patch);
                        } else if (m.getName().equals("Instrument") || m.hasAnnotation(SpireInstrumentPatch.class)) {
                            p = new InstrumentPatchInfo(ctMethodToPatch, Patcher.findInstrumentMethod(loader.loadClass(cls_name), m.getName())).setSpirePatch(patch);
                        } else if (m.getName().equals("Replace")) {
                            p = new ReplacePatchInfo(ctMethodToPatch, m).setSpirePatch(patch);
                        } else if (m.getName().equals("Raw") || m.hasAnnotation(SpireRawPatch.class)) {
                            p = new RawPatchInfo(ctMethodToPatch, Patcher.findRawMethod(loader.loadClass(cls_name), m.getName())).setSpirePatch(patch);
                        }
                    }
                    if (p == null) continue;
                    if (!Modifier.isPublic(m.getModifiers())) {
                        m.setModifiers(Modifier.setPublic(m.getModifiers()));
                    }
                    Patcher.patchInfos.add(p);
                }
            }
        }
    }

    private static boolean isInsertPatchValid(SpireInsertPatch insertPatch, LocatorInfo locatorInfo) {
        if (locatorInfo != null) {
            return true;
        }
        return insertPatch != null && (insertPatch.loc() != -1 || insertPatch.rloc() != -1 || insertPatch.locs().length != 0 || insertPatch.rlocs().length != 0);
    }

    private static CtClass[] patchParamTypes(ClassPool pool, SpirePatch patch) throws NotFoundException {
        Object[] def = new String[]{"DEFAULT"};
        if (Arrays.equals(patch.paramtypes(), def)) {
            return null;
        }
        return pool.get(patch.paramtypes());
    }

    private static CtClass[] patchParamTypez(ClassPool pool, SpirePatch patch) throws NotFoundException {
        if (patch.paramtypez().length == 1 && Void.TYPE.equals(patch.paramtypez()[0])) {
            return null;
        }
        String[] names = new String[patch.paramtypez().length];
        for (int i = 0; i < patch.paramtypez().length; ++i) {
            names[i] = patch.paramtypez()[i].getName();
        }
        return pool.get(names);
    }

    private static Method findInstrumentMethod(Class<?> cls, String name) throws NoSuchMethodException {
        for (Method m : cls.getDeclaredMethods()) {
            if (!m.getName().equals(name) || m.getParameterCount() != 0) continue;
            m.setAccessible(true);
            return m;
        }
        throw new NoSuchMethodException();
    }

    private static Method findRawMethod(Class<?> cls, String name) throws NoSuchMethodException {
        for (Method m : cls.getDeclaredMethods()) {
            if (!m.getName().equals(name) || m.getParameterCount() != 1) continue;
            m.setAccessible(true);
            return m;
        }
        throw new NoSuchMethodException();
    }

    private static String patchParamTypesString(SpirePatch patch) {
        if (patch.paramtypez().length == 1 && Void.TYPE.equals(patch.paramtypez()[0])) {
            Object[] def = new String[]{"DEFAULT"};
            if (Arrays.equals(patch.paramtypes(), def)) {
                return "";
            }
            return String.join((CharSequence)", ", patch.paramtypes());
        }
        CharSequence[] tmp = new String[patch.paramtypez().length];
        for (int i = 0; i < patch.paramtypez().length; ++i) {
            tmp[i] = patch.paramtypez()[i].getName();
        }
        return String.join((CharSequence)", ", tmp);
    }

    private static String patchClassName(SpirePatch patch) {
        if (patch.clz().equals(Void.TYPE)) {
            return patch.cls();
        }
        return patch.clz().getName();
    }

    static void patchOverrides(ClassLoader loader, ClassPool pool, ModInfo[] modInfos) throws PatchingException {
        System.out.println("Patching Overrides...");
        MyCodeConverter.reset();
        for (AnnotationDB db : annotationDBMap.values()) {
            Set<String> classNames = db.getAnnotationIndex().get(SpireOverride.class.getName());
            if (classNames == null) continue;
            for (String className : classNames) {
                if (Loader.DEBUG) {
                    System.out.println("Class: [" + className + "]");
                }
                try {
                    CtClass cc = pool.get(className);
                    for (final CtMethod ctMethod : cc.getDeclaredMethods()) {
                        if (!ctMethod.hasAnnotation(SpireOverride.class)) continue;
                        CtMethod superMethod = Patcher.findSuperMethod(ctMethod);
                        if (superMethod == null) {
                            throw new PatchingException(ctMethod, "Has no matching method signature in any superclass");
                        }
                        if (Loader.DEBUG) {
                            System.out.println(" - Overriding [" + superMethod.getLongName() + "]");
                            System.out.println("      Fixing invocations in superclass " + superMethod.getDeclaringClass().getSimpleName() + "...");
                        }
                        MyCodeConverter codeConverter = new MyCodeConverter();
                        codeConverter.redirectSpecialMethodCall(superMethod);
                        superMethod.getDeclaringClass().instrument(codeConverter);
                        if (Loader.DEBUG) {
                            System.out.println("      Replacing SpireSuper calls...");
                        }
                        ExprEditor exprEditor = new ExprEditor(){

                            @Override
                            public void edit(MethodCall m) throws CannotCompileException {
                                try {
                                    if (m.getClassName().equals(SpireSuper.class.getName())) {
                                        if (Loader.DEBUG) {
                                            System.out.println("        @ " + m.getLineNumber());
                                        }
                                        String src = " { ";
                                        if (!ctMethod.getReturnType().equals(CtClass.voidType)) {
                                            src = src + "$_ = ";
                                        }
                                        src = src + "super." + ctMethod.getName() + "(";
                                        for (int i = 0; i < ctMethod.getParameterTypes().length; ++i) {
                                            if (i > 0) {
                                                src = src + ", ";
                                            }
                                            src = src + Patcher.makeObjectCastedString(ctMethod.getParameterTypes()[i], "$1[" + i + "]");
                                        }
                                        src = src + ");\n";
                                        if (ctMethod.getReturnType().equals(CtClass.voidType)) {
                                            src = src + "$_ = null;";
                                        }
                                        src = src + " }";
                                        if (Loader.DEBUG) {
                                            System.out.println(src);
                                        }
                                        m.replace(src);
                                    }
                                }
                                catch (NotFoundException e) {
                                    throw new CannotCompileException(e);
                                }
                            }
                        };
                        ctMethod.instrument(exprEditor);
                    }
                }
                catch (CannotCompileException | NotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private static CtMethod findSuperMethod(CtMethod ctMethod) throws NotFoundException {
        for (CtClass superclass = ctMethod.getDeclaringClass().getSuperclass(); superclass != null; superclass = superclass.getSuperclass()) {
            try {
                CtMethod superMethod = superclass.getDeclaredMethod(ctMethod.getName(), ctMethod.getParameterTypes());
                if (!ctMethod.getReturnType().equals(superMethod.getReturnType())) continue;
                return superMethod;
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    private static String makeObjectCastedString(CtClass ctType, String value) {
        String typename = ctType.getName();
        String extra = "";
        if (ctType.isPrimitive()) {
            typename = ctType.equals(CtPrimitiveType.intType) ? "Integer" : (ctType.equals(CtPrimitiveType.charType) ? "Character" : typename.substring(0, 1).toUpperCase() + typename.substring(1));
            extra = "." + ctType.getName() + "Value()";
        }
        return "((" + typename + ") " + value + ")" + extra;
    }

    private static SpirePatch convertSpirePatch2To1(ClassLoader loader, ClassPool pool, SpirePatch2 patch2) {
        AnnotationImpl impl = (AnnotationImpl)Proxy.getInvocationHandler(patch2);
        Annotation a = impl.getAnnotation();
        return (SpirePatch)AnnotationImpl.make(loader, SpirePatch.class, pool, a);
    }

    private static /* synthetic */ boolean lambda$injectPatches$1(String modId, ModInfo x) {
        return modId.equals(x.ID);
    }

    private static /* synthetic */ SpirePatch lambda$injectPatches$0(ClassLoader loader, ClassPool pool, SpirePatch2 p2) {
        return Patcher.convertSpirePatch2To1(loader, pool, p2);
    }
}

