/*
 * Decompiled with CFR 0.152.
 */
package com.evacipated.cardcrawl.modthespire;

import com.evacipated.cardcrawl.modthespire.MTSClassLoader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.LoaderClassPath;

public class MTSClassPool
extends ClassPool {
    private ClassLoader classLoader;
    private List<ClassPath> classPaths = new ArrayList<ClassPath>();

    public MTSClassPool(MTSClassLoader classLoader) {
        this.appendSystemPath();
        this.resetClassLoader(classLoader);
    }

    public void resetClassLoader(MTSClassLoader loader) {
        this.classLoader = loader;
        for (ClassPath classPath : this.classPaths) {
            this.removeClassPath(classPath);
        }
        this.classPaths.clear();
        this.insertClassPath(new LoaderClassPath(loader));
        loader.addStreamToClassPool(this);
    }

    @Override
    public ClassPath insertClassPath(ClassPath cp) {
        this.classPaths.add(cp);
        return super.insertClassPath(cp);
    }

    @Override
    public ClassPath appendClassPath(ClassPath cp) {
        this.classPaths.add(cp);
        return super.appendClassPath(cp);
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setParent(ClassPool parent) {
        this.parent = parent;
    }

    public Set<CtClass> getModifiedClasses() {
        HashSet<CtClass> ret = new HashSet<CtClass>();
        for (Object v : this.classes.values()) {
            CtClass cls = (CtClass)v;
            if (!cls.isModified()) continue;
            ret.add(cls);
        }
        return ret;
    }
}

