/*
 * Decompiled with CFR 0.152.
 */
package com.evacipated.cardcrawl.modthespire;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.ProtectionDomain;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import javassist.ByteArrayClassPath;
import javassist.ClassPool;

public class MTSClassLoader
extends URLClassLoader {
    private ClassLoader parent;
    private Map<String, byte[]> classes = new HashMap<String, byte[]>();
    private Map<String, Class<?>> definedClasses = new HashMap();
    private Map<String, byte[]> resources = new HashMap<String, byte[]>();

    public MTSClassLoader(InputStream stream, URL[] urls, ClassLoader parent) throws IOException {
        super(urls, (ClassLoader)null);
        this.parent = parent;
        JarInputStream is = new JarInputStream(stream);
        JarEntry entry = is.getNextJarEntry();
        while (entry != null) {
            if (entry.getName().contains(".class")) {
                String className = entry.getName().replace(".class", "").replace('/', '.');
                byte[] classBytes = this.bufferStream(is);
                this.classes.put(className, classBytes);
            } else if (!entry.isDirectory()) {
                byte[] bytes = this.bufferStream(is);
                this.resources.put(entry.getName(), bytes);
            }
            entry = is.getNextJarEntry();
        }
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        if (this.resources.containsKey(name)) {
            return new ByteArrayInputStream(this.resources.get(name));
        }
        return super.getResourceAsStream(name);
    }

    private byte[] bufferStream(InputStream is) throws IOException {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        int nextValue = is.read();
        while (nextValue != -1) {
            byteStream.write(nextValue);
            nextValue = is.read();
        }
        return byteStream.toByteArray();
    }

    @Override
    public void addURL(URL url) {
        super.addURL(url);
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        if (name.startsWith("com.codedisaster.steamworks") || name.startsWith("com.google.gson") || name.equals("com.megacrit.cardcrawl.desktop.DesktopLauncher")) {
            Class<?> c = this.findLoadedClass(name);
            if (c == null && (c = this.findClass(name)) == null) {
                c = super.loadClass(name);
            }
            return c;
        }
        try {
            return this.parent.loadClass(name);
        }
        catch (ClassNotFoundException e) {
            return super.loadClass(name);
        }
    }

    @Override
    public Class<?> findClass(String name) throws ClassNotFoundException {
        Class<?> ret;
        block3: {
            try {
                ret = super.findClass(name);
            }
            catch (ClassNotFoundException e) {
                ret = this.definedClasses.get(name);
                if (ret != null) break block3;
                byte[] classBytes = this.classes.remove(name);
                if (classBytes == null) {
                    throw new ClassNotFoundException(name);
                }
                ret = this.defineClass(name, classBytes, 0, classBytes.length, (ProtectionDomain)null);
                this.definedClasses.put(name, ret);
            }
        }
        return ret;
    }

    public void addStreamToClassPool(ClassPool pool) {
        for (Map.Entry<String, byte[]> entry : this.classes.entrySet()) {
            pool.insertClassPath(new ByteArrayClassPath(entry.getKey(), entry.getValue()));
        }
    }
}

