/*
 * Decompiled with CFR 0.152.
 */
package com.evacipated.cardcrawl.modthespire;

import com.evacipated.cardcrawl.modthespire.Loader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.Arrays;

public class DownloadAndRestarter {
    public static final boolean DO_APPEND = false;

    private DownloadAndRestarter() {
    }

    private static String fileNameFromURL(URL url) {
        String uri = url.toString();
        return uri.substring(uri.lastIndexOf(47) + 1, uri.length());
    }

    private static void restartApplication() throws URISyntaxException, IOException {
        String javaBin = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
        File currentJar = new File(DownloadAndRestarter.class.getProtectionDomain().getCodeSource().getLocation().toURI());
        if (!currentJar.getName().endsWith(".jar")) {
            return;
        }
        ArrayList<String> command = new ArrayList<String>();
        command.add(javaBin);
        command.add("-jar");
        command.add(currentJar.getPath());
        command.addAll(Arrays.asList(Loader.ARGS));
        ProcessBuilder builder = new ProcessBuilder(command);
        builder.start();
        System.exit(0);
    }

    public static void downloadOne(URL download) throws IOException {
        ReadableByteChannel rbc = Channels.newChannel(download.openStream());
        String fileName = DownloadAndRestarter.fileNameFromURL(download);
        FileOutputStream fos = new FileOutputStream(Loader.MOD_DIR + fileName, false);
        fos.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
        fos.close();
    }

    public static void downloadAndRestart(URL[] downloads) throws IOException, URISyntaxException {
        for (URL download : downloads) {
            DownloadAndRestarter.downloadOne(download);
        }
        DownloadAndRestarter.restartApplication();
    }
}

