/*
 * Decompiled with CFR 0.152.
 */
package com.evacipated.cardcrawl.modthespire;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javassist.CannotCompileException;
import javassist.ClassPath;
import javassist.CtClass;
import javassist.NotFoundException;

public class ByteArrayMapClassPath
implements ClassPath {
    protected Map<String, Info> classes = new HashMap<String, Info>();

    public void addClass(CtClass ctClass) throws CannotCompileException {
        try {
            URL url = null;
            try {
                url = ctClass.getURL();
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
            this.classes.put(ctClass.getName(), new Info(url, ctClass.toBytecode()));
        }
        catch (IOException e) {
            throw new CannotCompileException(e);
        }
    }

    @Override
    public void close() {
    }

    @Override
    public InputStream openClassfile(String classname) {
        Info classInfo = this.classes.get(classname);
        if (classInfo != null) {
            return new ByteArrayInputStream(classInfo.classfile);
        }
        return null;
    }

    @Override
    public URL find(String classname) {
        if (this.classes.containsKey(classname)) {
            return this.classes.get((Object)classname).url;
        }
        return null;
    }

    public void printDebugInfo() {
        int bytes = 0;
        for (Info info : this.classes.values()) {
            bytes += info.classfile.length;
        }
        System.out.printf("%d modified classes (%dKB)%n", this.classes.size(), bytes /= 1024);
    }

    private static class Info {
        final URL url;
        final byte[] classfile;

        Info(URL url, byte[] classfile) {
            this.url = url;
            this.classfile = classfile;
        }
    }
}

