/*
 * Decompiled with CFR 0.152.
 */
package textTheSpire;

import ascensionMod.AscensionMod;
import ascensionMod.UI.AscModScreen;
import ascensionMod.UI.CharSelectScreenUI;
import ascensionMod.UI.buttons.AscToggleButton;
import basemod.CustomCharacterSelectScreen;
import basemod.ReflectionHacks;
import com.badlogic.gdx.Gdx;
import com.megacrit.cardcrawl.cards.AbstractCard;
import com.megacrit.cardcrawl.cards.CardGroup;
import com.megacrit.cardcrawl.characters.AbstractPlayer;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.daily.DailyScreen;
import com.megacrit.cardcrawl.daily.TimeHelper;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.events.GenericEventDialog;
import com.megacrit.cardcrawl.events.shrines.GremlinMatchGame;
import com.megacrit.cardcrawl.events.shrines.GremlinWheelGame;
import com.megacrit.cardcrawl.helpers.SaveHelper;
import com.megacrit.cardcrawl.helpers.SeedHelper;
import com.megacrit.cardcrawl.helpers.TipTracker;
import com.megacrit.cardcrawl.integrations.DistributorFactory;
import com.megacrit.cardcrawl.map.MapRoomNode;
import com.megacrit.cardcrawl.metrics.Metrics;
import com.megacrit.cardcrawl.mod.replay.monsters.replay.FadingForestBoss;
import com.megacrit.cardcrawl.rewards.RewardItem;
import com.megacrit.cardcrawl.rooms.AbstractRoom;
import com.megacrit.cardcrawl.screens.charSelect.CharacterOption;
import com.megacrit.cardcrawl.screens.charSelect.CharacterSelectScreen;
import com.megacrit.cardcrawl.screens.leaderboards.FilterButton;
import com.megacrit.cardcrawl.screens.leaderboards.LeaderboardEntry;
import com.megacrit.cardcrawl.screens.mainMenu.MainMenuScreen;
import com.megacrit.cardcrawl.screens.mainMenu.MenuButton;
import com.megacrit.cardcrawl.screens.mainMenu.MenuPanelScreen;
import com.megacrit.cardcrawl.screens.mainMenu.SaveSlot;
import com.megacrit.cardcrawl.screens.mainMenu.SaveSlotScreen;
import com.megacrit.cardcrawl.screens.runHistory.RunHistoryScreen;
import com.megacrit.cardcrawl.screens.stats.BattleStats;
import com.megacrit.cardcrawl.screens.stats.BossRelicChoiceStats;
import com.megacrit.cardcrawl.screens.stats.CampfireChoice;
import com.megacrit.cardcrawl.screens.stats.CardChoiceStats;
import com.megacrit.cardcrawl.screens.stats.EventStats;
import com.megacrit.cardcrawl.screens.stats.ObtainStats;
import com.megacrit.cardcrawl.screens.stats.RunData;
import com.megacrit.cardcrawl.screens.stats.StatsScreen;
import com.megacrit.cardcrawl.shop.ShopScreen;
import com.megacrit.cardcrawl.shop.StorePotion;
import com.megacrit.cardcrawl.shop.StoreRelic;
import com.megacrit.cardcrawl.ui.buttons.LargeDialogOptionButton;
import com.megacrit.cardcrawl.ui.panels.SeedPanel;
import communicationmod.ChoiceScreenUtils;
import communicationmod.CommandExecutor;
import communicationmod.patches.GremlinMatchGamePatch;
import conspire.events.MimicChestEvent;
import downfall.patches.EvilModeCharacterSelect;
import downfall.patches.MainMenuEvilMode;
import downfall.rooms.HeartShopRoom;
import downfall.util.RemoveCardReward;
import downfall.util.TransformCardReward;
import downfall.util.UpgradeCardReward;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import org.eclipse.swt.widgets.Display;
import replayTheSpire.patches.ReplayShopInitCardsPatch;
import shopmod.relics.MerchantsRug;
import textTheSpire.AbstractWindow;
import textTheSpire.Inspect;
import textTheSpire.Map;
import textTheSpire.TextTheSpire;
import textTheSpire.Window;

public class Choices
extends AbstractWindow {
    boolean disableTips = false;
    HistoryScreen screen = HistoryScreen.NONE;
    RunData inspectRun;
    String savedFilter = "";
    SimpleDateFormat dateFormat;
    boolean setFormat = false;
    public static int doubleIndex;
    public boolean includeGold;
    public boolean includeHealth;
    public boolean includeCard;
    public boolean includeRelics;
    public boolean includePotions;
    public boolean includePurges;
    public boolean includePurchases;
    public boolean includeEvents;
    public boolean includeBattles;
    public boolean includeCampfire;
    public boolean includeBosses;

    public Choices(Display display) {
        this.isVisible = true;
        this.window = new Window(display, "Choices", 300, 400);
        doubleIndex = -1;
        this.includeGold = true;
        this.includeHealth = true;
        this.includeCard = true;
        this.includeRelics = true;
        this.includePotions = true;
        this.includePurges = true;
        this.includePurchases = true;
        this.includeEvents = true;
        this.includeBattles = true;
        this.includeCampfire = true;
        this.includeBosses = true;
    }

    @Override
    public String getText() {
        if (this.window.shell.isDisposed()) {
            Display.getDefault().dispose();
            Gdx.app.exit();
        }
        doubleIndex = -1;
        if (!this.setFormat && CardCrawlGame.mainMenuScreen != null && CardCrawlGame.mainMenuScreen.runHistoryScreen != null) {
            this.dateFormat = Settings.language == Settings.GameLanguage.JPN ? new SimpleDateFormat(RunHistoryScreen.TEXT[34], Locale.JAPAN) : new SimpleDateFormat(RunHistoryScreen.TEXT[34]);
            this.setFormat = true;
        }
        StringBuilder s = new StringBuilder();
        s.append("\r\n");
        if (this.screen != HistoryScreen.NONE) {
            switch (this.screen) {
                case MAIN: {
                    s.append("Run History\r\nMost commands are disabled when viewing run history.\r\n");
                    s.append("Total runs: ").append(TextTheSpire.runList.size()).append("\r\n");
                    s.append("Filters:\r\n");
                    s.append("1. Wins ").append(TextTheSpire.include_win).append("\r\n");
                    s.append("2. Loses ").append(TextTheSpire.include_lose).append("\r\n");
                    s.append("3. Ironclad ").append(TextTheSpire.include_iron).append("\r\n");
                    s.append("4. Silent ").append(TextTheSpire.include_silent).append("\r\n");
                    s.append("5. Defect ").append(TextTheSpire.include_defect).append("\r\n");
                    s.append("6. Watcher ").append(TextTheSpire.include_watch).append("\r\n");
                    s.append("7. Normal Runs ").append(TextTheSpire.include_normal).append("\r\n");
                    s.append("8. Ascension ").append(TextTheSpire.include_asc).append("\r\n");
                    s.append("9. Daily ").append(TextTheSpire.include_daily).append("\r\n");
                    s.append("Input a single number to toggle a filter.\r\n");
                    s.append("Input view to view list of runs.\r\n");
                    s.append("At any point input close to exit Run History and return to main menu.\r\n");
                    break;
                }
                case LIST: {
                    if (!this.savedFilter.isEmpty()) {
                        return this.savedFilter;
                    }
                    s.append("back\r\nFiltered runs: ").append(TextTheSpire.runFiltered.size()).append("\r\n");
                    s.append("Run are displayed with date followed by score.\r\n");
                    s.append("Inspect a run with its index.\r\n");
                    s.append("Runs:\r\n");
                    for (int i = 0; i < TextTheSpire.runFiltered.size(); ++i) {
                        String dateTimeStr;
                        RunData run = TextTheSpire.runFiltered.get(i);
                        if (run.local_time != null) {
                            try {
                                dateTimeStr = this.dateFormat.format(Metrics.timestampFormatter.parse(run.local_time));
                            }
                            catch (Exception ignored) {
                                dateTimeStr = "date error";
                            }
                        } else {
                            dateTimeStr = this.dateFormat.format(Long.parseLong(run.timestamp) * 1000L);
                        }
                        s.append(i).append(". ").append(dateTimeStr).append(", ").append(run.score).append("\r\n");
                    }
                    this.savedFilter = s.toString();
                    break;
                }
                case INSPECT: {
                    String dateTimeStr;
                    if (this.inspectRun.local_time != null) {
                        try {
                            dateTimeStr = this.dateFormat.format(Metrics.timestampFormatter.parse(this.inspectRun.local_time));
                        }
                        catch (Exception ignored) {
                            dateTimeStr = "date error";
                        }
                    } else {
                        dateTimeStr = this.dateFormat.format(Long.parseLong(this.inspectRun.timestamp) * 1000L);
                    }
                    s.append(dateTimeStr).append("\r\n").append("Score: ").append(this.inspectRun.score).append("\r\n");
                    s.append(this.inspectRun.character_chosen).append("\r\n");
                    s.append("Seed: ").append(SeedHelper.getString((long)Long.parseLong(this.inspectRun.seed_played))).append("\r\n");
                    if (this.inspectRun.is_daily) {
                        s.append("Daily Mods:\r\n");
                        for (String mod : this.inspectRun.daily_mods) {
                            s.append(mod).append("\r\n");
                        }
                    }
                    if (this.inspectRun.is_ascension_mode) {
                        s.append("Ascension: ").append(this.inspectRun.ascension_level).append("\r\n");
                    }
                    s.append("Victory: ").append(this.inspectRun.victory).append("\r\n");
                    if (this.inspectRun.victory) {
                        s.append("Time: ").append(this.inspectRun.playtime / 3600).append("hr ").append(this.inspectRun.playtime / 60).append("min ").append(this.inspectRun.playtime % 60).append("sec\r\n");
                    } else {
                        s.append("Killed by: ").append(this.inspectRun.killed_by).append("\r\n");
                    }
                    s.append("Floor Reached: ").append(this.inspectRun.floor_reached).append("\r\n");
                    s.append("Neow Bonus: ").append(this.inspectRun.neow_bonus).append("\r\n");
                    s.append("Neow Cost: ").append(this.inspectRun.neow_cost).append("\r\n");
                    s.append("Options:\r\n");
                    s.append("1. Master Deck\r\n");
                    s.append("2. Relics\r\n");
                    s.append("3. Path\r\n");
                    s.append("Path Options:\r\n");
                    s.append("4. Gold per turn ").append(this.includeGold).append("\r\n");
                    s.append("5. Health per turn ").append(this.includeHealth).append("\r\n");
                    s.append("6. Card Choices ").append(this.includeCard).append("\r\n");
                    s.append("7. Relics Obtained ").append(this.includeRelics).append("\r\n");
                    s.append("8. Potions Obtained ").append(this.includePotions).append("\r\n");
                    s.append("9. Items Purchased ").append(this.includePurchases).append("\r\n");
                    s.append("10. Cards Purged ").append(this.includePurges).append("\r\n");
                    s.append("11. Events ").append(this.includeEvents).append("\r\n");
                    s.append("12. Battle Details ").append(this.includeBattles).append("\r\n");
                    s.append("13. Campfire Choices ").append(this.includeCampfire).append("\r\n");
                    s.append("14. Boss Relic Choices").append(this.includeBosses).append("\r\n");
                    break;
                }
                case DECK: {
                    s.append("back\r\nMaster Deck\r\n");
                    for (String card : this.inspectRun.master_deck) {
                        s.append(card).append("\r\n");
                    }
                    break;
                }
                case RELIC: {
                    s.append("back\r\nRelics\r\n");
                    for (String relic : this.inspectRun.relics) {
                        s.append(relic).append("\r\n");
                    }
                    break;
                }
                case PATH: {
                    int i;
                    int i2;
                    int i3;
                    ArrayList<Floor> every = new ArrayList<Floor>();
                    for (i3 = 0; i3 < this.inspectRun.gold_per_floor.size(); ++i3) {
                        Floor newFloor = new Floor();
                        newFloor.gold = (Integer)this.inspectRun.gold_per_floor.get(i3);
                        newFloor.currentHP = (Integer)this.inspectRun.current_hp_per_floor.get(i3);
                        newFloor.maxHP = (Integer)this.inspectRun.max_hp_per_floor.get(i3);
                        newFloor.type = (String)this.inspectRun.path_per_floor.get(i3);
                        newFloor.relics = new ArrayList();
                        newFloor.potions = new ArrayList();
                        newFloor.cardChoices = new ArrayList();
                        newFloor.purchases = new ArrayList();
                        newFloor.purges = new ArrayList();
                        every.add(newFloor);
                    }
                    for (i3 = 0; i3 < this.inspectRun.path_taken.size(); ++i3) {
                        ((Floor)every.get((int)(i3 + i3 / 16))).wasUnknown = ((String)this.inspectRun.path_taken.get(i3)).equals("?");
                    }
                    for (ObtainStats p : this.inspectRun.relics_obtained) {
                        ((Floor)every.get((int)(p.floor - 1))).relics.add(p.key);
                    }
                    for (ObtainStats p : this.inspectRun.potions_obtained) {
                        ((Floor)every.get((int)(p.floor - 1))).potions.add(p.key);
                    }
                    for (i2 = 0; i2 < this.inspectRun.items_purged_floors.size(); ++i2) {
                        ((Floor)every.get((int)(((Integer)this.inspectRun.items_purged_floors.get((int)i2)).intValue() - 1))).purges.add((String)this.inspectRun.items_purged.get(i2));
                    }
                    for (i2 = 0; i2 < this.inspectRun.item_purchase_floors.size(); ++i2) {
                        ((Floor)every.get((int)(((Integer)this.inspectRun.item_purchase_floors.get((int)i2)).intValue() - 1))).purchases.add((String)this.inspectRun.items_purchased.get(i2));
                    }
                    for (Object c : this.inspectRun.card_choices) {
                        ((Floor)every.get((int)(((CardChoiceStats)c).floor - 1))).cardChoices.add((CardChoiceStats)c);
                    }
                    Iterator i4 = this.inspectRun.damage_taken.iterator();
                    while (i4.hasNext()) {
                        BattleStats b;
                        ((Floor)every.get((int)(b.floor - 1))).battle = b = (BattleStats)i4.next();
                    }
                    i4 = this.inspectRun.event_choices.iterator();
                    while (i4.hasNext()) {
                        EventStats e;
                        ((Floor)every.get((int)(e.floor - 1))).event = e = (EventStats)i4.next();
                    }
                    for (Object c : this.inspectRun.campfire_choices) {
                        ((Floor)every.get((int)(((CampfireChoice)c).floor - 1))).campfire = c;
                    }
                    for (i = 0; i < this.inspectRun.boss_relics.size(); ++i) {
                        ((Floor)every.get((int)((i + 1) * 17 - 1))).boss = (BossRelicChoiceStats)this.inspectRun.boss_relics.get(i);
                    }
                    s.append("back\r\nPath\r\n");
                    for (i = 0; i < every.size(); ++i) {
                        s.append("Floor: ").append(i + 1).append("\r\n");
                        if (!((Floor)every.get((int)i)).wasUnknown) {
                            s.append("Type: ").append(Choices.mapType(((Floor)every.get((int)i)).type));
                        } else {
                            s.append("Type: Unknown to ").append(Choices.mapType(((Floor)every.get((int)i)).type));
                        }
                        if (((Floor)every.get((int)i)).battle != null) {
                            s.append(": ").append(((Floor)every.get((int)i)).battle.enemies);
                        }
                        s.append("\r\n");
                        if (this.includeHealth) {
                            s.append("Health: ").append(((Floor)every.get((int)i)).currentHP).append("/").append(((Floor)every.get((int)i)).maxHP).append("\r\n");
                        }
                        if (this.includeGold) {
                            s.append("Gold: ").append(((Floor)every.get((int)i)).gold).append("\r\n");
                        }
                        if (((Floor)every.get((int)i)).battle != null && this.includeBattles) {
                            s.append("Damage: ").append(((Floor)every.get((int)i)).battle.damage);
                            s.append(", Turns: ").append(((Floor)every.get((int)i)).battle.turns).append("\r\n");
                        }
                        if (((Floor)every.get((int)i)).event != null && this.includeEvents) {
                            s.append(((Floor)every.get((int)i)).event.event_name).append("\r\n");
                            if (!((Floor)every.get((int)i)).event.player_choice.isEmpty()) {
                                s.append("Choice: ").append(((Floor)every.get((int)i)).event.player_choice).append("\r\n");
                            }
                            if (((Floor)every.get((int)i)).event.cards_obtained != null && ((Floor)every.get((int)i)).event.cards_obtained.size() > 0) {
                                s.append("Cards Obtained: ");
                                for (String obt : ((Floor)every.get((int)i)).event.cards_obtained) {
                                    s.append(obt).append(", ");
                                }
                                s.append("\r\n");
                            }
                            if (((Floor)every.get((int)i)).event.cards_removed != null && ((Floor)every.get((int)i)).event.cards_removed.size() > 0) {
                                s.append("Cards Removed: ");
                                for (String obt : ((Floor)every.get((int)i)).event.cards_removed) {
                                    s.append(obt).append(", ");
                                }
                                s.append("\r\n");
                            }
                            if (((Floor)every.get((int)i)).event.cards_transformed != null && ((Floor)every.get((int)i)).event.cards_transformed.size() > 0) {
                                s.append("Cards Transformed: ");
                                for (String obt : ((Floor)every.get((int)i)).event.cards_transformed) {
                                    s.append(obt).append(", ");
                                }
                                s.append("\r\n");
                            }
                            if (((Floor)every.get((int)i)).event.cards_upgraded != null && ((Floor)every.get((int)i)).event.cards_upgraded.size() > 0) {
                                s.append("Cards Upgraded: ");
                                for (String obt : ((Floor)every.get((int)i)).event.cards_upgraded) {
                                    s.append(obt).append(", ");
                                }
                                s.append("\r\n");
                            }
                            if (((Floor)every.get((int)i)).event.relics_obtained != null && ((Floor)every.get((int)i)).event.relics_obtained.size() > 0) {
                                s.append("Relics Obtained: ");
                                for (String obt : ((Floor)every.get((int)i)).event.relics_obtained) {
                                    s.append(obt).append(", ");
                                }
                                s.append("\r\n");
                            }
                            if (((Floor)every.get((int)i)).event.relics_lost != null && ((Floor)every.get((int)i)).event.relics_lost.size() > 0) {
                                s.append("Relics Lost: ");
                                for (String obt : ((Floor)every.get((int)i)).event.relics_lost) {
                                    s.append(obt).append(", ");
                                }
                                s.append("\r\n");
                            }
                            if (((Floor)every.get((int)i)).event.potions_obtained != null && ((Floor)every.get((int)i)).event.potions_obtained.size() > 0) {
                                s.append("Potions Obtained: ");
                                for (String obt : ((Floor)every.get((int)i)).event.potions_obtained) {
                                    s.append(obt).append(", ");
                                }
                                s.append("\r\n");
                            }
                            if (((Floor)every.get((int)i)).event.damage_taken > 0) {
                                s.append("Damaged Taken: ").append(((Floor)every.get((int)i)).event.damage_taken).append("\r\n");
                            }
                            if (((Floor)every.get((int)i)).event.damage_healed > 0) {
                                s.append("Damaged Healed: ").append(((Floor)every.get((int)i)).event.damage_healed).append("\r\n");
                            }
                            if (((Floor)every.get((int)i)).event.max_hp_loss > 0) {
                                s.append("Max HP Loss: ").append(((Floor)every.get((int)i)).event.max_hp_loss).append("\r\n");
                            }
                            if (((Floor)every.get((int)i)).event.max_hp_gain > 0) {
                                s.append("Max HP Gain: ").append(((Floor)every.get((int)i)).event.max_hp_gain).append("\r\n");
                            }
                            if (((Floor)every.get((int)i)).event.gold_gain > 0) {
                                s.append("Gold Gain: ").append(((Floor)every.get((int)i)).event.gold_gain).append("\r\n");
                            }
                            if (((Floor)every.get((int)i)).event.gold_loss > 0) {
                                s.append("Gold Loss: ").append(((Floor)every.get((int)i)).event.gold_loss).append("\r\n");
                            }
                        }
                        if (((Floor)every.get((int)i)).campfire != null && this.includeCampfire) {
                            s.append("Campfire: ").append(((Floor)every.get((int)i)).campfire.key);
                            if (((Floor)every.get((int)i)).campfire.data != null) {
                                s.append(": ").append(((Floor)every.get((int)i)).campfire.data);
                            }
                            s.append("\r\n");
                        }
                        if (((Floor)every.get((int)i)).boss != null && this.includeBosses) {
                            s.append("Picked: ").append(((Floor)every.get((int)i)).boss.picked).append("\r\n");
                            s.append("Rejected: ");
                            for (String rej : ((Floor)every.get((int)i)).boss.not_picked) {
                                s.append(rej).append(", ");
                            }
                            s.append("\r\n");
                        }
                        if (((Floor)every.get((int)i)).purchases.size() > 0 && this.includePurchases) {
                            s.append("Purchases: ");
                            for (String p : ((Floor)every.get((int)i)).purchases) {
                                s.append(p).append(", ");
                            }
                            s.append("\r\n");
                        }
                        if (((Floor)every.get((int)i)).purges.size() > 0 && this.includePurges) {
                            s.append("Purges: ");
                            for (String p : ((Floor)every.get((int)i)).purges) {
                                s.append(p).append(", ");
                            }
                            s.append("\r\n");
                        }
                        if (((Floor)every.get((int)i)).cardChoices.size() > 0 && this.includeCard) {
                            s.append("Card Choices\r\n");
                            for (CardChoiceStats c : ((Floor)every.get((int)i)).cardChoices) {
                                s.append("Picked: ").append(c.picked).append("\r\n");
                                s.append("Rejected: ");
                                for (String rej : c.not_picked) {
                                    s.append(rej).append(", ");
                                }
                                s.append("\r\n");
                            }
                        }
                        if (((Floor)every.get((int)i)).relics.size() > 0 && this.includeRelics) {
                            s.append("Relics Obtained: ");
                            for (String p : ((Floor)every.get((int)i)).relics) {
                                s.append(p).append(", ");
                            }
                            s.append("\r\n");
                        }
                        if (((Floor)every.get((int)i)).potions.size() <= 0 || !this.includePotions) continue;
                        s.append("Potions Obtained: ");
                        for (String p : ((Floor)every.get((int)i)).potions) {
                            s.append(p).append(", ");
                        }
                        s.append("\r\n");
                    }
                    break;
                }
            }
            return s.toString();
        }
        if (CommandExecutor.isInDungeon()) {
            ChoiceScreenUtils.ChoiceType currChoice = ChoiceScreenUtils.getCurrentChoiceType();
            if (TextTheSpire.downfall && EvilModeCharacterSelect.evilMode && AbstractDungeon.getCurrRoom() instanceof HeartShopRoom && ChoiceScreenUtils.getCurrentChoiceType() == ChoiceScreenUtils.ChoiceType.SHOP_ROOM && AbstractDungeon.getCurrRoom().phase == AbstractRoom.RoomPhase.COMBAT) {
                return "";
            }
            if (currChoice == ChoiceScreenUtils.ChoiceType.HAND_SELECT) {
                s.append("Hand Selection\r\n");
                s.append(AbstractDungeon.handCardSelectScreen.selectionReason + "\r\n");
                s.append("Select " + AbstractDungeon.handCardSelectScreen.numCardsToSelect + "\r\n");
                s.append("Number Selected: " + AbstractDungeon.handCardSelectScreen.numSelected + "\r\n");
            } else if (currChoice == ChoiceScreenUtils.ChoiceType.GRID) {
                s.append("Grid Selection\r\n");
                s.append("Number Selected: " + AbstractDungeon.gridSelectScreen.selectedCards.size() + "\r\n");
                if (AbstractDungeon.gridSelectScreen.forUpgrade && AbstractDungeon.gridSelectScreen.upgradePreviewCard != null) {
                    AbstractCard preview = AbstractDungeon.gridSelectScreen.upgradePreviewCard;
                    s.append("Upgrade Preview : " + TextTheSpire.inspectCard(preview));
                }
            }
            if (AbstractDungeon.getCurrRoom().phase == AbstractRoom.RoomPhase.COMBAT) {
                ArrayList cards;
                boolean show;
                if (ChoiceScreenUtils.isConfirmButtonAvailable()) {
                    s.append(ChoiceScreenUtils.getConfirmButtonText()).append("\r\n");
                }
                if (ChoiceScreenUtils.isCancelButtonAvailable()) {
                    s.append(ChoiceScreenUtils.getCancelButtonText()).append("\r\n");
                }
                int count = 1;
                if (TextTheSpire.replayTheSpire && AbstractDungeon.getCurrRoom().monsters.monsters.get(AbstractDungeon.getCurrRoom().monsters.monsters.size() - 1) instanceof FadingForestBoss && (show = ((Boolean)ReflectionHacks.getPrivateStatic(GenericEventDialog.class, (String)"show")).booleanValue())) {
                    String name = (String)ReflectionHacks.getPrivate((Object)((FadingForestBoss)AbstractDungeon.getCurrRoom().monsters.monsters.get((int)(AbstractDungeon.getCurrRoom().monsters.monsters.size() - 1))).imageEventText, GenericEventDialog.class, (String)"title");
                    s.append(name).append("\r\n");
                    ArrayList buttons = ((FadingForestBoss)AbstractDungeon.getCurrRoom().monsters.monsters.get((int)(AbstractDungeon.getCurrRoom().monsters.monsters.size() - 1))).imageEventText.optionList;
                    ArrayList<LargeDialogOptionButton> activeButtons = new ArrayList<LargeDialogOptionButton>();
                    for (LargeDialogOptionButton b : buttons) {
                        if (b.isDisabled) continue;
                        activeButtons.add(b);
                    }
                    if (activeButtons.size() > 0) {
                        for (LargeDialogOptionButton button : activeButtons) {
                            s.append(count).append(": ").append(Choices.stripColor(button.msg).toLowerCase()).append("\r\n");
                            ++count;
                        }
                        return s.toString();
                    }
                }
                if ((cards = ChoiceScreenUtils.getCurrentChoiceList()).size() == 0) {
                    return s.toString();
                }
                for (String c : cards) {
                    s.append(count).append(":").append(c).append("\r\n");
                    ++count;
                }
                return s.toString();
            }
            int count = 1;
            if (ChoiceScreenUtils.isConfirmButtonAvailable()) {
                s.append(ChoiceScreenUtils.getConfirmButtonText()).append("\r\n");
            }
            if (ChoiceScreenUtils.isCancelButtonAvailable()) {
                s.append(ChoiceScreenUtils.getCancelButtonText()).append("\r\n");
            }
            if (ChoiceScreenUtils.getCurrentChoiceType() == ChoiceScreenUtils.ChoiceType.EVENT) {
                if (TextTheSpire.conspire && AbstractDungeon.getCurrRoom().event instanceof MimicChestEvent) {
                    s.append("\r\nproceed\r\n1:open\r\n");
                    return s.toString();
                }
                s.append(AbstractDungeon.getCurrRoom().event.getClass().getSimpleName()).append("\r\n");
                ArrayList activeButtons = ChoiceScreenUtils.getActiveEventButtons();
                if (activeButtons.size() > 0) {
                    for (LargeDialogOptionButton button : activeButtons) {
                        s.append(count).append(": ").append(Choices.stripColor(button.msg).toLowerCase()).append("\r\n");
                        ++count;
                    }
                } else if (AbstractDungeon.getCurrRoom().event instanceof GremlinWheelGame) {
                    s.append(count).append(": ").append("spin").append("\r\n");
                } else if (AbstractDungeon.getCurrRoom().event instanceof GremlinMatchGame) {
                    GremlinMatchGame event = (GremlinMatchGame)AbstractDungeon.getCurrRoom().event;
                    CardGroup gameCardGroup = (CardGroup)ReflectionHacks.getPrivate((Object)event, GremlinMatchGame.class, (String)"cards");
                    for (AbstractCard c : gameCardGroup.group) {
                        if (!c.isFlipped) continue;
                        s.append(count).append(": ").append(String.format("card%d", GremlinMatchGamePatch.cardPositions.get(c.uuid))).append("\r\n");
                        ++count;
                    }
                }
            } else if (ChoiceScreenUtils.getCurrentChoiceType() == ChoiceScreenUtils.ChoiceType.SHOP_SCREEN) {
                for (String c : Choices.priceShopScreenChoices()) {
                    s.append(count).append(":").append(c).append("\r\n");
                    ++count;
                }
                if (TextTheSpire.shopMod && MerchantsRug.forSale && AbstractDungeon.player.gold >= MerchantsRug.price) {
                    s.append("rug:MerchantsRug.price");
                }
            } else if (ChoiceScreenUtils.getCurrentChoiceType() == ChoiceScreenUtils.ChoiceType.MAP) {
                if (AbstractDungeon.firstRoomChosen) {
                    s.append("Floor:").append(AbstractDungeon.currMapNode.y + 1).append(", X:").append(AbstractDungeon.currMapNode.x).append("\r\n");
                } else if (TextTheSpire.downfall && EvilModeCharacterSelect.evilMode) {
                    s.append("Floor 16\r\n");
                } else {
                    s.append("Floor:0\r\n");
                }
                ArrayList<MapRoomNode> choices = TextTheSpire.downfall && EvilModeCharacterSelect.evilMode ? Map.getMapScreenNodeChoices() : ChoiceScreenUtils.getMapScreenNodeChoices();
                if (ChoiceScreenUtils.bossNodeAvailable() && !TextTheSpire.downfall || TextTheSpire.downfall && AbstractDungeon.getCurrMapNode().y == 0) {
                    s.append(count).append(":");
                    s.append("boss").append("\r\n");
                } else if (!Inspect.has_inspected) {
                    for (MapRoomNode n : choices) {
                        s.append(count).append(":");
                        if (AbstractDungeon.player.hasRelic("WingedGreaves") && AbstractDungeon.player.getRelic((String)"WingedGreaves").counter > 0 && !AbstractDungeon.getCurrMapNode().isConnectedTo(n)) {
                            s.append(Map.nodeType(n)).append("Winged ").append(n.x).append("\r\n");
                        } else {
                            s.append(Map.nodeType(n)).append(n.x).append("\r\n");
                        }
                        ++count;
                    }
                } else {
                    s.append("Inspected ").append(Map.nodeType(Inspect.destination)).append(Inspect.destination.y + 1).append(" ").append(Inspect.destination.x).append("\r\n");
                    for (MapRoomNode n : choices) {
                        s.append(count).append(":");
                        s.append(Map.nodeType(n));
                        if (Inspect.inspected_map.contains(n)) {
                            s.append("On Track ").append(n.x).append("\r\n");
                        } else if (AbstractDungeon.player.hasRelic("WingedGreaves") && AbstractDungeon.player.getRelic((String)"WingedGreaves").counter > 0 && !AbstractDungeon.getCurrMapNode().isConnectedTo(n)) {
                            s.append("Winged ").append(n.x).append("\r\n");
                        } else {
                            s.append("Diverge ").append(n.x).append("\r\n");
                        }
                        ++count;
                    }
                }
            } else if (ChoiceScreenUtils.getCurrentChoiceType() == ChoiceScreenUtils.ChoiceType.COMBAT_REWARD) {
                for (RewardItem reward : AbstractDungeon.combatRewardScreen.rewards) {
                    if (TextTheSpire.downfall) {
                        if (reward instanceof RemoveCardReward) {
                            s.append(count).append(":").append("remove\r\n");
                            ++count;
                            continue;
                        }
                        if (reward instanceof UpgradeCardReward) {
                            s.append(count).append(":").append("upgrade\r\n");
                            ++count;
                            continue;
                        }
                        if (reward instanceof TransformCardReward) {
                            s.append(count).append(":").append("transform\r\n");
                            ++count;
                            continue;
                        }
                    }
                    if (reward.type == RewardItem.RewardType.POTION) {
                        s.append(count).append(":").append(reward.potion.name).append("\r\n");
                    } else if (reward.type == RewardItem.RewardType.RELIC) {
                        s.append(count).append(":").append(reward.relic.name).append("\r\n");
                    } else {
                        s.append(count).append(":").append(reward.type.name().toLowerCase()).append("\r\n");
                    }
                    ++count;
                }
            } else {
                for (String c : ChoiceScreenUtils.getCurrentChoiceList()) {
                    s.append(count).append(":").append(c).append("\r\n");
                    ++count;
                }
            }
            return s.toString();
        }
        if (CardCrawlGame.mainMenuScreen != null && CardCrawlGame.mainMenuScreen.screen == MainMenuScreen.CurScreen.MAIN_MENU) {
            if (!this.disableTips) {
                TipTracker.disableAllFtues();
                this.disableTips = true;
            }
            s.append("Text The Spire v1.22\r\ntts : patch notes\r\n");
            s.append("Slot ").append(CardCrawlGame.saveSlot).append(" ").append(CardCrawlGame.playerName).append("\r\n");
            for (AbstractPlayer.PlayerClass p : AbstractPlayer.PlayerClass.values()) {
                s.append(p.name().toLowerCase()).append(" ");
                if (TextTheSpire.characterUnlocked(p.name().toLowerCase())) {
                    s.append(TextTheSpire.ascensionLevel(p)).append("\r\n");
                    continue;
                }
                s.append("locked\r\n");
            }
            s.append("Commands\r\n");
            if (((MenuButton)CardCrawlGame.mainMenuScreen.buttons.get((int)(CardCrawlGame.mainMenuScreen.buttons.size() - 2))).result == MenuButton.ClickResult.ABANDON_RUN) {
                s.append("abandon\r\n");
                s.append("continue\r\n");
            } else {
                s.append("play\r\n");
                if (DistributorFactory.isLeaderboardEnabled()) {
                    s.append("leader\r\n");
                }
            }
            s.append("history\r\nslot\r\npatch\r\nquit");
        } else if (CardCrawlGame.mainMenuScreen != null && CardCrawlGame.mainMenuScreen.screen == MainMenuScreen.CurScreen.PANEL_MENU) {
            MenuPanelScreen.PanelScreen ps = (MenuPanelScreen.PanelScreen)ReflectionHacks.getPrivate((Object)CardCrawlGame.mainMenuScreen.panelScreen, MenuPanelScreen.class, (String)"screen");
            if (TextTheSpire.downfall && ps == MainMenuEvilMode.Enums.EVIL) {
                s.append("standard\r\ndownfall\r\n");
            } else {
                s.append("standard\r\n");
                if (CardCrawlGame.mainMenuScreen.statsScreen.statScreenUnlocked()) {
                    s.append("daily\r\n");
                }
                if (StatsScreen.all.highestDaily > 0) {
                    s.append("custom\r\n");
                }
                s.append("back\r\n");
            }
        } else if (CardCrawlGame.mainMenuScreen != null && CardCrawlGame.mainMenuScreen.screen == MainMenuScreen.CurScreen.CHAR_SELECT) {
            if (CardCrawlGame.mainMenuScreen.charSelectScreen instanceof CustomCharacterSelectScreen) {
                ArrayList allOptions = (ArrayList)ReflectionHacks.getPrivate((Object)CardCrawlGame.mainMenuScreen.charSelectScreen, CustomCharacterSelectScreen.class, (String)"allOptions");
                if (CardCrawlGame.mainMenuScreen.charSelectScreen.options.size() != allOptions.size()) {
                    CardCrawlGame.mainMenuScreen.charSelectScreen.options = allOptions;
                }
            }
            s.append("Input character name to select.\r\nasc to toggle ascension.\r\nasc [number] to set ascension level.\r\nIf that fails you can use + and - to manually change ascension level.\r\n");
            s.append("back\r\n");
            ArrayList options = CardCrawlGame.mainMenuScreen.charSelectScreen.options;
            for (CharacterOption co : options) {
                s.append(co.c.getClass().getSimpleName().toLowerCase());
                if (co.selected) {
                    s.append(" Selected");
                }
                s.append("\r\n");
            }
            SeedPanel sp = (SeedPanel)ReflectionHacks.getPrivate((Object)CardCrawlGame.mainMenuScreen.charSelectScreen, CharacterSelectScreen.class, (String)"seedPanel");
            if (sp.shown) {
                s.append("seed\r\n");
            }
            boolean ready = (Boolean)ReflectionHacks.getPrivate((Object)CardCrawlGame.mainMenuScreen.charSelectScreen, CharacterSelectScreen.class, (String)"anySelected");
            boolean asc = (Boolean)ReflectionHacks.getPrivate((Object)CardCrawlGame.mainMenuScreen.charSelectScreen, CharacterSelectScreen.class, (String)"isAscensionModeUnlocked");
            if (asc && ready) {
                s.append("asc ");
                if (CardCrawlGame.mainMenuScreen.charSelectScreen.isAscensionMode) {
                    s.append(CardCrawlGame.mainMenuScreen.charSelectScreen.ascensionLevel).append("\r\n");
                } else {
                    s.append("off\r\n");
                }
                if (TextTheSpire.ascensionReborn) {
                    s.append("c_asc ").append(AscensionMod.customAscensionRun).append("\r\n");
                    if (AscensionMod.customAscensionRun) {
                        s.append("open\r\n");
                    }
                }
            }
            if (ready) {
                s.append("embark\r\n");
            }
        } else if (TextTheSpire.ascensionReborn && CardCrawlGame.mainMenuScreen != null && CardCrawlGame.mainMenuScreen.screen == AscModScreen.Enum.ASC_MOD) {
            int i;
            s.append("Custom Ascension Screen\r\nback\r\nInput number to toggle ascension.\r\nUse ascension command to check what the modifiers do.\r\n");
            for (i = CharSelectScreenUI.ascScreen.posAscButtons.size() - 1; i >= 0; --i) {
                s.append(i + 1).append(" : ").append(((AscToggleButton)CharSelectScreenUI.ascScreen.posAscButtons.get((int)i)).toggledOn).append("\r\n");
            }
            for (i = 0; i < CharSelectScreenUI.ascScreen.negAscButtons.size(); ++i) {
                s.append(i * -1 - 1).append(" : ").append(((AscToggleButton)CharSelectScreenUI.ascScreen.negAscButtons.get((int)i)).toggledOn).append("\r\n");
            }
        } else if (CardCrawlGame.mainMenuScreen != null && (CardCrawlGame.mainMenuScreen.screen == MainMenuScreen.CurScreen.DAILY || CardCrawlGame.mainMenuScreen.screen == MainMenuScreen.CurScreen.CUSTOM)) {
            s.append("embark\r\nback\r\nExplanation:\r\nUse the Custom window to toggle custom mode options.\r\nchar [number] to toggle character\r\nasc to toggle ascension\r\nasc [number] to select ascension level\r\nseed to open the seed panel. Go to main gain window, paste the seed, and hit enter.\r\nmod [number] to toggle a custom modifier\r\nmod i [number] to inspect what a custom modifer is\r\nsimple to display a simplified version of current settings to Output\r\n");
            if (CardCrawlGame.mainMenuScreen.screen == MainMenuScreen.CurScreen.DAILY) {
                long day = (Long)ReflectionHacks.getPrivate((Object)CardCrawlGame.mainMenuScreen.dailyScreen, DailyScreen.class, (String)"currentDay");
                s.append("Daily Leaderboard ").append(TimeHelper.getDate((long)day)).append("\r\n");
                for (LeaderboardEntry e : CardCrawlGame.mainMenuScreen.dailyScreen.entries) {
                    s.append(e.rank).append(". ").append(e.name).append(" : ").append(e.score).append("\r\n");
                }
            }
        } else if (CardCrawlGame.mainMenuScreen != null && CardCrawlGame.mainMenuScreen.screen == MainMenuScreen.CurScreen.PATCH_NOTES) {
            s.append("Patch Notes are displayed in the Event window.\r\nback");
        } else if (CardCrawlGame.mainMenuScreen != null && CardCrawlGame.mainMenuScreen.screen == MainMenuScreen.CurScreen.LEADERBOARD) {
            int i;
            s.append("Leaderboard\r\nDue to technical difficulties you cannot back out of this screen.\r\n");
            s.append("char ");
            for (i = 0; i < CardCrawlGame.mainMenuScreen.leaderboardsScreen.charButtons.size(); ++i) {
                if (!((FilterButton)CardCrawlGame.mainMenuScreen.leaderboardsScreen.charButtons.get((int)i)).active) continue;
                s.append(((FilterButton)CardCrawlGame.mainMenuScreen.leaderboardsScreen.charButtons.get((int)i)).label).append("\r\n");
                break;
            }
            for (i = 0; i < CardCrawlGame.mainMenuScreen.leaderboardsScreen.charButtons.size(); ++i) {
                s.append(i).append(": ").append(((FilterButton)CardCrawlGame.mainMenuScreen.leaderboardsScreen.charButtons.get((int)i)).label).append("\r\n");
            }
            s.append("region ");
            for (i = 0; i < CardCrawlGame.mainMenuScreen.leaderboardsScreen.regionButtons.size(); ++i) {
                if (!((FilterButton)CardCrawlGame.mainMenuScreen.leaderboardsScreen.regionButtons.get((int)i)).active) continue;
                s.append(((FilterButton)CardCrawlGame.mainMenuScreen.leaderboardsScreen.regionButtons.get((int)i)).label).append("\r\n");
                break;
            }
            for (i = 0; i < CardCrawlGame.mainMenuScreen.leaderboardsScreen.regionButtons.size(); ++i) {
                s.append(i).append(": ").append(((FilterButton)CardCrawlGame.mainMenuScreen.leaderboardsScreen.regionButtons.get((int)i)).label).append("\r\n");
            }
            s.append("type ");
            for (i = 0; i < CardCrawlGame.mainMenuScreen.leaderboardsScreen.typeButtons.size(); ++i) {
                if (!((FilterButton)CardCrawlGame.mainMenuScreen.leaderboardsScreen.typeButtons.get((int)i)).active) continue;
                s.append(((FilterButton)CardCrawlGame.mainMenuScreen.leaderboardsScreen.typeButtons.get((int)i)).label).append("\r\n");
                break;
            }
            for (i = 0; i < CardCrawlGame.mainMenuScreen.leaderboardsScreen.typeButtons.size(); ++i) {
                s.append(i).append(": ").append(((FilterButton)CardCrawlGame.mainMenuScreen.leaderboardsScreen.typeButtons.get((int)i)).label).append("\r\n");
            }
        } else if (CardCrawlGame.mainMenuScreen != null && CardCrawlGame.mainMenuScreen.screen == MainMenuScreen.CurScreen.ABANDON_CONFIRM) {
            s.append("Abandon Confirm\r\nyes\r\nno");
        } else if (CardCrawlGame.mainMenuScreen != null && CardCrawlGame.mainMenuScreen.screen == MainMenuScreen.CurScreen.SAVE_SLOT) {
            if (CardCrawlGame.mainMenuScreen.saveSlotScreen.curPop == SaveSlotScreen.CurrentPopup.NONE) {
                s.append("Save Slots\r\n");
                if (!CardCrawlGame.mainMenuScreen.saveSlotScreen.cancelButton.isHidden) {
                    s.append("back\r\n");
                }
                int slot_index = 0;
                for (SaveSlot slot : CardCrawlGame.mainMenuScreen.saveSlotScreen.slots) {
                    if (slot.emptySlot) {
                        s.append(slot_index).append(" Empty\r\n");
                    } else {
                        s.append(slot_index).append(" ").append(slot.getName()).append("\r\n");
                        s.append("Completion ").append(CardCrawlGame.saveSlotPref.getFloat(SaveHelper.slotName((String)"COMPLETION", (int)slot_index), 0.0f)).append("%\r\n");
                    }
                    ++slot_index;
                }
                s.append("Possible commands:\r\nnew\r\ndelete\r\nrename\r\nopen\r\nInclude save slot index after command.\r\nExample:\r\nrename 2\r\n");
            } else if (CardCrawlGame.mainMenuScreen.saveSlotScreen.curPop == SaveSlotScreen.CurrentPopup.RENAME) {
                s.append("Go to main game window, type a name, and hit enter.\r\nName cannot be empty.\r\nHit esc to cancel.\r\n");
            } else if (CardCrawlGame.mainMenuScreen.saveSlotScreen.curPop == SaveSlotScreen.CurrentPopup.DELETE) {
                s.append("Delete Confirm\r\nyes\r\nno\r\n");
            }
        }
        return s.toString();
    }

    public static ArrayList<String> priceShopScreenChoices() {
        ArrayList<String> choices = new ArrayList<String>();
        ArrayList<Object> shopItems = Choices.getAvailableShopItems();
        for (Object item : shopItems) {
            if (item instanceof String) {
                choices.add((String)item);
                continue;
            }
            if (item instanceof AbstractCard) {
                if (TextTheSpire.replayTheSpire && ((AbstractCard)item).equals(ReplayShopInitCardsPatch.doubleCard)) {
                    choices.add(((AbstractCard)item).name.toLowerCase() + "-" + ((AbstractCard)item).price + " Two for One");
                    doubleIndex = choices.size() - 1;
                    continue;
                }
                choices.add(((AbstractCard)item).name.toLowerCase() + "-" + ((AbstractCard)item).price);
                continue;
            }
            if (item instanceof StoreRelic) {
                choices.add(((StoreRelic)item).relic.name + "-" + ((StoreRelic)item).price);
                continue;
            }
            if (!(item instanceof StorePotion)) continue;
            choices.add(((StorePotion)item).potion.name + "-" + ((StorePotion)item).price);
        }
        return choices;
    }

    public static ArrayList<Object> getAvailableShopItems() {
        ArrayList<Object> choices = new ArrayList<Object>();
        ShopScreen screen = AbstractDungeon.shopScreen;
        if (screen.purgeAvailable && AbstractDungeon.player.gold >= ShopScreen.actualPurgeCost) {
            choices.add("purge-" + ShopScreen.actualPurgeCost);
        }
        for (AbstractCard card : ChoiceScreenUtils.getShopScreenCards()) {
            if (card.price > AbstractDungeon.player.gold) continue;
            choices.add(card);
        }
        for (StoreRelic relic : ChoiceScreenUtils.getShopScreenRelics()) {
            if (relic.price > AbstractDungeon.player.gold) continue;
            choices.add(relic);
        }
        for (StorePotion potion : ChoiceScreenUtils.getShopScreenPotions()) {
            if (potion.price > AbstractDungeon.player.gold) continue;
            choices.add(potion);
        }
        return choices;
    }

    public static String stripColor(String input) {
        input = input.replace("#r", "");
        input = input.replace("#g", "");
        input = input.replace("#b", "");
        input = input.replace("#y", "");
        input = input.replace("#p", "");
        input = input.replace("~", "");
        input = input.replace("@", "");
        input = input.replace("[#2aecd7]", "");
        input = input.replace("NL", "\r\n");
        return input;
    }

    public static String mapType(String input) {
        if (input == null) {
            return "Boss Chest";
        }
        switch (input) {
            case "M": {
                return "Monster";
            }
            case "?": {
                return "Event";
            }
            case "E": {
                return "Elite";
            }
            case "$": {
                return "Shop";
            }
            case "R": {
                return "Rest";
            }
            case "T": {
                return "Treasure";
            }
            case "B": {
                return "Boss";
            }
        }
        return "Boss Chest";
    }

    static class Floor {
        public String type;
        public boolean wasUnknown;
        public ArrayList<CardChoiceStats> cardChoices;
        public ArrayList<String> potions;
        public ArrayList<String> relics;
        public ArrayList<String> purges;
        public ArrayList<String> purchases;
        public EventStats event;
        public BattleStats battle;
        public CampfireChoice campfire;
        public int currentHP;
        public int maxHP;
        public BossRelicChoiceStats boss;
        public int gold;

        Floor() {
        }
    }

    public static enum HistoryScreen {
        NONE,
        MAIN,
        LIST,
        INSPECT,
        DECK,
        RELIC,
        PATH;

    }
}

