/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.ole.win32;

import java.util.Vector;
import org.eclipse.swt.SWT;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.LONG;
import org.eclipse.swt.internal.ole.win32.COM;
import org.eclipse.swt.internal.ole.win32.COMObject;
import org.eclipse.swt.internal.ole.win32.GUID;
import org.eclipse.swt.internal.ole.win32.IOleInPlaceActiveObject;
import org.eclipse.swt.internal.win32.GUITHREADINFO;
import org.eclipse.swt.internal.win32.MENUITEMINFO;
import org.eclipse.swt.internal.win32.MSG;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.ole.win32.OLE;
import org.eclipse.swt.ole.win32.OleClientSite;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public final class OleFrame
extends Composite {
    private COMObject iUnknown;
    private COMObject iOleInPlaceFrame;
    private IOleInPlaceActiveObject objIOleInPlaceActiveObject;
    private OleClientSite currentdoc;
    private int refCount = 0;
    private MenuItem[] fileMenuItems;
    private MenuItem[] containerMenuItems;
    private MenuItem[] windowMenuItems;
    private Listener listener;
    private static String CHECK_FOCUS = "OLE_CHECK_FOCUS";
    private static String HHOOK = "OLE_HHOOK";
    private static String HHOOKMSG = "OLE_HHOOK_MSG";
    private static boolean ignoreNextKey;
    private static final short[] ACCENTS;
    private static final String CONSUME_KEY = "org.eclipse.swt.OleFrame.ConsumeKey";
    private static final String ACCEL_KEY_HIT = "org.eclipse.swt.internal.win32.accelKeyHit";

    public OleFrame(Composite composite, int n) {
        super(composite, n);
        this.createCOMInterfaces();
        this.listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 26: {
                        OleFrame.this.onActivate(event);
                        break;
                    }
                    case 27: {
                        OleFrame.this.onDeactivate(event);
                        break;
                    }
                    case 12: {
                        OleFrame.this.onDispose(event);
                        break;
                    }
                    case 10: 
                    case 11: {
                        OleFrame.this.onResize(event);
                        break;
                    }
                    default: {
                        OLE.error(20);
                    }
                }
            }
        };
        this.addListener(26, this.listener);
        this.addListener(27, this.listener);
        this.addListener(12, this.listener);
        this.addListener(11, this.listener);
        this.addListener(10, this.listener);
        this.AddRef();
        Display display = this.getDisplay();
        OleFrame.initCheckFocus(display);
        OleFrame.initMsgHook(display);
    }

    private static void initCheckFocus(final Display display) {
        if (display.getData(CHECK_FOCUS) != null) {
            return;
        }
        display.setData(CHECK_FOCUS, CHECK_FOCUS);
        final Runnable[] runnableArray = new Runnable[1];
        final Control[] controlArray = new Control[1];
        runnableArray[0] = new Runnable(){

            public void run() {
                if (controlArray[0] instanceof OleClientSite && !controlArray[0].isDisposed()) {
                    long l = OS.GetFocus();
                    while (l != 0L) {
                        long l2 = OS.GetWindow(l, 4);
                        if (l2 != 0L) {
                            display.timerExec(50, runnableArray[0]);
                            return;
                        }
                        l = OS.GetParent(l);
                    }
                }
                if (controlArray[0] == null || controlArray[0].isDisposed() || !controlArray[0].isFocusControl()) {
                    Object object;
                    Control control = display.getFocusControl();
                    if (control instanceof OleFrame) {
                        object = (OleFrame)control;
                        control = ((OleFrame)object).getCurrentDocument();
                    }
                    if (controlArray[0] != control) {
                        object = new Event();
                        if (controlArray[0] instanceof OleClientSite && !controlArray[0].isDisposed()) {
                            controlArray[0].notifyListeners(16, (Event)object);
                        }
                        if (control instanceof OleClientSite && !control.isDisposed()) {
                            control.notifyListeners(15, (Event)object);
                        }
                    }
                    controlArray[0] = control;
                }
                display.timerExec(50, runnableArray[0]);
            }
        };
        display.timerExec(50, runnableArray[0]);
    }

    private static void initMsgHook(Display display) {
        int n;
        long l;
        if (display.getData(HHOOK) != null) {
            return;
        }
        final Callback callback = new Callback(OleFrame.class, "getMsgProc", 3);
        long l2 = callback.getAddress();
        if (l2 == 0L) {
            SWT.error(3);
        }
        if ((l = OS.SetWindowsHookEx(3, l2, 0L, n = OS.GetCurrentThreadId())) == 0L) {
            callback.dispose();
            return;
        }
        display.setData(HHOOK, new LONG(l));
        display.setData(HHOOKMSG, new MSG());
        display.disposeExec(new Runnable(){

            public void run() {
                if (l != 0L) {
                    OS.UnhookWindowsHookEx(l);
                }
                if (callback != null) {
                    callback.dispose();
                }
            }
        });
    }

    static long getMsgProc(long l, long l2, long l3) {
        Display display = Display.getCurrent();
        if (display == null) {
            return 0L;
        }
        LONG lONG = (LONG)display.getData(HHOOK);
        if (lONG == null) {
            return 0L;
        }
        if (l < 0L || (l2 & 1L) == 0L) {
            return OS.CallNextHookEx(lONG.value, (int)l, l2, l3);
        }
        MSG mSG = (MSG)display.getData(HHOOKMSG);
        OS.MoveMemory(mSG, l3, MSG.sizeof);
        int n = mSG.message;
        if (256 <= n && n <= 264 && display != null) {
            Widget widget = null;
            long l4 = mSG.hwnd;
            while (l4 != 0L && (widget = display.findWidget(l4)) == null) {
                l4 = OS.GetParent(l4);
            }
            if (widget != null && widget instanceof OleClientSite) {
                OleClientSite oleClientSite = (OleClientSite)widget;
                if (oleClientSite.handle == l4) {
                    boolean bl = false;
                    int n2 = OS.GetWindowThreadProcessId(mSG.hwnd, null);
                    GUITHREADINFO gUITHREADINFO = new GUITHREADINFO();
                    gUITHREADINFO.cbSize = GUITHREADINFO.sizeof;
                    boolean bl2 = OS.GetGUIThreadInfo(n2, gUITHREADINFO);
                    int n3 = 30;
                    if (!bl2 || (gUITHREADINFO.flags & n3) == 0) {
                        OleFrame oleFrame = oleClientSite.frame;
                        oleFrame.setData(CONSUME_KEY, null);
                        display.setData(ACCEL_KEY_HIT, Boolean.TRUE);
                        bl = oleFrame.translateOleAccelerator(mSG);
                        if (display.isDisposed()) {
                            return 0L;
                        }
                        display.setData(ACCEL_KEY_HIT, Boolean.FALSE);
                        if (oleFrame.isDisposed()) {
                            return 0L;
                        }
                        String string = (String)oleFrame.getData(CONSUME_KEY);
                        if (string != null) {
                            bl = string.equals("true");
                        }
                        oleFrame.setData(CONSUME_KEY, null);
                    }
                    boolean bl3 = false;
                    block0 : switch (mSG.message) {
                        case 256: 
                        case 260: {
                            if (OS.IsWinCE) break;
                            switch ((int)mSG.wParam) {
                                case 16: 
                                case 17: 
                                case 18: 
                                case 20: 
                                case 144: 
                                case 145: {
                                    break block0;
                                }
                            }
                            int n4 = OS.MapVirtualKey((int)mSG.wParam, 2);
                            if (n4 == 0) break;
                            boolean bl4 = bl3 = (n4 & (OS.IsWinNT ? Integer.MIN_VALUE : 32768)) != 0;
                            if (bl3) break;
                            for (int i = 0; i < ACCENTS.length; ++i) {
                                short s = OS.VkKeyScan(ACCENTS[i]);
                                if (s == -1 || (long)(s & 0xFF) != mSG.wParam) continue;
                                int n5 = s >> 8;
                                if (OS.GetKeyState(16) < 0 != ((n5 & 1) != 0) || OS.GetKeyState(17) < 0 != ((n5 & 2) != 0) || OS.GetKeyState(18) < 0 != ((n5 & 4) != 0)) continue;
                                if ((n5 & 7) == 0) break block0;
                                bl3 = true;
                                break block0;
                            }
                            break;
                        }
                    }
                    if (!(bl || bl3 || ignoreNextKey)) {
                        long l5 = mSG.hwnd;
                        mSG.hwnd = oleClientSite.handle;
                        bl = OS.DispatchMessage(mSG) == 1L;
                        mSG.hwnd = l5;
                    }
                    block6 : switch (mSG.message) {
                        case 256: 
                        case 260: {
                            switch ((int)mSG.wParam) {
                                case 16: 
                                case 17: 
                                case 18: 
                                case 20: 
                                case 144: 
                                case 145: {
                                    break block6;
                                }
                            }
                            ignoreNextKey = bl3;
                        }
                    }
                    if (bl) {
                        mSG.message = 0;
                        mSG.lParam = 0L;
                        mSG.wParam = 0L;
                        OS.MoveMemory(l3, mSG, MSG.sizeof);
                        return 0L;
                    }
                }
            }
        }
        return OS.CallNextHookEx(lONG.value, (int)l, l2, l3);
    }

    int AddRef() {
        ++this.refCount;
        return this.refCount;
    }

    private int ContextSensitiveHelp(int n) {
        return 0;
    }

    private void createCOMInterfaces() {
        this.iUnknown = new COMObject(new int[]{2, 0, 0}){

            public long method0(long[] lArray) {
                return OleFrame.this.QueryInterface(lArray[0], lArray[1]);
            }

            public long method1(long[] lArray) {
                return OleFrame.this.AddRef();
            }

            public long method2(long[] lArray) {
                return OleFrame.this.Release();
            }
        };
        this.iOleInPlaceFrame = new COMObject(new int[]{2, 0, 0, 1, 1, 1, 1, 1, 2, 2, 3, 1, 1, 1, 2}){

            public long method0(long[] lArray) {
                return OleFrame.this.QueryInterface(lArray[0], lArray[1]);
            }

            public long method1(long[] lArray) {
                return OleFrame.this.AddRef();
            }

            public long method2(long[] lArray) {
                return OleFrame.this.Release();
            }

            public long method3(long[] lArray) {
                return OleFrame.this.GetWindow(lArray[0]);
            }

            public long method4(long[] lArray) {
                return OleFrame.this.ContextSensitiveHelp((int)lArray[0]);
            }

            public long method5(long[] lArray) {
                return OleFrame.this.GetBorder(lArray[0]);
            }

            public long method6(long[] lArray) {
                return OleFrame.this.RequestBorderSpace(lArray[0]);
            }

            public long method7(long[] lArray) {
                return OleFrame.this.SetBorderSpace(lArray[0]);
            }

            public long method8(long[] lArray) {
                return OleFrame.this.SetActiveObject(lArray[0], lArray[1]);
            }

            public long method9(long[] lArray) {
                return OleFrame.this.InsertMenus(lArray[0], lArray[1]);
            }

            public long method10(long[] lArray) {
                return OleFrame.this.SetMenu(lArray[0], lArray[1], lArray[2]);
            }

            public long method11(long[] lArray) {
                return OleFrame.this.RemoveMenus(lArray[0]);
            }

            public long method14(long[] lArray) {
                return OleFrame.this.TranslateAccelerator(lArray[0], (int)lArray[1]);
            }
        };
    }

    private void disposeCOMInterfaces() {
        if (this.iUnknown != null) {
            this.iUnknown.dispose();
        }
        this.iUnknown = null;
        if (this.iOleInPlaceFrame != null) {
            this.iOleInPlaceFrame.dispose();
        }
        this.iOleInPlaceFrame = null;
    }

    private int GetBorder(long l) {
        if (l == 0L) {
            return -2147024809;
        }
        RECT rECT = new RECT();
        OS.GetClientRect(this.handle, rECT);
        OS.MoveMemory(l, rECT, RECT.sizeof);
        return 0;
    }

    public MenuItem[] getContainerMenus() {
        return this.containerMenuItems;
    }

    public MenuItem[] getFileMenus() {
        return this.fileMenuItems;
    }

    long getIOleInPlaceFrame() {
        return this.iOleInPlaceFrame.getAddress();
    }

    private long getMenuItemID(long l, int n) {
        long l2 = 0L;
        MENUITEMINFO mENUITEMINFO = new MENUITEMINFO();
        mENUITEMINFO.cbSize = MENUITEMINFO.sizeof;
        mENUITEMINFO.fMask = 7;
        OS.GetMenuItemInfo(l, n, true, mENUITEMINFO);
        l2 = (mENUITEMINFO.fState & 0x10) == 16 ? mENUITEMINFO.hSubMenu : (long)mENUITEMINFO.wID;
        return l2;
    }

    private int GetWindow(long l) {
        if (l != 0L) {
            COM.MoveMemory(l, new long[]{this.handle}, OS.PTR_SIZEOF);
        }
        return 0;
    }

    public MenuItem[] getWindowMenus() {
        return this.windowMenuItems;
    }

    private int InsertMenus(long l, long l2) {
        int n;
        Menu menu = this.getShell().getMenuBar();
        if (menu == null || menu.isDisposed()) {
            COM.MoveMemory(l2, new int[]{0}, 4);
            return 0;
        }
        long l3 = menu.handle;
        MENUITEMINFO mENUITEMINFO = new MENUITEMINFO();
        long l4 = OS.GetProcessHeap();
        int n2 = 128;
        int n3 = n2 * TCHAR.sizeof;
        long l5 = OS.HeapAlloc(l4, 8, n3);
        mENUITEMINFO.cbSize = MENUITEMINFO.sizeof;
        mENUITEMINFO.fMask = 55;
        mENUITEMINFO.dwTypeData = l5;
        mENUITEMINFO.cch = n2;
        int n4 = 0;
        int n5 = 0;
        if (this.fileMenuItems != null) {
            for (n = 0; n < this.fileMenuItems.length; ++n) {
                MenuItem menuItem = this.fileMenuItems[n];
                if (menuItem == null) continue;
                int n6 = menuItem.getParent().indexOf(menuItem);
                mENUITEMINFO.cch = n2;
                if (!OS.GetMenuItemInfo(l3, n6, true, mENUITEMINFO) || !OS.InsertMenuItem(l, n5, true, mENUITEMINFO)) continue;
                ++n4;
                ++n5;
            }
        }
        COM.MoveMemory(l2, new int[]{n4}, 4);
        n = 0;
        if (this.containerMenuItems != null) {
            for (int i = 0; i < this.containerMenuItems.length; ++i) {
                MenuItem menuItem = this.containerMenuItems[i];
                if (menuItem == null) continue;
                int n7 = menuItem.getParent().indexOf(menuItem);
                mENUITEMINFO.cch = n2;
                if (!OS.GetMenuItemInfo(l3, n7, true, mENUITEMINFO) || !OS.InsertMenuItem(l, n5, true, mENUITEMINFO)) continue;
                ++n;
                ++n5;
            }
        }
        COM.MoveMemory(l2 + 8L, new int[]{n}, 4);
        int n8 = 0;
        if (this.windowMenuItems != null) {
            for (int i = 0; i < this.windowMenuItems.length; ++i) {
                MenuItem menuItem = this.windowMenuItems[i];
                if (menuItem == null) continue;
                int n9 = menuItem.getParent().indexOf(menuItem);
                mENUITEMINFO.cch = n2;
                if (!OS.GetMenuItemInfo(l3, n9, true, mENUITEMINFO) || !OS.InsertMenuItem(l, n5, true, mENUITEMINFO)) continue;
                ++n8;
                ++n5;
            }
        }
        COM.MoveMemory(l2 + 16L, new int[]{n8}, 4);
        if (l5 != 0L) {
            OS.HeapFree(l4, 0, l5);
        }
        return 0;
    }

    void onActivate(Event event) {
        if (this.objIOleInPlaceActiveObject != null) {
            this.objIOleInPlaceActiveObject.OnFrameWindowActivate(true);
        }
    }

    void onDeactivate(Event event) {
        if (this.objIOleInPlaceActiveObject != null) {
            this.objIOleInPlaceActiveObject.OnFrameWindowActivate(false);
        }
    }

    private void onDispose(Event event) {
        this.releaseObjectInterfaces();
        this.currentdoc = null;
        this.Release();
        this.removeListener(26, this.listener);
        this.removeListener(27, this.listener);
        this.removeListener(12, this.listener);
        this.removeListener(11, this.listener);
        this.removeListener(10, this.listener);
    }

    private void onResize(Event event) {
        if (this.objIOleInPlaceActiveObject != null) {
            RECT rECT = new RECT();
            OS.GetClientRect(this.handle, rECT);
            this.objIOleInPlaceActiveObject.ResizeBorder(rECT, this.iOleInPlaceFrame.getAddress(), true);
        }
    }

    private int QueryInterface(long l, long l2) {
        if (l == 0L || l2 == 0L) {
            return -2147024809;
        }
        GUID gUID = new GUID();
        COM.MoveMemory(gUID, l, GUID.sizeof);
        if (COM.IsEqualGUID(gUID, COM.IIDIUnknown) || COM.IsEqualGUID(gUID, COM.IIDIOleInPlaceFrame)) {
            COM.MoveMemory(l2, new long[]{this.iOleInPlaceFrame.getAddress()}, OS.PTR_SIZEOF);
            this.AddRef();
            return 0;
        }
        COM.MoveMemory(l2, new long[]{0L}, OS.PTR_SIZEOF);
        return -2147467262;
    }

    int Release() {
        --this.refCount;
        if (this.refCount == 0) {
            this.disposeCOMInterfaces();
            if (COM.FreeUnusedLibraries) {
                COM.CoFreeUnusedLibraries();
            }
        }
        return this.refCount;
    }

    private void releaseObjectInterfaces() {
        if (this.objIOleInPlaceActiveObject != null) {
            this.objIOleInPlaceActiveObject.Release();
        }
        this.objIOleInPlaceActiveObject = null;
    }

    private int RemoveMenus(long l) {
        long l2;
        int n;
        MenuItem menuItem;
        int n2;
        Menu menu = this.getShell().getMenuBar();
        if (menu == null || menu.isDisposed()) {
            return 1;
        }
        long l3 = menu.handle;
        Vector<LONG> vector = new Vector<LONG>();
        if (this.fileMenuItems != null) {
            for (n2 = 0; n2 < this.fileMenuItems.length; ++n2) {
                menuItem = this.fileMenuItems[n2];
                if (menuItem == null || menuItem.isDisposed()) continue;
                n = menuItem.getParent().indexOf(menuItem);
                l2 = this.getMenuItemID(l3, n);
                vector.addElement(new LONG(l2));
            }
        }
        if (this.containerMenuItems != null) {
            for (n2 = 0; n2 < this.containerMenuItems.length; ++n2) {
                menuItem = this.containerMenuItems[n2];
                if (menuItem == null || menuItem.isDisposed()) continue;
                n = menuItem.getParent().indexOf(menuItem);
                l2 = this.getMenuItemID(l3, n);
                vector.addElement(new LONG(l2));
            }
        }
        if (this.windowMenuItems != null) {
            for (n2 = 0; n2 < this.windowMenuItems.length; ++n2) {
                menuItem = this.windowMenuItems[n2];
                if (menuItem == null || menuItem.isDisposed()) continue;
                n = menuItem.getParent().indexOf(menuItem);
                l2 = this.getMenuItemID(l3, n);
                vector.addElement(new LONG(l2));
            }
        }
        for (int i = n2 = OS.GetMenuItemCount(l) - 1; i >= 0; --i) {
            long l4 = this.getMenuItemID(l, i);
            if (!vector.contains(new LONG(l4))) continue;
            OS.RemoveMenu(l, i, 1024);
        }
        return 0;
    }

    private int RequestBorderSpace(long l) {
        return 0;
    }

    int SetActiveObject(long l, long l2) {
        if (this.objIOleInPlaceActiveObject != null) {
            this.objIOleInPlaceActiveObject.Release();
            this.objIOleInPlaceActiveObject = null;
        }
        if (l != 0L) {
            this.objIOleInPlaceActiveObject = new IOleInPlaceActiveObject(l);
            this.objIOleInPlaceActiveObject.AddRef();
        }
        return 0;
    }

    private int SetBorderSpace(long l) {
        if (this.objIOleInPlaceActiveObject == null) {
            return 0;
        }
        RECT rECT = new RECT();
        if (l == 0L || this.currentdoc == null) {
            return 0;
        }
        COM.MoveMemory(rECT, l, RECT.sizeof);
        this.currentdoc.setBorderSpace(rECT);
        return 0;
    }

    public void setContainerMenus(MenuItem[] menuItemArray) {
        this.containerMenuItems = menuItemArray;
    }

    OleClientSite getCurrentDocument() {
        return this.currentdoc;
    }

    void setCurrentDocument(OleClientSite oleClientSite) {
        this.currentdoc = oleClientSite;
        if (this.currentdoc != null && this.objIOleInPlaceActiveObject != null) {
            RECT rECT = new RECT();
            OS.GetClientRect(this.handle, rECT);
            this.objIOleInPlaceActiveObject.ResizeBorder(rECT, this.iOleInPlaceFrame.getAddress(), true);
        }
    }

    public void setFileMenus(MenuItem[] menuItemArray) {
        this.fileMenuItems = menuItemArray;
    }

    private int SetMenu(long l, long l2, long l3) {
        Menu menu;
        long l4 = 0L;
        if (this.objIOleInPlaceActiveObject != null) {
            l4 = this.objIOleInPlaceActiveObject.getAddress();
        }
        if ((menu = this.getShell().getMenuBar()) == null || menu.isDisposed()) {
            return COM.OleSetMenuDescriptor(0L, this.getShell().handle, l3, this.iOleInPlaceFrame.getAddress(), l4);
        }
        long l5 = menu.getShell().handle;
        if (l == 0L && l2 == 0L) {
            l = menu.handle;
        }
        if (l == 0L) {
            return -2147467259;
        }
        OS.SetMenu(l5, l);
        OS.DrawMenuBar(l5);
        return COM.OleSetMenuDescriptor(l2, l5, l3, this.iOleInPlaceFrame.getAddress(), l4);
    }

    public void setWindowMenus(MenuItem[] menuItemArray) {
        this.windowMenuItems = menuItemArray;
    }

    private boolean translateOleAccelerator(MSG mSG) {
        if (this.objIOleInPlaceActiveObject == null) {
            return false;
        }
        int n = this.objIOleInPlaceActiveObject.TranslateAccelerator(mSG);
        return n != 1 && n != -2147467263;
    }

    private int TranslateAccelerator(long l, int n) {
        Menu menu = this.getShell().getMenuBar();
        if (menu == null || menu.isDisposed() || !menu.isEnabled()) {
            return 1;
        }
        if (n < 0) {
            return 1;
        }
        Shell shell = menu.getShell();
        long l2 = shell.handle;
        long l3 = OS.SendMessage(l2, 32769, 0L, 0L);
        if (l3 == 0L) {
            return 1;
        }
        MSG mSG = new MSG();
        OS.MoveMemory(mSG, l, MSG.sizeof);
        int n2 = OS.TranslateAccelerator(l2, l3, mSG);
        return n2 == 0 ? 1 : 0;
    }

    static {
        ACCENTS = new short[]{126, 96, 39, 94, 34};
    }
}

