/*
 * Decompiled with CFR 0.152.
 */
package textTheSpire;

import com.badlogic.gdx.Gdx;
import com.megacrit.cardcrawl.cards.AbstractCard;
import com.megacrit.cardcrawl.cards.CardGroup;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.potions.AbstractPotion;
import com.megacrit.cardcrawl.rooms.AbstractRoom;
import communicationmod.CommandExecutor;
import java.util.ArrayList;
import org.eclipse.swt.widgets.Display;
import textTheSpire.AbstractWindow;
import textTheSpire.Window;

public class Hand
extends AbstractWindow {
    public Hand(Display display) {
        this.isVisible = true;
        this.window = new Window(display, "Hand", 300, 300);
    }

    @Override
    public String getText() {
        if (this.window.shell.isDisposed()) {
            Display.getDefault().dispose();
            Gdx.app.exit();
        }
        StringBuilder s = new StringBuilder();
        s.append("\r\n");
        if (CardCrawlGame.dungeon == null || !CommandExecutor.isInDungeon() || !CardCrawlGame.isInARun()) {
            return "";
        }
        if (AbstractDungeon.getCurrRoom().phase == AbstractRoom.RoomPhase.COMBAT) {
            CardGroup h = AbstractDungeon.player.hand;
            int count = 1;
            for (AbstractCard c : h.group) {
                int cost = Hand.handCost(c);
                if (cost == -2) {
                    s.append(count).append(":").append(c.name).append("\r\n");
                } else if (cost == -1) {
                    s.append(count).append(":").append(c.name).append(" X").append("\r\n");
                } else {
                    s.append(count).append(":").append(c.name).append(" ").append(cost).append("\r\n");
                }
                ++count;
            }
            ArrayList pl = AbstractDungeon.player.potions;
            count = 0;
            if (pl.size() > 0) {
                s.append("Potions:\r\n");
                for (AbstractPotion po : pl) {
                    s.append(count).append(":").append(po.name).append("\r\n");
                    ++count;
                }
            }
            return s.toString();
        }
        return "";
    }

    public static int handCost(AbstractCard c) {
        if (c.freeToPlay()) {
            return 0;
        }
        return c.costForTurn;
    }
}

