/*
 * Decompiled with CFR 0.152.
 */
package speechd.ssip;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import speechd.ssip.SSIPCommand;
import speechd.ssip.SSIPCommandException;
import speechd.ssip.SSIPCommunicationException;
import speechd.ssip.SSIPDataException;
import speechd.ssip.SSIPEventHandler;
import speechd.ssip.SSIPEventParser;
import speechd.ssip.SSIPException;
import speechd.ssip.SSIPResponse;

public class SSIPConnection {
    private static final String CRLF = "\r\n";
    private static final String END_OF_DATA = "\r\n.\r\n";
    private Socket _socket;
    private BufferedReader _reader;
    private BufferedWriter _writer;
    private String _host;
    private int _port;
    private boolean _connected;
    private SSIPResponse _currentResponse;
    private Thread _thread;
    private SSIPEventHandler _eventHandler = null;
    private Logger _logger = Logger.getLogger("speechd.ssip.SSIPConnection");

    public SSIPConnection(String string, int n) {
        this._host = string;
        this._port = n;
        this._connected = false;
        this._socket = null;
        this._logger.log(Level.FINEST, "created connection");
    }

    public void connect() throws SSIPException {
        try {
            this._socket = new Socket(this._host, this._port);
            this._logger.log(Level.INFO, String.format("connected to %s port %d", this._host, this._port));
            this._socket.setTcpNoDelay(true);
            this._reader = new BufferedReader(new InputStreamReader(this._socket.getInputStream()));
            this._writer = new BufferedWriter(new OutputStreamWriter(this._socket.getOutputStream()));
        }
        catch (IOException iOException) {
            this._logger.log(Level.SEVERE, String.format("I/O error connecting to %s port %d: %s", this._host, this._port, iOException.getMessage()));
            throw new SSIPCommunicationException("can't connect to host");
        }
        this._connected = true;
        this._thread = new Thread(new InputThread());
        this._thread.setDaemon(true);
        this._thread.start();
        this._logger.log(Level.INFO, "started communications thread");
    }

    public void disconnect() {
        if (!this._connected) {
            return;
        }
        this._connected = false;
        try {
            this._logger.log(Level.FINE, "joining communications thread");
            this._thread.join();
            this._socket.close();
            this._logger.info("disconnected from host");
        }
        catch (InterruptedException interruptedException) {
            this._logger.log(Level.WARNING, "interrupted exception when disconnecting", interruptedException);
        }
        catch (IOException iOException) {
            this._logger.log(Level.WARNING, "I/O exception when disconnecting", iOException);
        }
        finally {
            this._thread = null;
            this._socket = null;
        }
    }

    public synchronized SSIPResponse sendCommand(SSIPCommand sSIPCommand) throws SSIPCommandException, SSIPCommunicationException {
        if (!this._connected) {
            throw new SSIPCommunicationException("not connected to server");
        }
        try {
            this._logger.log(Level.FINE, "Sending command %s", sSIPCommand.toString());
            this._writer.write(sSIPCommand.toString());
            this._writer.write(CRLF);
            this._writer.flush();
            this._logger.log(Level.FINE, "command sent");
            SSIPResponse sSIPResponse = null;
            this._logger.fine("receiving response");
            while (this._currentResponse == null) {
                this.wait();
                sSIPResponse = this._currentResponse;
                this._logger.fine(String.format("Received response %s", sSIPResponse));
            }
            this._currentResponse = null;
            if (sSIPResponse.getCode() / 100 != 2) {
                this._logger.warning(String.format("Error code %d returned from server", sSIPResponse.getCode()));
                throw new SSIPCommandException(sSIPCommand, sSIPResponse);
            }
            return sSIPResponse;
        }
        catch (IOException iOException) {
            this._logger.log(Level.SEVERE, "I/O when sending command", iOException);
            this.disconnect();
            throw new SSIPCommunicationException("disconnected from server");
        }
        catch (InterruptedException interruptedException) {
            this._logger.log(Level.SEVERE, "Communications thread interrupted when sending command");
            this.disconnect();
            throw new SSIPCommunicationException(interruptedException);
        }
    }

    public synchronized SSIPResponse sendData(String string) throws SSIPDataException, SSIPCommunicationException {
        if (!this._connected) {
            throw new SSIPCommunicationException("not connected to server");
        }
        String string2 = this.escapeData(string);
        try {
            this._writer.write(string2);
            this._writer.write(END_OF_DATA);
            this._writer.flush();
            SSIPResponse sSIPResponse = null;
            while (this._currentResponse == null) {
                this.wait();
                sSIPResponse = this._currentResponse;
            }
            this._currentResponse = null;
            if (sSIPResponse.getCode() / 100 != 2) {
                throw new SSIPDataException(string, sSIPResponse);
            }
            return sSIPResponse;
        }
        catch (IOException iOException) {
            this.disconnect();
            throw new SSIPCommunicationException(iOException);
        }
        catch (InterruptedException interruptedException) {
            this.disconnect();
            throw new SSIPCommunicationException(interruptedException);
        }
    }

    private String escapeData(String string) {
        String string2 = string;
        if (string2.startsWith(".")) {
            string2 = ".." + string2;
        }
        string2 = string2.replaceAll("\r\n.", "\r\n..");
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatch(SSIPResponse sSIPResponse) throws InterruptedException {
        if (sSIPResponse.getCode() / 100 == 7) {
            if (this._eventHandler != null) {
                try {
                    this._eventHandler.handleSSIPEvent(SSIPEventParser.getInstance().parse(sSIPResponse));
                }
                catch (Exception exception) {
                    this._logger.severe(String.format("Exception in user callback: %s\n%s", exception.getLocalizedMessage(), exception.getStackTrace()));
                }
            }
        } else {
            SSIPConnection sSIPConnection = this;
            synchronized (sSIPConnection) {
                this._currentResponse = sSIPResponse;
                this.notify();
            }
        }
    }

    private String readLine() throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        char c = (char)this._reader.read();
        char c2 = (char)this._reader.read();
        while (c != '\r' || c2 != '\n') {
            stringBuilder.append(c);
            c = c2;
            c2 = (char)this._reader.read();
        }
        this._logger.finest(String.format("Read line %s", stringBuilder.toString()));
        return stringBuilder.toString();
    }

    public boolean isConnected() {
        return this._connected;
    }

    public SSIPEventHandler getEventHandler() {
        return this._eventHandler;
    }

    public void setEventHandler(SSIPEventHandler sSIPEventHandler) {
        this._eventHandler = sSIPEventHandler;
    }

    private class InputThread
    implements Runnable {
        private InputThread() {
        }

        @Override
        public void run() {
            while (SSIPConnection.this.isConnected()) {
                LinkedList<String> linkedList = new LinkedList<String>();
                try {
                    while (SSIPConnection.this._reader.ready()) {
                        String string = SSIPConnection.this.readLine();
                        assert (string.length() >= 4 && (string.charAt(3) == '-' || string.charAt(3) == ' '));
                        char c = string.charAt(3);
                        int n = Integer.parseInt(string.substring(0, 3));
                        if (c == ' ') {
                            String string2 = string.substring(4);
                            SSIPResponse sSIPResponse = linkedList.isEmpty() ? new SSIPResponse(n, string2) : new SSIPResponse(n, string2, linkedList);
                            SSIPConnection.this.dispatch(sSIPResponse);
                            continue;
                        }
                        if (c != '-') continue;
                        linkedList.add(string.substring(4));
                    }
                    Thread.yield();
                }
                catch (IOException iOException) {
                    Thread.currentThread().interrupt();
                    SSIPConnection.this.disconnect();
                }
                catch (InterruptedException interruptedException) {
                    SSIPConnection.this.disconnect();
                }
            }
        }
    }
}

