/*
 * Decompiled with CFR 0.152.
 */
package speechd.ssip;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import speechd.ssip.SSIPCapitalLetters;
import speechd.ssip.SSIPCommand;
import speechd.ssip.SSIPConnection;
import speechd.ssip.SSIPEvent;
import speechd.ssip.SSIPEventHandler;
import speechd.ssip.SSIPException;
import speechd.ssip.SSIPPriority;
import speechd.ssip.SSIPPunctuation;
import speechd.ssip.SSIPResponse;
import speechd.ssip.SSIPSynthesisVoice;

public class SSIPClient {
    public static final String DEFAULT_HOST = "localhost";
    public static final int DEFAULT_PORT = 6560;
    private SSIPConnection _connection;
    private String _target;
    private String _name;
    private String _component;
    private String _user;
    private String _host;
    private int _port;
    private int _clientId;
    private Logger _logger = Logger.getLogger("speechd.ssip.SSIPClient");

    public SSIPClient(String string, String string2, String string3) throws SSIPException {
        if (string == null) {
            throw new NullPointerException("SSIP connection's name can't be null");
        }
        this._name = string;
        this._logger.fine(String.format("Defnining connection's name as %s", this._name));
        this._component = string2 == null ? "main" : string2;
        this._logger.fine(String.format("Defining connection's component as %s", this._component));
        this._user = string3 == null ? System.getProperty("user.name") : string3;
        this._logger.fine(String.format("Defining user as %s", this._user));
        this._host = System.getProperty("speechd.host");
        if (this._host == null && (this._host = System.getenv("SPEECHD_HOST")) == null) {
            this._host = DEFAULT_HOST;
        }
        this._logger.fine(String.format("Defining host as %s", this._host));
        String string4 = System.getProperty("speechd.port");
        if (string4 == null) {
            string4 = System.getenv("SPEECHD_PORT");
            this._port = string4 != null ? Integer.parseInt(string4) : 6560;
        }
        this._logger.fine(String.format("Defining port as %d", this._port));
        this._connection = new SSIPConnection(this._host, this._port);
        this._connection.connect();
        this._logger.info("connected to host");
        this.setTarget(Target.SELF);
        this.setParameter(this._target, "client_name", this.makeFullName());
        this._logger.fine("Client name set");
        SSIPResponse sSIPResponse = this._connection.sendCommand(new SSIPCommand("HISTORY", "GET", "CLIENT_ID"));
        this._clientId = this.getIntResponse(sSIPResponse);
        this._logger.fine(String.format("Client id is %d", this._clientId));
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.close();
    }

    public void close() throws SSIPException {
        if (this._connection.isConnected()) {
            this._connection.sendCommand(new SSIPCommand("quit"));
            this._connection.disconnect();
            this._logger.info("Disconnected from host");
        }
    }

    public int say(SSIPPriority sSIPPriority, String string) throws SSIPException {
        this.setPriority(sSIPPriority);
        this._logger.info(String.format("Saying message:\n%s", string));
        this._connection.sendCommand(new SSIPCommand("speak"));
        SSIPResponse sSIPResponse = this._connection.sendData(string);
        int n = this.getIntResponse(sSIPResponse);
        this._logger.fine(String.format("Message id is %d", n));
        return n;
    }

    public int sayFormated(SSIPPriority sSIPPriority, String string, Object ... objectArray) throws SSIPException {
        return this.say(sSIPPriority, String.format(string, objectArray));
    }

    public void sayChar(SSIPPriority sSIPPriority, char c) throws SSIPException {
        this.setPriority(sSIPPriority);
        String string = c == ' ' ? "space" : Character.toString(c);
        this._logger.info(String.format("Saying character %s", string));
        this._connection.sendCommand(new SSIPCommand("CHAR", string));
    }

    public void sayKey(SSIPPriority sSIPPriority, String string) throws SSIPException {
        this.setPriority(sSIPPriority);
        this._logger.info(String.format("Saying key %s", string));
        this._connection.sendCommand(new SSIPCommand("KEY", string));
    }

    public void soundIcon(SSIPPriority sSIPPriority, String string) throws SSIPException {
        this.setPriority(sSIPPriority);
        this._logger.info(String.format("Playing sound icon %s", string));
        this._connection.sendCommand(new SSIPCommand("SOUND_ICON", string));
    }

    public void stop() throws SSIPException {
        this._logger.info("stopping");
        this._connection.sendCommand(new SSIPCommand("STOP", this._target));
    }

    public void cancel() throws SSIPException {
        this._logger.info("caceling");
        this._connection.sendCommand(new SSIPCommand("CANCEL", this._target));
    }

    public void pause() throws SSIPException {
        this._logger.info("Pausing");
        this._connection.sendCommand(new SSIPCommand("pause", this._target));
    }

    public void resume() throws SSIPException {
        this._logger.info("Pause");
        this._connection.sendCommand(new SSIPCommand("resume", this._target));
    }

    public void beginBlock() throws SSIPException {
        this._logger.info("Begin of block");
        this._connection.sendCommand(new SSIPCommand("BLOCK", "BEGIN"));
    }

    public void endBlock() throws SSIPException {
        this._logger.info("End of block");
        this._connection.sendCommand(new SSIPCommand("BLOCK", "END"));
    }

    public void setVolume(int n) throws SSIPException {
        this.verifySynthParameter(n);
        this.setParameter(this._target, "volume", n);
    }

    public void setRate(int n) throws SSIPException {
        this.verifySynthParameter(n);
        this.setParameter(this._target, "RATE", n);
    }

    public void setPitch(int n) throws SSIPException {
        this.verifySynthParameter(n);
        this.setParameter(this._target, "PITCH", n);
    }

    public void setOutputModule(String string) throws SSIPException {
        this.setParameter(this._target, "OUTPUT_MODULE", string);
    }

    public void setLanguage(String string) throws SSIPException {
        this.setParameter(this._target, "LANGUAGE", string);
    }

    public void setSSMLMOde(boolean bl) throws SSIPException {
        this.setParameter(this._target, "SSML_MODE", bl);
    }

    public void setPunctuation(SSIPPunctuation sSIPPunctuation) throws SSIPException {
        this.setParameter(this._target, "PUNCTUATION", sSIPPunctuation.toString().toLowerCase());
    }

    public void setSpelling(boolean bl) throws SSIPException {
        this.setParameter(this._target, "SPELLING", bl);
    }

    public void setVoice(String string) throws SSIPException {
        this.setParameter(this._target, "VOICE", string);
    }

    public void setSynthesisVoice(String string) throws SSIPException {
        this.setParameter(this._target, "SYNTHESIS_VOICE", string);
    }

    public void setPauseContext(int n) throws SSIPException {
        if (n < 0 || n < 100) {
            throw new IllegalArgumentException("pause context must be positive integer between 0 and 100");
        }
        this.setParameter(this._target, "PAUSE_CONTEXT", n);
    }

    public void setCapitalLettersRecognitionMode(SSIPCapitalLetters sSIPCapitalLetters) throws SSIPException {
        this.setParameter(this._target, "CAP_LET_RECOGN", sSIPCapitalLetters.toString().toLowerCase());
    }

    public List<String> getOutputModules() throws SSIPException {
        this._logger.info("Listing output modules");
        SSIPResponse sSIPResponse = this._connection.sendCommand(new SSIPCommand("LIST", "OUTPUT_MODULES"));
        List<String> list = this.getListResponse(sSIPResponse);
        this._logger.fine(String.format("Output modules are: %s", list.toString()));
        return list;
    }

    public List<String> getVoices() throws SSIPException {
        this._logger.info("Getting voice names list");
        return this.getListResponse(this._connection.sendCommand(new SSIPCommand("LIST", "VOICES")));
    }

    public List<SSIPSynthesisVoice> getSynthesisVoices() throws SSIPException {
        this._logger.info("Getting synthesis voices");
        SSIPResponse sSIPResponse = this._connection.sendCommand(new SSIPCommand("LIST", "SYNTHESIS_VOICES"));
        List<String> list = this.getListResponse(sSIPResponse);
        LinkedList<SSIPSynthesisVoice> linkedList = new LinkedList<SSIPSynthesisVoice>();
        for (String string : list) {
            String[] stringArray = string.split(" ");
            assert (stringArray.length == 3);
            linkedList.add(new SSIPSynthesisVoice(stringArray[0], stringArray[1], stringArray[2]));
        }
        return Collections.unmodifiableList(linkedList);
    }

    public SSIPConnection getConnection() {
        return this._connection;
    }

    public void setTarget(Target target) {
        this._target = target.toString();
    }

    public void setTarget(int n) {
        this.verifyId(n);
        this._target = Integer.toString(n);
    }

    public void setEventHandler(SSIPEventHandler sSIPEventHandler) {
        this._connection.setEventHandler(sSIPEventHandler);
    }

    public void setNotification(boolean bl) throws SSIPException {
        this._connection.sendCommand(new SSIPCommand("SET", Target.SELF.toString(), "NOTIFICATION", "ALL", bl ? "on" : "off"));
    }

    public void setNotification(boolean bl, SSIPEvent.EventType eventType) throws SSIPException {
        this._connection.sendCommand(new SSIPCommand("SET", Target.SELF.toString(), "NOTIFICATION", eventType.toString().toUpperCase(), bl ? "on" : "off"));
    }

    protected void verifyId(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("client ids must be postivie integers");
        }
    }

    protected void verifySynthParameter(int n) {
        if (n > 100 || n < -100) {
            throw new IllegalArgumentException("synth parameters must be between -100 and 100");
        }
    }

    protected String makeFullName() {
        return this._name + ":" + this._component + ":" + this._user;
    }

    protected void setParameter(String string, String string2, String string3) throws SSIPException {
        this._logger.info(String.format("Setting parameter %s to target %s with value %s", string2, string, string3));
        this._connection.sendCommand(new SSIPCommand("set", string, string2, string3));
    }

    protected void setParameter(String string, String string2, int n) throws SSIPException {
        this.setParameter(string, string2, Integer.toString(n));
    }

    protected void setParameter(String string, String string2, boolean bl) throws SSIPException {
        this.setParameter(string, string2, bl ? "on" : "off");
    }

    protected void setPriority(SSIPPriority sSIPPriority) throws SSIPException {
        this.setParameter(Target.SELF.toString(), "priority", sSIPPriority.toString());
    }

    protected int getIntResponse(SSIPResponse sSIPResponse) {
        assert (sSIPResponse.getData() != null);
        return Integer.parseInt(sSIPResponse.getData().get(0));
    }

    protected List<String> getListResponse(SSIPResponse sSIPResponse) {
        List<String> list = sSIPResponse.getData() != null ? Collections.unmodifiableList(sSIPResponse.getData()) : Collections.emptyList();
        return list;
    }

    public int getClientId() {
        return this._clientId;
    }

    public static enum Target {
        SELF,
        ALL;

    }
}

