/*
 * Decompiled with CFR 0.152.
 */
package sayTheSpire.utils;

import com.megacrit.cardcrawl.characters.AbstractPlayer;
import com.megacrit.cardcrawl.core.AbstractCreature;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.helpers.ModHelper;
import com.megacrit.cardcrawl.monsters.AbstractMonster;
import com.megacrit.cardcrawl.rooms.AbstractRoom;
import java.util.HashMap;
import java.util.stream.Collectors;
import sayTheSpire.Output;
import sayTheSpire.utils.MonsterUtils;

public class OutputUtils {
    public static Boolean canGetPlayer() {
        return CardCrawlGame.dungeon != null && OutputUtils.isInDungeon() && CardCrawlGame.isInARun();
    }

    public static AbstractPlayer getPlayer() {
        if (!OutputUtils.canGetPlayer().booleanValue()) {
            return null;
        }
        return AbstractDungeon.player;
    }

    public static boolean isInDungeon() {
        return CardCrawlGame.mode == CardCrawlGame.GameMode.GAMEPLAY && AbstractDungeon.isPlayerInDungeon();
    }

    public static Boolean isInCombat() {
        return OutputUtils.canGetPlayer() != false && AbstractDungeon.getCurrRoom().phase == AbstractRoom.RoomPhase.COMBAT;
    }

    public static String getCreatureName(AbstractCreature creature) {
        if (creature == OutputUtils.getPlayer()) {
            return OutputUtils.getPlayerName();
        }
        if (creature instanceof AbstractMonster) {
            return MonsterUtils.getName((AbstractMonster)creature);
        }
        return creature.name;
    }

    public static String getPlayerName() {
        return CardCrawlGame.playerName;
    }

    public static String getCreaturePowersString(AbstractCreature creature) {
        if (creature.powers.isEmpty()) {
            return Output.localization.localize("text.powers.no powers", new Object[0]);
        }
        String powerList = creature.powers.stream().map(power -> Output.localization.localize("text.powers.powerLabel", "power", power.name, "amount", power.amount)).collect(Collectors.joining(", "));
        return Output.localization.localize("text.powers.powerListString", "powers", powerList);
    }

    public static HashMap<String, String> getValidEnergyTypes() {
        HashMap<String, String> types = new HashMap<String, String>();
        types.put("R", "red energy");
        types.put("G", "green energy");
        types.put("B", "blue energy");
        types.put("W", "white energy");
        types.put("E", "energy");
        return types;
    }

    public static Boolean playerHasRelic(String relic) {
        AbstractPlayer player = OutputUtils.getPlayer();
        if (player == null) {
            return false;
        }
        return player.hasRelic(relic);
    }

    public static Boolean playerIsFlying() {
        AbstractPlayer player = OutputUtils.getPlayer();
        if (player == null) {
            return false;
        }
        return ModHelper.isModEnabled((String)"Flight") || player.hasRelic("WingedGreaves") && player.getRelic((String)"WingedGreaves").counter > 0;
    }
}

