/*
 * Decompiled with CFR 0.152.
 */
package sayTheSpire.utils;

import com.megacrit.cardcrawl.cards.AbstractCard;
import com.megacrit.cardcrawl.cards.DescriptionLine;
import java.util.ArrayList;
import java.util.HashMap;
import sayTheSpire.Output;
import sayTheSpire.TextParser;
import sayTheSpire.ui.positions.GridPosition;
import sayTheSpire.utils.OutputUtils;

public class CardUtils {
    public static String getCardCostString(AbstractCard card) {
        int cost = 0;
        cost = OutputUtils.isInCombat() != false ? card.costForTurn : card.cost;
        if (card.cost == -1) {
            return "X";
        }
        if (card.freeToPlay()) {
            return "0";
        }
        return Integer.toString(cost);
    }

    private static String extractUpdatedDescription(AbstractCard card) {
        StringBuilder sb = new StringBuilder();
        int lineCount = card.description.size();
        for (int d = 0; d < lineCount; ++d) {
            DescriptionLine line = (DescriptionLine)card.description.get(d);
            for (String token : line.getText().split("\\s+")) {
                sb.append(token);
                sb.append(' ');
            }
            if (d >= lineCount - 1) continue;
            sb.append(" NL ");
        }
        return sb.toString();
    }

    public static String getCardDescriptionString(AbstractCard card) {
        String description = Output.config.getBoolean("advanced.use_updated_card_description", false) != false ? CardUtils.extractUpdatedDescription(card) : card.rawDescription;
        return TextParser.parse(description.replaceAll("([^ ])(![A-Z]!)", "$1 $2"), card);
    }

    public static HashMap<String, String> getCardDynamicVariables(AbstractCard card) {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("B", Integer.toString(CardUtils.getCardBlock(card)));
        variables.put("D", Integer.toString(CardUtils.getCardDamage(card)));
        variables.put("M", Integer.toString(CardUtils.getCardMagicNumber(card)));
        return variables;
    }

    public static int getCardBlock(AbstractCard card) {
        if (card.isBlockModified) {
            return card.block;
        }
        return card.baseBlock;
    }

    public static int getCardDamage(AbstractCard card) {
        if (card.isDamageModified) {
            return card.damage;
        }
        return card.baseDamage;
    }

    public static int getCardMagicNumber(AbstractCard card) {
        if (card.isMagicNumberModified) {
            return card.magicNumber;
        }
        return card.baseMagicNumber;
    }

    public static String getCardTypeString(AbstractCard card) {
        switch (card.type) {
            case ATTACK: {
                return AbstractCard.TEXT[0];
            }
            case SKILL: {
                return AbstractCard.TEXT[1];
            }
            case POWER: {
                return AbstractCard.TEXT[2];
            }
            case CURSE: {
                return AbstractCard.TEXT[3];
            }
            case STATUS: {
                return AbstractCard.TEXT[7];
            }
        }
        return AbstractCard.TEXT[5];
    }

    public static String getCardRarityString(AbstractCard card) {
        AbstractCard.CardRarity rarity = card.rarity;
        if (rarity == null) {
            return null;
        }
        return Output.localization.localize("text.cardRarity." + rarity.name().toLowerCase(), new Object[0]);
    }

    public static String getCardShort(AbstractCard card) {
        if (card.isLocked) {
            return AbstractCard.LOCKED_STRING;
        }
        if (card.isFlipped) {
            return "face down card";
        }
        return card.name + ", " + CardUtils.getCardCostString(card);
    }

    public static GridPosition getGridPosition(AbstractCard card, ArrayList<AbstractCard> grid, int width) {
        if (grid == null) {
            return null;
        }
        int gridIndex = grid.indexOf(card);
        if (gridIndex < 0) {
            return null;
        }
        int row = gridIndex / width + 1;
        int column = gridIndex % width + 1;
        return new GridPosition(column, row);
    }
}

