/*
 * Decompiled with CFR 0.152.
 */
package sayTheSpire.ui.navigators;

import java.util.ArrayList;
import java.util.Stack;
import java.util.stream.Collectors;
import sayTheSpire.InfoControls;
import sayTheSpire.Output;
import sayTheSpire.localization.LocalizationContext;
import sayTheSpire.map.BaseMapEdge;
import sayTheSpire.map.VirtualMap;
import sayTheSpire.map.VirtualMapEdge;
import sayTheSpire.map.VirtualMapNode;
import sayTheSpire.ui.navigators.MapNavigator;

public class TreeNavigator
extends MapNavigator {
    private ArrayList<VirtualMapEdge> pathChoices = new ArrayList();
    private Stack<VirtualMapEdge> viewingPath = new Stack();
    private int pathChoice = -1;
    private LocalizationContext localization = Output.localization.getContext("map.navigators.tree");

    public TreeNavigator(VirtualMap map) {
        super(map);
    }

    public Boolean changePathChoice(int direction) {
        if (this.pathChoices.isEmpty()) {
            return false;
        }
        int target = this.pathChoice + direction;
        if (target < 0 || target >= this.pathChoices.size()) {
            return false;
        }
        this.pathChoice = target;
        return true;
    }

    @Override
    public void setViewingNode(VirtualMapNode node) {
        super.setViewingNode(node);
        this.pathChoices = (ArrayList)node.getEdges();
        if (!this.pathChoices.isEmpty()) {
            this.pathChoice = 0;
        }
    }

    private Stack<VirtualMapEdge> followBackwardPath() {
        Stack<VirtualMapEdge> path = new Stack<VirtualMapEdge>();
        if (this.getViewingNode() == null) {
            return path;
        }
        do {
            VirtualMapEdge edge = null;
            Object node = null;
            edge = !this.viewingPath.empty() ? this.viewingPath.pop().invert() : this.getMap().getParentEdge(this.getViewingNode());
            if (edge == null) {
                return path;
            }
            path.push(edge);
            this.setViewingNode(edge.getEnd());
        } while (this.pathChoices.size() == 1);
        return path;
    }

    private Stack<VirtualMapEdge> followForwardPath() {
        Stack<VirtualMapEdge> path = new Stack<VirtualMapEdge>();
        if (this.pathChoice < 0 || this.pathChoice >= this.pathChoices.size()) {
            return path;
        }
        do {
            VirtualMapEdge edge = this.pathChoices.get(this.pathChoice);
            this.pathChoice = 0;
            this.setViewingNode(edge.getEnd());
            path.push(edge);
            this.viewingPath.push(edge);
        } while (this.pathChoices.size() == 1);
        return path;
    }

    private void controlFollowPath(Boolean forward) {
        Stack<VirtualMapEdge> path = null;
        if (forward.booleanValue() && !this.pathChoices.isEmpty()) {
            path = this.followForwardPath();
        } else if (!forward.booleanValue()) {
            path = this.followBackwardPath();
        } else {
            return;
        }
        if (path.empty()) {
            Output.text(this.localization.localize("no path"), false);
            return;
        }
        StringBuilder pathText = new StringBuilder();
        pathText.append(path.stream().map(e -> e.getShort(false)).collect(Collectors.joining(", ")));
        if (this.pathChoices.size() > 1) {
            pathText.append("\n" + this.localization.localize("choice") + "\n");
            pathText.append(this.pathChoices.get(0).getShort(true));
        }
        Output.text(pathText.toString(), false);
    }

    @Override
    public void handleFocus(VirtualMapNode node, Boolean isHovered, Boolean shouldAnnounce) {
        if (node == null) {
            Output.text(this.localization.localize("error focus null"), false);
            return;
        }
        VirtualMapNode targetNode = node;
        VirtualMapNode playerNode = this.getMap().getPlayerNode();
        if (playerNode != null && isHovered.booleanValue()) {
            this.viewingPath.clear();
            this.setViewingNode(playerNode);
            BaseMapEdge edge = new BaseMapEdge(playerNode, node);
            this.pathChoice = this.pathChoices.indexOf(edge);
            if (this.pathChoice >= 0 && shouldAnnounce.booleanValue()) {
                Output.text(this.pathChoices.get(this.pathChoice).getShort(true), false);
            }
        } else {
            this.setViewingNode(node);
            this.pathChoice = -1;
            if (!this.pathChoices.isEmpty()) {
                this.pathChoice = 0;
            }
            if (shouldAnnounce.booleanValue()) {
                StringBuilder sb = new StringBuilder();
                sb.append(node.getShort());
                if (this.pathChoice >= 0) {
                    sb.append("\n" + this.localization.localize("choice") + "\n");
                    sb.append(this.pathChoices.get(this.pathChoice).getShort(true));
                }
                Output.text(sb.toString(), false);
            }
        }
    }

    @Override
    public void control(InfoControls.Direction direction) {
        switch (direction) {
            case UP: {
                this.controlFollowPath(true);
                return;
            }
            case DOWN: {
                this.controlFollowPath(false);
                return;
            }
            case LEFT: {
                if (this.changePathChoice(-1).booleanValue()) {
                    Output.text(this.pathChoices.get(this.pathChoice).getShort(true), false);
                }
                return;
            }
            case RIGHT: {
                if (this.changePathChoice(1).booleanValue()) {
                    Output.text(this.pathChoices.get(this.pathChoice).getShort(true), false);
                }
                return;
            }
        }
    }
}

