/*
 * Decompiled with CFR 0.152.
 */
package sayTheSpire.ui.mod;

import com.megacrit.cardcrawl.characters.AbstractPlayer;
import com.megacrit.cardcrawl.core.AbstractCreature;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.helpers.controller.CInputAction;
import com.megacrit.cardcrawl.monsters.AbstractMonster;
import com.megacrit.cardcrawl.ui.panels.EnergyPanel;
import java.util.ArrayList;
import sayTheSpire.InfoControls;
import sayTheSpire.Output;
import sayTheSpire.ui.elements.MonsterElement;
import sayTheSpire.ui.input.InputAction;
import sayTheSpire.ui.mod.Context;
import sayTheSpire.utils.MapUtils;
import sayTheSpire.utils.OutputUtils;

public class GameContext
extends Context {
    public GameContext() {
        this.shouldForceControllerMode = true;
    }

    private void readPlayerAttribute(String name) {
        AbstractPlayer player = OutputUtils.getPlayer();
        if (player == null) {
            Output.textLocalized("errors.not in run", (Boolean)false, new Object[0]);
            return;
        }
        switch (name) {
            case "read act boss": {
                Output.text(MapUtils.getLocalizedBossName(), false);
                return;
            }
            case "read player block": {
                if (OutputUtils.isInCombat().booleanValue()) {
                    Output.textLocalized("ui.misc info.playerBlock", (Boolean)false, "block", player.currentBlock);
                } else {
                    Output.textLocalized("errors.not in combat", (Boolean)false, new Object[0]);
                }
                return;
            }
            case "read player energy": {
                if (OutputUtils.isInCombat().booleanValue()) {
                    Output.textLocalized("ui.misc info.playerEnergy", (Boolean)false, "energy", EnergyPanel.totalCount);
                } else {
                    Output.textLocalized("errors.not in combat", (Boolean)false, new Object[0]);
                }
                return;
            }
            case "read player gold": {
                Output.textLocalized("ui.misc info.playerGold", (Boolean)false, "gold", player.gold);
                return;
            }
            case "read player hp": {
                Output.textLocalized("ui.misc info.playerHealth", (Boolean)false, "hp", player.currentHealth, "hpMax", player.maxHealth);
                return;
            }
            case "read player powers": {
                if (OutputUtils.isInCombat().booleanValue()) {
                    String powers = OutputUtils.getCreaturePowersString((AbstractCreature)OutputUtils.getPlayer());
                    Output.text(powers, false);
                    break;
                }
                Output.textLocalized("errors.not in combat", (Boolean)false, new Object[0]);
            }
        }
    }

    public void onClearJust() {
    }

    @Override
    public Boolean onJustPress(InputAction action) {
        Output.silenceSpeech();
        switch (action.getName()) {
            case "read act boss": 
            case "read player block": 
            case "read player energy": 
            case "read player gold": 
            case "read player hp": 
            case "read player powers": {
                this.readPlayerAttribute(action.getName());
                return true;
            }
            case "read summarized intents": {
                this.readSummarizedIntents();
                return true;
            }
            case "read detailed intents": {
                this.readDetailedIntents();
                return true;
            }
            case "inspect up": {
                InfoControls.infoControls(InfoControls.Direction.UP);
                break;
            }
            case "inspect down": {
                InfoControls.infoControls(InfoControls.Direction.DOWN);
                break;
            }
            case "inspect left": {
                InfoControls.infoControls(InfoControls.Direction.LEFT);
                break;
            }
            case "inspect right": {
                InfoControls.infoControls(InfoControls.Direction.RIGHT);
            }
        }
        CInputAction gameAction = action.getGameControllerAction();
        if (gameAction != null) {
            action.setGameControllerActionPressed(true);
            action.setGameControllerActionJustPressed(true);
        }
        return true;
    }

    @Override
    public Boolean onPress(InputAction action) {
        action.setGameControllerActionJustPressed(false);
        action.setGameControllerActionPressed(true);
        return true;
    }

    @Override
    public Boolean onJustRelease(InputAction action) {
        CInputAction gameAction = action.getGameControllerAction();
        if (gameAction != null) {
            action.setGameControllerActionJustReleased(true);
            action.setGameControllerActionPressed(false);
            action.setGameControllerActionJustPressed(false);
        }
        return true;
    }

    private void readSummarizedIntents() {
        if (!OutputUtils.isInCombat().booleanValue()) {
            Output.textLocalized("errors.not in combat", (Boolean)false, new Object[0]);
            return;
        }
        if (OutputUtils.playerHasRelic("Runic Dome").booleanValue()) {
            Output.textLocalized("ui.misc info.hiddenIntents", (Boolean)false, new Object[0]);
            return;
        }
        int totalDmg = 0;
        for (AbstractMonster m : AbstractDungeon.getCurrRoom().monsters.monsters) {
            MonsterElement monster = new MonsterElement(m);
            if (!monster.isInCombat().booleanValue()) continue;
            if (monster.isMultiDmg().booleanValue()) {
                totalDmg += monster.getIntentDmg() * monster.getIntentMultiAmt();
                continue;
            }
            totalDmg += monster.getIntentDmg();
        }
        Output.textLocalized("ui.misc info.incomingDamage", (Boolean)false, "damage", totalDmg);
    }

    private void readDetailedIntents() {
        MonsterElement monster;
        if (!OutputUtils.isInCombat().booleanValue()) {
            Output.textLocalized("errors.not in combat", (Boolean)false, new Object[0]);
            return;
        }
        if (OutputUtils.playerHasRelic("Runic Dome").booleanValue()) {
            Output.textLocalized("ui.misc info.hiddenIntents", (Boolean)false, new Object[0]);
            return;
        }
        StringBuilder sb = new StringBuilder();
        ArrayList<MonsterElement> aliveMonsters = new ArrayList<MonsterElement>();
        for (AbstractMonster m : AbstractDungeon.getCurrRoom().monsters.monsters) {
            monster = new MonsterElement(m);
            if (!monster.isInCombat().booleanValue()) continue;
            aliveMonsters.add(monster);
        }
        int monsterCount = aliveMonsters.size();
        if (monsterCount == 0) {
            Output.textLocalized("ui.misc info.noMonsters", (Boolean)false, new Object[0]);
            return;
        }
        for (int c = 0; c < monsterCount; ++c) {
            monster = (MonsterElement)aliveMonsters.get(c);
            sb.append(monster.getName() + " " + monster.getIntentShort());
            if (c >= monsterCount - 1) continue;
            sb.append(", ");
        }
        Output.text(sb.toString(), false);
    }
}

