/*
 * Decompiled with CFR 0.152.
 */
package sayTheSpire.ui.input;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import sayTheSpire.ui.input.InputMapping;

public class MappingBuilder {
    private HashMap<String, ArrayList<InputMapping>> mappings = new HashMap();
    private InputMapping lastMapping = null;
    private ArrayList<InputMapping> currentActionList = null;
    private String currentActionName = null;
    private String defaultInputType = "keyboard";
    private Boolean isDefault = false;

    public MappingBuilder action(String name) {
        if (!this.mappings.containsKey(name)) {
            this.mappings.put(name, new ArrayList());
        }
        this.currentActionName = name;
        this.currentActionList = this.mappings.get(name);
        return this;
    }

    public MappingBuilder mapping(Integer ... keys) {
        InputMapping mapping;
        if (this.currentActionList == null) {
            throw new RuntimeException("MappingBuilder: Tried to add mapping to null action.");
        }
        if (keys.length <= 0) {
            throw new RuntimeException("MappingBuilder: empty mapping specified.");
        }
        HashSet<Integer> mappingCodes = new HashSet<Integer>(Arrays.asList(keys));
        this.lastMapping = mapping = new InputMapping(this.currentActionName, this.defaultInputType, this.isDefault, mappingCodes);
        this.currentActionList.add(mapping);
        return this;
    }

    public MappingBuilder setDefaultInputType(String type) {
        this.defaultInputType = type;
        return this;
    }

    public MappingBuilder setIsDefault(Boolean value) {
        this.isDefault = value;
        return this;
    }

    public HashMap<String, ArrayList<InputMapping>> toHashMap() {
        return this.mappings;
    }
}

