/*
 * Decompiled with CFR 0.152.
 */
package sayTheSpire.ui.input;

import com.badlogic.gdx.Gdx;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import sayTheSpire.Output;
import sayTheSpire.ui.input.InputAction;
import sayTheSpire.ui.input.InputActionCollection;
import sayTheSpire.ui.input.InputMapping;

public class InputManager {
    private static final Logger logger = LogManager.getLogger((String)InputManager.class.getName());
    private HashMap<String, InputAction> actions;
    private HashMap<Integer, Boolean> controllerPressed;
    private HashMap<Integer, Boolean> keyboardPressed;
    private HashSet<Integer> keysToCheck;
    private HashSet<InputMapping.Modifiers> keyboardPressedModifiers;
    private InputActionCollection actionCollection;
    static final String[] actionNames = new String[]{"select", "cancel", "top panel", "proceed", "peek", "page left", "page right", "draw pile", "discard pile", "map", "settings", "up", "down", "left", "right", "alt up", "alt down", "alt left", "alt right", "inspect up", "inspect down", "inspect left", "inspect right", "read player block", "read player energy", "read player gold", "read player hp", "read summarized intents", "read player powers", "read detailed intents", "read act boss"};

    public InputManager(JsonObject inputObj) {
        this.actionCollection = inputObj != null ? new InputActionCollection(this, inputObj) : new InputActionCollection(this);
        this.keysToCheck = new HashSet();
        this.controllerPressed = new HashMap();
        this.keyboardPressed = new HashMap();
        this.keyboardPressedModifiers = new HashSet();
        this.determineKeysToCheck();
    }

    public InputManager() {
        this(null);
    }

    public void clearActionStates() {
        if (this.controllerPressed != null) {
            this.controllerPressed.clear();
        }
        if (this.keyboardPressed != null) {
            this.keyboardPressed.clear();
        }
        for (InputAction action : this.actionCollection.getActions()) {
            action.clearStates();
        }
    }

    public InputActionCollection getActionCollection() {
        return this.actionCollection;
    }

    private void determineKeysToCheck() {
        this.keysToCheck.clear();
        for (InputAction action : this.actionCollection.getActions()) {
            for (InputMapping mapping : action.getMappings()) {
                int keycode = mapping.getKeycode();
                this.keysToCheck.add(keycode);
            }
        }
    }

    public void handleControllerKeycodePress(int keycode) {
        this.controllerPressed.put(keycode, true);
    }

    public void handleControllerKeycodeRelease(int keycode) {
        this.controllerPressed.remove(keycode);
    }

    private Boolean isMappingJustPressedController(InputMapping mapping) {
        int keycode = mapping.getKeycode();
        return this.controllerPressed.getOrDefault(keycode, false);
    }

    private Boolean isMappingPressedController(InputMapping mapping) {
        int keycode = mapping.getKeycode();
        return this.controllerPressed.containsKey(keycode);
    }

    private Boolean isMappingJustPressedKeyboard(InputMapping mapping) {
        return mapping.getModifiers().equals(this.keyboardPressedModifiers) && this.keyboardPressed.getOrDefault(mapping.getKeycode(), false) != false;
    }

    private Boolean isMappingPressedKeyboard(InputMapping mapping) {
        return mapping.getModifiers().equals(this.keyboardPressedModifiers) && this.keyboardPressed.containsKey(mapping.getKeycode());
    }

    public Boolean isMappingJustPressed(InputMapping mapping) {
        switch (mapping.getInputType()) {
            case "controller": {
                return this.isMappingJustPressedController(mapping);
            }
            case "keyboard": {
                return this.isMappingJustPressedKeyboard(mapping);
            }
        }
        return false;
    }

    public Boolean isMappingPressed(InputMapping mapping) {
        switch (mapping.getInputType()) {
            case "controller": {
                return this.isMappingPressedController(mapping);
            }
            case "keyboard": {
                return this.isMappingPressedKeyboard(mapping);
            }
        }
        return false;
    }

    private void updateKeyboardState() {
        this.keyboardPressedModifiers.clear();
        if (Gdx.input.isKeyPressed(129) || Gdx.input.isKeyPressed(130)) {
            this.keyboardPressedModifiers.add(InputMapping.Modifiers.CONTROL);
        }
        if (Gdx.input.isKeyPressed(59) || Gdx.input.isKeyPressed(60)) {
            this.keyboardPressedModifiers.add(InputMapping.Modifiers.SHIFT);
        }
        if (Gdx.input.isKeyPressed(57) || Gdx.input.isKeyPressed(58)) {
            this.keyboardPressedModifiers.add(InputMapping.Modifiers.ALT);
        }
        for (int keycode : this.keysToCheck) {
            if (Gdx.input.isKeyPressed(keycode)) {
                this.keyboardPressed.put(keycode, Gdx.input.isKeyJustPressed(keycode));
                continue;
            }
            this.keyboardPressed.remove(keycode);
        }
    }

    public void updateFirst() {
        if (!Output.config.getBoolean("input.virtual_input").booleanValue()) {
            return;
        }
        this.updateKeyboardState();
        for (InputAction action : this.actionCollection.getActions()) {
            action.update();
        }
    }

    public void updateLast() {
        if (!Output.config.getBoolean("input.virtual_input").booleanValue()) {
            return;
        }
        for (Map.Entry<Integer, Boolean> entry : this.controllerPressed.entrySet()) {
            if (!entry.getValue().booleanValue()) continue;
            entry.setValue(false);
        }
    }
}

