/*
 * Decompiled with CFR 0.152.
 */
package sayTheSpire.ui.input;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.megacrit.cardcrawl.helpers.Prefs;
import com.megacrit.cardcrawl.helpers.SaveHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import sayTheSpire.ui.input.InputAction;
import sayTheSpire.ui.input.InputManager;
import sayTheSpire.ui.input.InputMapping;
import sayTheSpire.ui.input.MappingBuilder;

public class InputActionCollection {
    private static final Prefs controllerPrefs = SaveHelper.getPrefs((String)"STSInputSettings_Controller");
    private InputManager inputManager;
    private HashMap<String, InputAction> actions;
    private HashMap<String, ArrayList<InputMapping>> defaults;

    public InputActionCollection(InputManager manager) {
        this.inputManager = manager;
        this.actions = new HashMap();
        this.defaults = this.getDefaults();
        this.setupActions(null);
    }

    public InputActionCollection(InputManager manager, JsonObject input) {
        this(manager);
        this.setupActions(input);
    }

    private void setupActions(JsonObject input) {
        for (String name : InputManager.actionNames) {
            JsonArray mappingsArray = null;
            if (input != null && input.has(name)) {
                mappingsArray = input.getAsJsonArray(name);
            }
            InputAction action = null;
            if (mappingsArray != null) {
                action = new InputAction(name, this.inputManager, mappingsArray);
            } else {
                action = new InputAction(name, this.inputManager);
                action.setMappings(this.defaults.get(name));
            }
            this.actions.put(name, action);
        }
    }

    private void buildKeyboardDefaults(MappingBuilder builder) {
        builder.setDefaultInputType("keyboard").action("select").mapping(66).action("cancel").mapping(131).action("proceed").mapping(33).action("top panel").mapping(48).action("peek").mapping(52).action("page left").mapping(32).action("page right").mapping(34).action("draw pile").mapping(45).action("discard pile").mapping(51).action("map").mapping(41).action("settings").mapping(67).action("up").mapping(19).action("down").mapping(20).action("left").mapping(21).action("right").mapping(22).action("inspect up").mapping(129, 19).action("inspect down").mapping(129, 20).action("inspect left").mapping(129, 21).action("inspect right").mapping(129, 22).action("read player block").mapping(129, 30).action("read player energy").mapping(129, 53).action("read player gold").mapping(129, 35).action("read player hp").mapping(129, 36).action("read summarized intents").mapping(129, 37).action("read detailed intents").mapping(57, 37).action("read act boss").mapping(129, 42).action("read player powers").mapping(129, 44);
    }

    private void buildControllerDefaults(MappingBuilder builder) {
        builder.setDefaultInputType("controller").action("select").mapping(controllerPrefs.getInteger("SELECT", 0)).action("cancel").mapping(controllerPrefs.getInteger("CANCEL", 1)).action("top panel").mapping(controllerPrefs.getInteger("VIEW", 2)).action("proceed").mapping(controllerPrefs.getInteger("PROCEED", 3)).action("peek").mapping(controllerPrefs.getInteger("PEEK", 8)).action("page left").mapping(controllerPrefs.getInteger("PAGE_LEFT_KEY", 4)).action("page right").mapping(controllerPrefs.getInteger("PAGE_RIGHT_KEY", 5)).action("draw pile").mapping(controllerPrefs.getInteger("DRAW_PILE", 1004)).action("discard pile").mapping(controllerPrefs.getInteger("DISCARD_PILE", -1004)).action("map").mapping(controllerPrefs.getInteger("MAP", 6)).action("settings").mapping(controllerPrefs.getInteger("SETTINGS", 7)).action("up").mapping(controllerPrefs.getInteger("LS_Y_POSITIVE", -1000)).action("down").mapping(controllerPrefs.getInteger("LS_Y_NEGATIVE", 1000)).action("left").mapping(controllerPrefs.getInteger("LS_X_NEGATIVE", -1001)).action("right").mapping(controllerPrefs.getInteger("LS_X_POSITIVE", 1001)).action("inspect up").mapping(controllerPrefs.getInteger("RS_Y_POSITIVE", -1002)).action("inspect down").mapping(controllerPrefs.getInteger("RS_Y_NEGATIVE", 1002)).action("inspect left").mapping(controllerPrefs.getInteger("RS_X_POSITIVE", -1003)).action("inspect right").mapping(controllerPrefs.getInteger("RS_X_NEGATIVE", 1003)).action("alt up").mapping(controllerPrefs.getInteger("D_NORTH", -2000)).action("alt down").mapping(controllerPrefs.getInteger("D_SOUTH", 2000)).action("alt left").mapping(controllerPrefs.getInteger("D_WEST", -2001)).action("alt right").mapping(controllerPrefs.getInteger("D_EAST", 2001));
    }

    private HashMap<String, ArrayList<InputMapping>> getDefaults() {
        MappingBuilder builder = new MappingBuilder();
        builder.setIsDefault(true);
        this.buildKeyboardDefaults(builder);
        this.buildControllerDefaults(builder);
        return builder.toHashMap();
    }

    public Collection<InputAction> getActions() {
        return this.actions.values();
    }

    public JsonElement toJsonElement() {
        JsonObject obj = new JsonObject();
        for (InputAction action : this.actions.values()) {
            obj.add(action.getName(), action.toJsonElement());
        }
        return obj;
    }
}

