/*
 * Decompiled with CFR 0.152.
 */
package sayTheSpire.ui.input;

import basemod.ReflectionHacks;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.megacrit.cardcrawl.helpers.controller.CInputAction;
import com.megacrit.cardcrawl.helpers.controller.CInputActionSet;
import java.util.ArrayList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import sayTheSpire.Output;
import sayTheSpire.ui.input.InputManager;
import sayTheSpire.ui.input.InputMapping;

public class InputAction {
    private static final Logger logger = LogManager.getLogger((String)InputAction.class.getName());
    private String name;
    private InputManager inputManager;
    private Boolean isJustPressed;
    private Boolean isPressed;
    private Boolean isJustReleased;
    private ArrayList<InputMapping> mappings;

    public InputAction(String name, InputManager inputManager) {
        this.name = name;
        this.mappings = new ArrayList();
        this.inputManager = inputManager;
        this.isJustPressed = false;
        this.isPressed = false;
        this.isJustReleased = false;
    }

    public InputAction(String name, InputManager manager, JsonArray mappings) {
        this(name, manager);
        for (JsonElement mappingElement : mappings) {
            InputMapping mapping = new InputMapping(mappingElement.getAsJsonObject());
            this.mappings.add(mapping);
        }
    }

    public void clearStates() {
        this.isJustPressed = false;
        this.isPressed = false;
        this.isJustReleased = false;
        this.setGameControllerActionJustPressed(false);
        this.setGameControllerActionPressed(false);
        this.setGameControllerActionJustReleased(false);
    }

    public CInputAction getGameControllerAction() {
        switch (this.name) {
            case "select": {
                return CInputActionSet.select;
            }
            case "cancel": {
                return CInputActionSet.cancel;
            }
            case "top panel": {
                return CInputActionSet.topPanel;
            }
            case "proceed": {
                return CInputActionSet.proceed;
            }
            case "peek": {
                return CInputActionSet.peek;
            }
            case "page left": {
                return CInputActionSet.pageLeftViewDeck;
            }
            case "page right": {
                return CInputActionSet.pageRightViewExhaust;
            }
            case "draw pile": {
                return CInputActionSet.drawPile;
            }
            case "discard pile": {
                return CInputActionSet.discardPile;
            }
            case "map": {
                return CInputActionSet.map;
            }
            case "settings": {
                return CInputActionSet.settings;
            }
            case "up": {
                return CInputActionSet.up;
            }
            case "down": {
                return CInputActionSet.down;
            }
            case "left": {
                return CInputActionSet.left;
            }
            case "right": {
                return CInputActionSet.right;
            }
            case "inspect up": {
                return CInputActionSet.inspectUp;
            }
            case "inspect down": {
                return CInputActionSet.inspectDown;
            }
            case "inspect left": {
                return CInputActionSet.inspectLeft;
            }
            case "inspect right": {
                return CInputActionSet.inspectRight;
            }
            case "alt up": {
                return CInputActionSet.altUp;
            }
            case "alt down": {
                return CInputActionSet.altDown;
            }
            case "alt left": {
                return CInputActionSet.altLeft;
            }
            case "alt right": {
                return CInputActionSet.altRight;
            }
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public ArrayList<InputMapping> getMappings() {
        return this.mappings;
    }

    public Boolean isPressed() {
        return this.isPressed;
    }

    public Boolean isJustPressed() {
        return this.isJustPressed;
    }

    public Boolean isJustReleased() {
        return this.isJustReleased;
    }

    public void setGameControllerActionJustPressed(Boolean value) {
        CInputAction gameAction = this.getGameControllerAction();
        if (gameAction != null) {
            ReflectionHacks.setPrivate((Object)gameAction, CInputAction.class, (String)"justPressed", (Object)value);
        }
    }

    public void setGameControllerActionPressed(Boolean value) {
        CInputAction gameAction = this.getGameControllerAction();
        if (gameAction != null) {
            ReflectionHacks.setPrivate((Object)gameAction, CInputAction.class, (String)"pressed", (Object)value);
        }
    }

    public void setGameControllerActionJustReleased(Boolean value) {
        CInputAction gameAction = this.getGameControllerAction();
        if (gameAction != null) {
            ReflectionHacks.setPrivate((Object)gameAction, CInputAction.class, (String)"justReleased", (Object)value);
        }
    }

    void setMappings(ArrayList<InputMapping> mappings) {
        for (InputMapping mapping : mappings) {
            this.mappings.add(new InputMapping(mapping));
        }
    }

    private void updateStates() {
        for (InputMapping mapping : this.mappings) {
            if (!this.isPressed.booleanValue() && this.inputManager.isMappingJustPressed(mapping).booleanValue()) {
                this.isJustPressed = true;
                this.isPressed = true;
                this.isJustReleased = false;
                return;
            }
            if (!this.isJustPressed.booleanValue() || !this.inputManager.isMappingPressed(mapping).booleanValue()) continue;
            this.isJustPressed = false;
            this.isPressed = true;
            this.isJustReleased = false;
            return;
        }
        if (this.isPressed.booleanValue()) {
            this.isJustPressed = false;
            this.isPressed = false;
            this.isJustReleased = true;
        } else if (this.isJustReleased.booleanValue()) {
            this.isJustReleased = false;
        }
    }

    public void update() {
        this.updateStates();
        if (this.isJustPressed().booleanValue()) {
            Output.uiManager.emitAction(this, "justPressed");
        } else if (this.isPressed().booleanValue()) {
            Output.uiManager.emitAction(this, "pressed");
        } else if (this.isJustReleased().booleanValue()) {
            Output.uiManager.emitAction(this, "justReleased");
        }
    }

    public JsonElement toJsonElement() {
        JsonArray mappingsArray = new JsonArray();
        for (InputMapping mapping : this.getMappings()) {
            mappingsArray.add(mapping.toJsonElement());
        }
        return mappingsArray;
    }
}

