/*
 * Decompiled with CFR 0.152.
 */
package sayTheSpire.ui.elements;

import sayTheSpire.Output;
import sayTheSpire.buffers.BufferManager;
import sayTheSpire.localization.LocalizationContext;
import sayTheSpire.ui.positions.Position;

public abstract class UIElement {
    protected String elementType = null;
    protected Position position;
    protected final LocalizationContext localization;

    public UIElement(String type) {
        this(type, null);
    }

    public UIElement(String elementType, Position position) {
        this.elementType = elementType;
        this.position = position;
        this.localization = Output.localization.getContext("ui.elements." + elementType);
    }

    public abstract String handleBuffers(BufferManager var1);

    public void update() {
    }

    public String getElementType() {
        return this.elementType;
    }

    public String getFocusString() {
        Position position;
        String status;
        String type;
        String extras;
        StringBuilder sb = new StringBuilder();
        String label = this.getLabel();
        if (label != null) {
            sb.append(label);
        }
        if ((extras = this.getExtrasString()) != null) {
            sb.append(" " + extras);
        }
        if (Output.config.getBoolean("ui.read_types", true).booleanValue() && (type = this.getTypeString()) != null && !Output.config.getExcludedTypenames().contains(type)) {
            String localizedType = Output.localization.localize("ui.types." + type, new Object[0]);
            if (localizedType != null) {
                type = localizedType;
            }
            sb.append(" " + type);
        }
        if ((status = this.getStatusString()) != null) {
            sb.append(" " + status);
        }
        if (Output.config.getBoolean("ui.read_positions", true).booleanValue() && (position = this.getPosition()) != null) {
            sb.append(". " + position.getPositionString());
        }
        return sb.toString();
    }

    public Position getPosition() {
        return this.position;
    }

    public String getLabel() {
        return null;
    }

    public String getStatusString() {
        return null;
    }

    public String getExtrasString() {
        return null;
    }

    public String getTypeString() {
        return this.elementType;
    }
}

