/*
 * Decompiled with CFR 0.152.
 */
package sayTheSpire.ui.elements;

import sayTheSpire.Output;
import sayTheSpire.buffers.BufferManager;
import sayTheSpire.ui.elements.Descriptor;
import sayTheSpire.ui.elements.UIElement;

public class ToggleButtonElement
extends UIElement {
    private Descriptor descriptor;
    private Boolean enabled;
    private String enabledText;
    private String disabledText;

    public ToggleButtonElement() {
        this("unknown", false);
    }

    public ToggleButtonElement(String name, Boolean enabled) {
        this(name, name, null, enabled);
    }

    public ToggleButtonElement(String name, String label, Boolean enabled) {
        this(name, label, null, enabled);
    }

    public ToggleButtonElement(String name, String label, String description, Boolean enabled) {
        super("toggle button");
        this.descriptor = new Descriptor(name, label, description);
        this.enabled = enabled;
        this.setStatusTexts("on", "off");
    }

    @Override
    public String handleBuffers(BufferManager buffers) {
        Output.setupUIBuffer(this.descriptor.getUIBufferContents());
        return null;
    }

    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public String getLabel() {
        return this.getDescriptor().getName();
    }

    @Override
    public String getStatusString() {
        return Output.localization.localize("ui.status." + (this.getEnabled() != false ? this.enabledText : this.disabledText), new Object[0]);
    }

    public void setStatusTexts(String enabled, String disabled) {
        this.enabledText = enabled;
        this.disabledText = disabled;
    }
}

