/*
 * Decompiled with CFR 0.152.
 */
package sayTheSpire.ui.elements;

import basemod.ReflectionHacks;
import com.megacrit.cardcrawl.screens.mainMenu.SortHeaderButton;
import sayTheSpire.Output;
import sayTheSpire.buffers.BufferManager;
import sayTheSpire.ui.elements.UIElement;

public class SortHeaderButtonElement
extends UIElement {
    private SortHeaderButton button;
    private boolean isActive;
    private boolean isAscending;

    public SortHeaderButtonElement(SortHeaderButton button) {
        super("button");
        this.button = button;
        this.isActive = this.getIsActive();
        this.isAscending = this.getIsAscending();
    }

    @Override
    public String handleBuffers(BufferManager buffers) {
        Output.setupUIBufferMany(this.getLabel(), this.getStatusString());
        return null;
    }

    @Override
    public void update() {
        boolean newIsActive = this.getIsActive();
        boolean newIsAscending = this.getIsAscending();
        if (newIsActive != this.isActive || newIsAscending != this.isAscending) {
            this.isActive = newIsActive;
            this.isAscending = newIsAscending;
            if (Output.currentUI == this) {
                Output.text(this.getStatusString(), false);
            }
        }
    }

    public boolean getIsActive() {
        return (Boolean)ReflectionHacks.getPrivate((Object)this.button, SortHeaderButton.class, (String)"isActive");
    }

    public boolean getIsAscending() {
        return (Boolean)ReflectionHacks.getPrivate((Object)this.button, SortHeaderButton.class, (String)"isAscending");
    }

    @Override
    public String getLabel() {
        String name = (String)ReflectionHacks.getPrivate((Object)this.button, SortHeaderButton.class, (String)"text");
        return name;
    }

    @Override
    public String getStatusString() {
        String status = !this.isActive ? this.localization.localize(".ui.status.disabled") : (this.isAscending ? "ascending" : "descending");
        return this.localization.localize(".ui.status." + status);
    }
}

