/*
 * Decompiled with CFR 0.152.
 */
package sayTheSpire.ui.elements;

import basemod.ReflectionHacks;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.localization.TutorialStrings;
import com.megacrit.cardcrawl.localization.UIStrings;
import com.megacrit.cardcrawl.screens.options.Slider;
import java.text.DecimalFormat;
import sayTheSpire.Output;
import sayTheSpire.TextParser;
import sayTheSpire.buffers.BufferManager;
import sayTheSpire.ui.elements.UIElement;

public class SliderElement
extends UIElement {
    private static final TutorialStrings tutorialStrings = CardCrawlGame.languagePack.getTutorialString("Options Tip");
    public static final String[] MSG = SliderElement.tutorialStrings.TEXT;
    public static final String[] LABEL = SliderElement.tutorialStrings.LABEL;
    private static final UIStrings uiStrings = CardCrawlGame.languagePack.getUIString("OptionsPanel");
    public static final String[] TEXT = SliderElement.uiStrings.TEXT;
    private static DecimalFormat df = new DecimalFormat("#");
    private Slider slider;
    private Slider.SliderType type;

    public SliderElement(Slider slider) {
        super("slider");
        this.slider = slider;
        this.type = (Slider.SliderType)ReflectionHacks.getPrivate((Object)slider, Slider.class, (String)"type");
    }

    public void onVolumeChange() {
        Output.text(this.getStatusString(), true);
    }

    @Override
    public String handleBuffers(BufferManager buffers) {
        return null;
    }

    @Override
    public String getLabel() {
        return this.getText();
    }

    public Slider getSlider() {
        return this.slider;
    }

    public String getText() {
        String[] volumes = TextParser.parse(TEXT[6]).split("\n");
        switch (this.type) {
            case MASTER: {
                return volumes[0];
            }
            case BGM: {
                return volumes[1];
            }
            case SFX: {
                return volumes[2];
            }
        }
        return this.localization.localize("unknownType");
    }

    @Override
    public String getStatusString() {
        this.localization.put("value", df.format(this.getVolume() * 100.0f));
        return this.localization.localize("statusString");
    }

    public float getVolume() {
        return ((Float)ReflectionHacks.getPrivate((Object)this.slider, Slider.class, (String)"volume")).floatValue();
    }
}

