/*
 * Decompiled with CFR 0.152.
 */
package sayTheSpire.ui.elements;

import basemod.ReflectionHacks;
import com.megacrit.cardcrawl.screens.runHistory.RunPathElement;
import java.lang.reflect.Method;
import sayTheSpire.Output;
import sayTheSpire.TextParser;
import sayTheSpire.buffers.BufferManager;
import sayTheSpire.ui.elements.UIElement;
import sayTheSpire.ui.positions.Position;

public class RunPathViewElement
extends UIElement {
    private RunPathElement element;

    public RunPathViewElement(RunPathElement element, Position position) {
        super("button", position);
        this.element = element;
    }

    @Override
    public String handleBuffers(BufferManager buffers) {
        Output.setupUIBufferMany(this.getLabel(), this.getTooltipText());
        return "UI";
    }

    @Override
    public String getLabel() {
        String floorFormat = (String)ReflectionHacks.getPrivateStatic(RunPathElement.class, (String)"TEXT_SIMPLE_FLOOR_FORMAT");
        int floor = (Integer)ReflectionHacks.getPrivate((Object)this.element, RunPathElement.class, (String)"floor");
        return String.format(floorFormat, floor);
    }

    public String getTooltipText() {
        try {
            Method method = this.element.getClass().getDeclaredMethod("getTipDescriptionText", new Class[0]);
            method.setAccessible(true);
            return TextParser.parse((String)method.invoke((Object)this.element, new Object[0]));
        }
        catch (Exception e) {
            return "tooltip text broke";
        }
    }

    @Override
    public String getTypeString() {
        return null;
    }
}

