/*
 * Decompiled with CFR 0.152.
 */
package sayTheSpire.ui.elements;

import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.rewards.RewardItem;
import sayTheSpire.buffers.BufferManager;
import sayTheSpire.ui.elements.ButtonElement;
import sayTheSpire.ui.elements.PotionElement;
import sayTheSpire.ui.elements.RelicElement;
import sayTheSpire.ui.elements.UIElement;
import sayTheSpire.ui.positions.ListPosition;
import sayTheSpire.ui.positions.Position;

public class RewardItemElement
extends UIElement {
    private RewardItem reward;
    private UIElement rewardUIElement;

    public RewardItemElement(RewardItem reward) {
        super("button");
        this.reward = reward;
        this.setupUIElement();
    }

    @Override
    public String handleBuffers(BufferManager buffers) {
        return this.rewardUIElement.handleBuffers(buffers);
    }

    private void setupUIElement() {
        switch (this.reward.type) {
            case POTION: {
                this.rewardUIElement = new PotionElement(this.reward.potion, PotionElement.PotionLocation.COMBAT_REWARDS);
                break;
            }
            case RELIC: {
                this.rewardUIElement = new RelicElement(this.reward.relic, RelicElement.RelicLocation.COMBAT_REWARDS);
                break;
            }
            default: {
                this.rewardUIElement = new ButtonElement(this.reward.text);
            }
        }
    }

    @Override
    public String getLabel() {
        return this.rewardUIElement.getLabel();
    }

    @Override
    public Position getPosition() {
        if (AbstractDungeon.combatRewardScreen == null || AbstractDungeon.combatRewardScreen.rewards == null) {
            return null;
        }
        int rewardCount = AbstractDungeon.combatRewardScreen.rewards.size();
        for (int r = 0; r < rewardCount; ++r) {
            RewardItem reward = (RewardItem)AbstractDungeon.combatRewardScreen.rewards.get(r);
            if (reward != this.reward) continue;
            return new ListPosition(r, rewardCount);
        }
        return null;
    }
}

