/*
 * Decompiled with CFR 0.152.
 */
package sayTheSpire.ui.elements;

import com.megacrit.cardcrawl.characters.AbstractPlayer;
import com.megacrit.cardcrawl.relics.AbstractRelic;
import sayTheSpire.buffers.BufferManager;
import sayTheSpire.ui.elements.GameObjectElement;
import sayTheSpire.ui.positions.ListPosition;
import sayTheSpire.ui.positions.Position;
import sayTheSpire.utils.OutputUtils;

public class RelicElement
extends GameObjectElement {
    private AbstractRelic relic;
    private RelicLocation location;

    public RelicElement(AbstractRelic relic, RelicLocation location) {
        this(relic, location, null);
    }

    public RelicElement(AbstractRelic relic, RelicLocation location, Position position) {
        super("relic", position);
        this.relic = relic;
        this.location = location;
    }

    @Override
    public String handleBuffers(BufferManager buffers) {
        buffers.getBuffer("relic").setObject(this.relic);
        buffers.enableBuffer("relic", true);
        return "relic";
    }

    @Override
    public String getExtrasString() {
        String extras = "";
        if (this.relic.counter >= 0) {
            this.localization.put("counter", this.relic.counter);
            extras = this.localization.localize("counterString");
        }
        if (this.location == RelicLocation.SHOP) {
            extras = extras + " " + this.getPriceString();
            return extras;
        }
        if (extras.isEmpty()) {
            return null;
        }
        return extras;
    }

    @Override
    public String getLabel() {
        return this.relic.name;
    }

    @Override
    public Position getPosition() {
        switch (this.location) {
            case MAIN_SCREEN: {
                return this.getInventoryPosition();
            }
        }
        return super.getPosition();
    }

    public Position getInventoryPosition() {
        AbstractPlayer player = OutputUtils.getPlayer();
        if (player == null) {
            return null;
        }
        int relicCount = player.relics.size();
        for (int r = 0; r < relicCount; ++r) {
            if (this.relic != player.relics.get(r)) continue;
            return new ListPosition(r, relicCount);
        }
        return null;
    }

    public static enum RelicLocation {
        MAIN_SCREEN,
        COMPENDIUM,
        BOSS_REWARDS,
        COMBAT_REWARDS,
        SHOP,
        OTHER;

    }
}

