/*
 * Decompiled with CFR 0.152.
 */
package sayTheSpire.ui.elements;

import com.megacrit.cardcrawl.characters.AbstractPlayer;
import com.megacrit.cardcrawl.potions.AbstractPotion;
import sayTheSpire.buffers.BufferManager;
import sayTheSpire.ui.elements.GameObjectElement;
import sayTheSpire.ui.positions.ListPosition;
import sayTheSpire.ui.positions.Position;
import sayTheSpire.utils.OutputUtils;

public class PotionElement
extends GameObjectElement {
    protected AbstractPotion potion;
    protected PotionLocation location;

    public PotionElement(AbstractPotion potion, PotionLocation location) {
        this(potion, location, null);
    }

    public PotionElement(AbstractPotion potion, PotionLocation location, Position position) {
        super("potion", position);
        this.potion = potion;
        this.location = location;
    }

    @Override
    public String getExtrasString() {
        if (this.location == PotionLocation.SHOP) {
            return this.getPriceString();
        }
        return null;
    }

    @Override
    public String getLabel() {
        return this.potion.name;
    }

    @Override
    public Position getPosition() {
        switch (this.location) {
            case MAIN_SCREEN: {
                return this.getInventoryPosition();
            }
        }
        return super.getPosition();
    }

    public Position getInventoryPosition() {
        AbstractPlayer player = OutputUtils.getPlayer();
        if (player == null) {
            return null;
        }
        int index = player.potions.indexOf(this.potion);
        if (index < 0 || index >= player.potionSlots) {
            return null;
        }
        return new ListPosition(index, player.potionSlots);
    }

    @Override
    public String handleBuffers(BufferManager buffers) {
        buffers.getBuffer("potion").setObject(this.potion);
        buffers.enableBuffer("potion", true);
        return "potion";
    }

    public static enum PotionLocation {
        MAIN_SCREEN,
        COMBAT_REWARDS,
        COMPENDIUM,
        SHOP,
        OTHER;

    }
}

