/*
 * Decompiled with CFR 0.152.
 */
package sayTheSpire.ui.elements;

import basemod.ReflectionHacks;
import com.megacrit.cardcrawl.core.AbstractCreature;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.helpers.PowerTip;
import com.megacrit.cardcrawl.localization.UIStrings;
import com.megacrit.cardcrawl.monsters.AbstractMonster;
import com.megacrit.cardcrawl.monsters.MonsterGroup;
import java.util.ArrayList;
import sayTheSpire.TextParser;
import sayTheSpire.buffers.BufferManager;
import sayTheSpire.ui.elements.UIElement;
import sayTheSpire.ui.positions.ListPosition;
import sayTheSpire.ui.positions.Position;
import sayTheSpire.utils.MonsterUtils;
import sayTheSpire.utils.OutputUtils;

public class MonsterElement
extends UIElement {
    private static final UIStrings uiStrings = CardCrawlGame.languagePack.getUIString("AbstractMonster");
    public static final String[] TEXT = MonsterElement.uiStrings.TEXT;
    private AbstractMonster monster;

    public MonsterElement(AbstractMonster monster) {
        this(monster, null);
    }

    public MonsterElement(AbstractMonster monster, Position position) {
        super("monster", position);
        this.monster = monster;
    }

    @Override
    public String handleBuffers(BufferManager buffers) {
        buffers.getBuffer("monster").setObject(this);
        buffers.enableBuffer("monster", true);
        return "monster";
    }

    public int getCurrentBlock() {
        return this.monster.currentBlock;
    }

    public int getCurrentHealth() {
        return this.monster.currentHealth;
    }

    public int getMaxHealth() {
        return this.monster.maxHealth;
    }

    public String getIntentDmgString() {
        if (this.isMultiDmg().booleanValue()) {
            return this.getIntentDmg() + "x" + this.getIntentMultiAmt();
        }
        return Integer.toString(this.getIntentDmg());
    }

    public int getIntentDmg() {
        if (OutputUtils.playerHasRelic("Runic Dome").booleanValue()) {
            return 0;
        }
        switch (this.monster.intent) {
            case ATTACK: 
            case ATTACK_BUFF: 
            case ATTACK_DEBUFF: 
            case ATTACK_DEFEND: {
                break;
            }
            default: {
                return 0;
            }
        }
        return this.monster.getIntentDmg();
    }

    public String getIntentLong() {
        if (OutputUtils.playerHasRelic("Runic Dome").booleanValue()) {
            return this.localization.localize("hidden intent");
        }
        PowerTip tip = (PowerTip)ReflectionHacks.getPrivate((Object)this.monster, AbstractMonster.class, (String)"intentTip");
        return TextParser.parse(tip.body);
    }

    public int getIntentMultiAmt() {
        if (OutputUtils.playerHasRelic("Runic Dome").booleanValue()) {
            return 0;
        }
        switch (this.monster.intent) {
            case ATTACK: 
            case ATTACK_BUFF: 
            case ATTACK_DEBUFF: 
            case ATTACK_DEFEND: {
                break;
            }
            default: {
                return 0;
            }
        }
        return (Integer)ReflectionHacks.getPrivate((Object)this.monster, AbstractMonster.class, (String)"intentMultiAmt");
    }

    public String getIntentShort() {
        if (OutputUtils.playerHasRelic("Runic Dome").booleanValue()) {
            return this.localization.localize("hidden intent");
        }
        switch (this.monster.intent) {
            case ATTACK: {
                return TEXT[0] + " " + this.getIntentDmgString();
            }
            case ATTACK_BUFF: {
                return TEXT[6] + " " + this.getIntentDmgString();
            }
            case ATTACK_DEBUFF: {
                return TEXT[10] + " " + this.getIntentDmgString();
            }
            case ATTACK_DEFEND: {
                return TEXT[0] + " " + this.getIntentDmgString();
            }
            case BUFF: 
            case DEBUFF: 
            case STRONG_DEBUFF: {
                return TEXT[10];
            }
            case DEBUG: 
            case DEFEND: 
            case DEFEND_DEBUFF: 
            case DEFEND_BUFF: {
                return TEXT[13];
            }
            case ESCAPE: {
                return TEXT[14];
            }
            case MAGIC: {
                return TEXT[15];
            }
            case NONE: {
                return TEXT[16];
            }
            case SLEEP: {
                return TEXT[17];
            }
            case STUN: {
                return TEXT[18];
            }
        }
        return "";
    }

    @Override
    public String getLabel() {
        this.localization.put("monster", this.getName());
        this.localization.put("intent", this.getIntentShort());
        this.localization.put("block", this.monster.currentBlock);
        this.localization.put("currentHealth", this.monster.currentHealth);
        this.localization.put("maxHealth", this.monster.maxHealth);
        return this.localization.localize("shortString");
    }

    public AbstractMonster getMonster() {
        return this.monster;
    }

    public String getName() {
        return MonsterUtils.getName(this.monster);
    }

    @Override
    public Position getPosition() {
        MonsterGroup group = AbstractDungeon.getCurrRoom().monsters;
        if (group == null) {
            return null;
        }
        int index = group.monsters.indexOf(this.monster);
        if (index < 0) {
            return null;
        }
        return new ListPosition(index, group.monsters.size());
    }

    public Boolean isInCombat() {
        return !this.monster.isDead && !this.monster.escaped;
    }

    public Boolean isMultiDmg() {
        return (Boolean)ReflectionHacks.getPrivate((Object)this.monster, AbstractMonster.class, (String)"isMultiDmg");
    }

    public String getPowersString() {
        return OutputUtils.getCreaturePowersString((AbstractCreature)this.getMonster());
    }

    public ArrayList<PowerTip> getTips() {
        return (ArrayList)ReflectionHacks.getPrivate((Object)this.monster, AbstractCreature.class, (String)"tips");
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof MonsterElement)) {
            return false;
        }
        return this.getMonster() == ((MonsterElement)other).getMonster();
    }
}

