/*
 * Decompiled with CFR 0.152.
 */
package sayTheSpire.ui.elements;

import com.megacrit.cardcrawl.screens.leaderboards.FilterButton;
import sayTheSpire.Output;
import sayTheSpire.buffers.BufferManager;
import sayTheSpire.buffers.LeaderboardBuffer;
import sayTheSpire.ui.elements.UIElement;
import sayTheSpire.ui.positions.Position;

public class LeaderboardFilterButtonElement
extends UIElement {
    private FilterButton button;
    private Boolean prevActive;

    public LeaderboardFilterButtonElement(FilterButton button, Position position) {
        super("toggle button", position);
        this.button = button;
        this.prevActive = button.active;
    }

    public FilterButton getButton() {
        return this.button;
    }

    @Override
    public String handleBuffers(BufferManager buffers) {
        Output.setupUIBufferMany(this.getLabel());
        return null;
    }

    @Override
    public void update() {
        Boolean currentActive;
        FilterButton button = this.getButton();
        if (button.hb.justHovered) {
            Output.setUI(this);
            LeaderboardBuffer buffer = (LeaderboardBuffer)Output.buffers.getBuffer("leaderboard");
            buffer.setEnabled(true);
        }
        if ((currentActive = this.getEnabled()) != this.prevActive) {
            if (button.hb.hovered) {
                Output.text(this.getStatusString(), false);
            }
            this.prevActive = currentActive;
        }
    }

    public Boolean getEnabled() {
        return this.getButton().active;
    }

    @Override
    public String getLabel() {
        return this.getButton().label;
    }

    @Override
    public String getStatusString() {
        return Output.localization.localize("ui.status." + (this.getEnabled() != false ? "selected" : "unselected"), new Object[0]);
    }
}

