/*
 * Decompiled with CFR 0.152.
 */
package sayTheSpire.ui.elements;

import basemod.ReflectionHacks;
import com.megacrit.cardcrawl.cards.AbstractCard;
import com.megacrit.cardcrawl.relics.AbstractRelic;
import com.megacrit.cardcrawl.ui.buttons.LargeDialogOptionButton;
import sayTheSpire.TextParser;
import sayTheSpire.buffers.Buffer;
import sayTheSpire.buffers.BufferManager;
import sayTheSpire.buffers.CardBuffer;
import sayTheSpire.buffers.RelicBuffer;
import sayTheSpire.ui.elements.UIElement;

public class LargeDialogOptionButtonElement
extends UIElement {
    private AbstractCard previewCard;
    private AbstractRelic previewRelic;
    private LargeDialogOptionButton button;
    private String msg;

    public LargeDialogOptionButtonElement(LargeDialogOptionButton button) {
        super("button");
        this.button = button;
        this.msg = TextParser.parse(button.msg);
        this.previewCard = (AbstractCard)ReflectionHacks.getPrivate((Object)button, LargeDialogOptionButton.class, (String)"cardToPreview");
        this.previewRelic = (AbstractRelic)ReflectionHacks.getPrivate((Object)button, LargeDialogOptionButton.class, (String)"relicToPreview");
    }

    @Override
    public String handleBuffers(BufferManager buffers) {
        buffers.setAllEnabled(false);
        Buffer UI = buffers.getBuffer("UI");
        UI.clear();
        UI.add(this.msg);
        UI.add("Accessibility Note: For card and relic previews, see other available buffers.");
        UI.setEnabled(true);
        if (this.previewCard != null) {
            CardBuffer cardBuffer = (CardBuffer)buffers.getBuffer("current card");
            cardBuffer.setObject(this.previewCard);
            cardBuffer.update();
            cardBuffer.setEnabled(true);
            CardBuffer upgradeBuffer = (CardBuffer)buffers.getBuffer("upgrade preview");
            upgradeBuffer.setObject(this.previewCard);
            upgradeBuffer.update();
            upgradeBuffer.setEnabled(true);
        }
        if (this.previewRelic != null) {
            RelicBuffer relicBuffer = (RelicBuffer)buffers.getBuffer("relic");
            relicBuffer.setObject(this.previewRelic);
            relicBuffer.update();
            relicBuffer.setEnabled(true);
        }
        return "UI";
    }

    @Override
    public String getLabel() {
        return this.msg;
    }
}

