/*
 * Decompiled with CFR 0.152.
 */
package sayTheSpire.ui.elements;

import basemod.ReflectionHacks;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.localization.UIStrings;
import com.megacrit.cardcrawl.screens.charSelect.CharacterOption;
import java.util.ArrayList;
import sayTheSpire.Output;
import sayTheSpire.TextParser;
import sayTheSpire.buffers.BufferManager;
import sayTheSpire.ui.elements.UIElement;

public class CharacterButtonElement
extends UIElement {
    private static final UIStrings uiStrings = CardCrawlGame.languagePack.getUIString("CharacterOption");
    public static final String[] TEXT = CharacterButtonElement.uiStrings.TEXT;
    private CharacterOption character;
    private String flavorText;

    public CharacterButtonElement(CharacterOption character) {
        super("character button");
        this.character = character;
        this.flavorText = (String)ReflectionHacks.getPrivate((Object)character, CharacterOption.class, (String)"flavorText");
        this.localization.put("health", ReflectionHacks.getPrivate((Object)character, CharacterOption.class, (String)"hp"));
        this.localization.put("gold", ReflectionHacks.getPrivate((Object)character, CharacterOption.class, (String)"gold"));
        this.localization.put("unlocksRemaining", ReflectionHacks.getPrivate((Object)character, CharacterOption.class, (String)"unlocksRemaining"));
        this.localization.put("maxAscension", ReflectionHacks.getPrivate((Object)character, CharacterOption.class, (String)"maxAscensionLevel"));
    }

    private String getUnlockText() {
        switch (this.character.c.chosenClass) {
            case THE_SILENT: {
                return TEXT[1];
            }
            case DEFECT: {
                return TEXT[3];
            }
            case WATCHER: {
                return TEXT[10];
            }
        }
        return this.localization.localize("unknown unlock");
    }

    @Override
    public String handleBuffers(BufferManager buffers) {
        if (this.character.locked) {
            Output.setupUIBufferMany(TEXT[0], this.getUnlockText());
        } else {
            ArrayList<String> buffer = new ArrayList<String>();
            buffer.add(this.character.c.title);
            buffer.add(this.localization.localize("buffer health"));
            buffer.add(this.localization.localize("buffer gold"));
            buffer.add(TextParser.parse(this.flavorText));
            buffer.add(this.localization.localize("buffer unlocks remaining"));
            buffer.add(this.localization.localize("buffer max ascension"));
            Output.setupUIBuffer(buffer);
        }
        return "UI";
    }

    @Override
    public String getLabel() {
        if (this.character.locked) {
            return TEXT[0];
        }
        return this.character.c.title;
    }
}

