/*
 * Decompiled with CFR 0.152.
 */
package sayTheSpire.ui.elements;

import basemod.ReflectionHacks;
import com.megacrit.cardcrawl.cards.AbstractCard;
import com.megacrit.cardcrawl.cards.CardGroup;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.screens.select.HandCardSelectScreen;
import java.util.ArrayList;
import sayTheSpire.buffers.BufferManager;
import sayTheSpire.ui.elements.GameObjectElement;
import sayTheSpire.ui.positions.ListPosition;
import sayTheSpire.ui.positions.Position;
import sayTheSpire.utils.CardUtils;
import sayTheSpire.utils.OutputUtils;

public class CardElement
extends GameObjectElement {
    protected AbstractCard card;
    private CardLocation location;

    public CardElement(AbstractCard card) {
        this(card, CardLocation.OTHER);
    }

    public CardElement(AbstractCard card, CardLocation location) {
        this(card, location, null);
    }

    public CardElement(AbstractCard card, CardLocation location, Position position) {
        super("card", position);
        this.card = card;
        this.location = location;
    }

    @Override
    public String handleBuffers(BufferManager buffers) {
        buffers.getBuffer("current card").setObject(this.card);
        buffers.getBuffer("upgrade preview").setObject(this.card);
        buffers.enableBuffer("current card", true);
        buffers.enableBuffer("upgrade preview", true);
        return "current card";
    }

    public AbstractCard getCard() {
        return this.card;
    }

    @Override
    public String getExtrasString() {
        if (this.card.isFlipped || this.card.isLocked) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(CardUtils.getCardCostString(this.card));
        if (this.location == CardLocation.SHOP) {
            sb.append(", " + this.getPriceString());
        }
        return sb.toString();
    }

    @Override
    public String getLabel() {
        if (this.card.isFlipped) {
            return this.localization.localize("face down");
        }
        if (this.card.isLocked) {
            return AbstractCard.LOCKED_STRING;
        }
        return this.card.name;
    }

    public ListPosition getListPosition(ArrayList<AbstractCard> list) {
        if (list == null) {
            return null;
        }
        int index = list.indexOf(this.card);
        if (index < 0) {
            return null;
        }
        return new ListPosition(index, list.size());
    }

    @Override
    public Position getPosition() {
        int cardsPerLine = 5;
        switch (this.location) {
            case HAND: {
                return this.getListPosition(OutputUtils.getPlayer().hand.group);
            }
            case GRID_SELECT: {
                ArrayList grid = AbstractDungeon.gridSelectScreen.targetGroup.group;
                return CardUtils.getGridPosition(this.card, grid, cardsPerLine);
            }
            case HAND_SELECT: {
                HandCardSelectScreen screen = AbstractDungeon.handCardSelectScreen;
                if (screen == null) {
                    return null;
                }
                CardGroup unselectedGroup = (CardGroup)ReflectionHacks.getPrivate((Object)screen, HandCardSelectScreen.class, (String)"hand");
                ArrayList unselected = unselectedGroup.group;
                ArrayList selected = screen.selectedCards.group;
                ListPosition result = this.getListPosition(selected);
                if (result == null) {
                    result = this.getListPosition(unselected);
                }
                return result;
            }
        }
        return super.getPosition();
    }

    public static enum CardLocation {
        CARD_REWARD,
        HAND,
        GRID_SELECT,
        HAND_SELECT,
        MASTER_DECK_VIEW,
        EXHAUST_PILE_VIEW,
        DISCARD_PILE_VIEW,
        DRAW_PILE_VIEW,
        SHOP,
        COMPENDIUM,
        OTHER;

    }
}

