/*
 * Decompiled with CFR 0.152.
 */
package sayTheSpire.ui.effects;

import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.vfx.AbstractGameEffect;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.HashSet;
import sayTheSpire.ui.effects.EffectHandler;
import sayTheSpire.ui.effects.handlers.CardManipulationEffectHandler;
import sayTheSpire.ui.effects.handlers.ObtainKeyEffectHandler;

public class EffectManager {
    private HashMap<Class<? extends AbstractGameEffect>, Class<? extends EffectHandler>> registeredHandlers = new HashMap();
    private HashMap<AbstractGameEffect, EffectHandler> registeredEffects = new HashMap();
    private HashSet<AbstractGameEffect> effects = new HashSet();
    private HashSet<AbstractGameEffect> topLevelEffects = new HashSet();
    private HashSet<AbstractGameEffect> topLevelEffectsQueue = new HashSet();
    private HashSet<AbstractGameEffect> effectsQueue = new HashSet();

    public EffectManager() {
        this.registerHandlers();
    }

    private void addEffect(HashSet<AbstractGameEffect> targetSet, AbstractGameEffect effect) {
        if (this.registeredEffects.containsKey(effect)) {
            return;
        }
        targetSet.add(effect);
        EffectHandler handler = this.getHandlerForEffect(effect);
        if (handler != null) {
            this.registeredEffects.put(effect, handler);
            handler.onAdd();
        }
    }

    private EffectHandler getHandlerForEffect(AbstractGameEffect effect) {
        Class handlerClass = this.registeredHandlers.getOrDefault(effect.getClass(), null);
        if (handlerClass == null) {
            return null;
        }
        try {
            Constructor ctor = handlerClass.getDeclaredConstructor(AbstractGameEffect.class);
            EffectHandler handler = (EffectHandler)ctor.newInstance(effect);
            return handler;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void registerEffectHandler(Class<? extends AbstractGameEffect> effectClass, Class<? extends EffectHandler> handlerClass) {
        this.registeredHandlers.put(effectClass, handlerClass);
    }

    private void registerHandlers() {
        CardManipulationEffectHandler.registerHandlers(this);
        ObtainKeyEffectHandler.registerHandlers(this);
    }

    private void removeEffect(HashSet<AbstractGameEffect> targetSet, AbstractGameEffect effect) {
        targetSet.remove(effect);
        EffectHandler handler = this.registeredEffects.getOrDefault(effect, null);
        if (handler != null) {
            this.registeredEffects.remove(effect);
            handler.onRemove();
        }
    }

    private void updateDiffs(HashSet<AbstractGameEffect> managedSet, HashSet<AbstractGameEffect> gameSet) {
        HashSet<AbstractGameEffect> effectList = new HashSet<AbstractGameEffect>(managedSet);
        effectList.addAll(gameSet);
        for (AbstractGameEffect effect : effectList) {
            if (gameSet.contains(effect) && !managedSet.contains(effect)) {
                this.addEffect(managedSet, effect);
                continue;
            }
            if (gameSet.contains(effect) || !managedSet.contains(effect)) continue;
            this.removeEffect(managedSet, effect);
        }
    }

    public void update() {
        this.updateDiffs(this.effects, new HashSet<AbstractGameEffect>(AbstractDungeon.effectList));
        this.updateDiffs(this.topLevelEffects, new HashSet<AbstractGameEffect>(AbstractDungeon.topLevelEffects));
        this.updateDiffs(this.topLevelEffectsQueue, new HashSet<AbstractGameEffect>(AbstractDungeon.topLevelEffectsQueue));
        this.updateDiffs(this.effectsQueue, new HashSet<AbstractGameEffect>(AbstractDungeon.effectsQueue));
        for (EffectHandler handler : this.registeredEffects.values()) {
            handler.update();
        }
    }
}

